/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SensorOccupied: ImageVector
    get() {
        if (_sensorOccupied != null) {
            return _sensorOccupied!!
        }
        _sensorOccupied = materialIcon(name = "Rounded.SensorOccupied") {
            materialPath {
                moveTo(12.0f, 11.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(9.0f, 6.34f, 9.0f, 8.0f)
                reflectiveCurveTo(10.34f, 11.0f, 12.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                curveToRelative(-1.84f, 0.0f, -3.56f, 0.5f, -5.03f, 1.37f)
                curveTo(6.36f, 13.73f, 6.0f, 14.39f, 6.0f, 15.09f)
                lineTo(6.0f, 16.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                lineToRelative(0.0f, -0.91f)
                curveToRelative(0.0f, -0.7f, -0.36f, -1.36f, -0.97f, -1.72f)
                curveTo(15.56f, 12.5f, 13.84f, 12.0f, 12.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(22.11f, 7.79f)
                lineTo(22.11f, 7.79f)
                curveToRelative(0.55f, -0.23f, 0.78f, -0.88f, 0.5f, -1.41f)
                curveToRelative(-1.13f, -2.12f, -2.87f, -3.86f, -4.99f, -4.99f)
                curveToRelative(-0.52f, -0.28f, -1.17f, -0.04f, -1.4f, 0.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(-0.19f, 0.47f, -0.01f, 1.02f, 0.43f, 1.25f)
                curveToRelative(1.79f, 0.94f, 3.26f, 2.42f, 4.21f, 4.21f)
                curveTo(21.09f, 7.8f, 21.64f, 7.98f, 22.11f, 7.79f)
                close()
            }
            materialPath {
                moveTo(7.79f, 1.89f)
                lineTo(7.79f, 1.89f)
                curveToRelative(-0.23f, -0.55f, -0.88f, -0.78f, -1.4f, -0.5f)
                curveTo(4.27f, 2.52f, 2.52f, 4.26f, 1.4f, 6.38f)
                curveToRelative(-0.28f, 0.52f, -0.05f, 1.18f, 0.5f, 1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.47f, 0.2f, 1.02f, 0.01f, 1.25f, -0.43f)
                curveToRelative(0.94f, -1.79f, 2.42f, -3.26f, 4.21f, -4.21f)
                curveTo(7.8f, 2.91f, 7.98f, 2.36f, 7.79f, 1.89f)
                close()
            }
            materialPath {
                moveTo(1.89f, 16.21f)
                lineTo(1.89f, 16.21f)
                curveToRelative(-0.55f, 0.23f, -0.78f, 0.88f, -0.5f, 1.4f)
                curveToRelative(1.13f, 2.12f, 2.87f, 3.87f, 5.0f, 5.0f)
                curveToRelative(0.52f, 0.28f, 1.17f, 0.04f, 1.4f, -0.5f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.19f, -0.47f, 0.01f, -1.02f, -0.43f, -1.25f)
                curveToRelative(-1.79f, -0.94f, -3.26f, -2.42f, -4.21f, -4.21f)
                curveTo(2.91f, 16.2f, 2.36f, 16.02f, 1.89f, 16.21f)
                close()
            }
            materialPath {
                moveTo(16.21f, 22.11f)
                lineTo(16.21f, 22.11f)
                curveToRelative(0.23f, 0.55f, 0.88f, 0.78f, 1.4f, 0.5f)
                curveToRelative(2.12f, -1.13f, 3.87f, -2.87f, 5.0f, -5.0f)
                curveToRelative(0.28f, -0.52f, 0.04f, -1.17f, -0.5f, -1.4f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.47f, -0.19f, -1.02f, -0.01f, -1.25f, 0.43f)
                curveToRelative(-0.94f, 1.79f, -2.42f, 3.26f, -4.21f, 4.21f)
                curveTo(16.2f, 21.09f, 16.02f, 21.64f, 16.21f, 22.11f)
                close()
            }
        }
        return _sensorOccupied!!
    }

private var _sensorOccupied: ImageVector? = null
