/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NoBackpack: ImageVector
    get() {
        if (_noBackpack != null) {
            return _noBackpack!!
        }
        _noBackpack = materialIcon(name = "Rounded.NoBackpack") {
            materialPath {
                moveTo(6.98f, 4.15f)
                curveToRelative(0.01f, 0.0f, 0.01f, -0.01f, 0.02f, -0.01f)
                verticalLineTo(3.5f)
                curveTo(7.0f, 2.67f, 7.67f, 2.0f, 8.5f, 2.0f)
                reflectiveCurveTo(10.0f, 2.67f, 10.0f, 3.5f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(3.5f)
                curveTo(14.0f, 2.67f, 14.67f, 2.0f, 15.5f, 2.0f)
                reflectiveCurveTo(17.0f, 2.67f, 17.0f, 3.5f)
                verticalLineToRelative(0.64f)
                curveToRelative(1.72f, 0.45f, 3.0f, 2.0f, 3.0f, 3.86f)
                verticalLineToRelative(9.17f)
                lineToRelative(-2.03f, -2.03f)
                curveTo(17.98f, 15.09f, 18.0f, 15.05f, 18.0f, 15.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.17f)
                lineTo(6.98f, 4.15f)
                close()
                moveTo(20.49f, 21.9f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineToRelative(-0.14f, -0.14f)
                curveTo(18.65f, 21.91f, 18.34f, 22.0f, 18.0f, 22.0f)
                horizontalLineTo(6.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -0.36f, 0.06f, -0.69f, 0.15f, -1.02f)
                lineTo(2.1f, 4.93f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(16.97f, 16.97f)
                curveTo(20.88f, 20.88f, 20.88f, 21.51f, 20.49f, 21.9f)
                close()
                moveTo(11.17f, 14.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(11.17f)
                close()
            }
        }
        return _noBackpack!!
    }

private var _noBackpack: ImageVector? = null
