/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FilterFrames: ImageVector
    get() {
        if (_filterFrames != null) {
            return _filterFrames!!
        }
        _filterFrames = materialIcon(name = "Outlined.FilterFrames") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineToRelative(-4.0f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-4.0f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(22.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(20.0f, 20.0f)
                lineTo(4.0f, 20.0f)
                lineTo(4.0f, 6.0f)
                horizontalLineToRelative(4.52f)
                lineToRelative(3.52f, -3.5f)
                lineTo(15.52f, 6.0f)
                lineTo(20.0f, 6.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(6.0f, 18.0f)
                horizontalLineToRelative(12.0f)
                lineTo(18.0f, 8.0f)
                lineTo(6.0f, 8.0f)
                verticalLineToRelative(10.0f)
                close()
                moveTo(8.0f, 10.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(6.0f)
                lineTo(8.0f, 16.0f)
                verticalLineToRelative(-6.0f)
                close()
            }
        }
        return _filterFrames!!
    }

private var _filterFrames: ImageVector? = null
