/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.BreakfastDining: ImageVector
    get() {
        if (_breakfastDining != null) {
            return _breakfastDining!!
        }
        _breakfastDining = materialIcon(name = "Outlined.BreakfastDining") {
            materialPath {
                moveTo(18.0f, 3.0f)
                horizontalLineTo(6.0f)
                curveTo(3.79f, 3.0f, 2.0f, 4.79f, 2.0f, 7.0f)
                curveToRelative(0.0f, 1.48f, 0.81f, 2.75f, 2.0f, 3.45f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-8.55f)
                curveToRelative(1.19f, -0.69f, 2.0f, -1.97f, 2.0f, -3.45f)
                curveTo(22.0f, 4.79f, 20.21f, 3.0f, 18.0f, 3.0f)
                close()
                moveTo(19.0f, 8.72f)
                lineTo(18.0f, 9.3f)
                verticalLineTo(19.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(9.31f)
                lineTo(5.01f, 8.73f)
                curveTo(4.38f, 8.35f, 4.0f, 7.71f, 4.0f, 7.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(20.0f, 7.71f, 19.62f, 8.36f, 19.0f, 8.72f)
                close()
            }
            materialPath {
                moveTo(12.71f, 9.29f)
                curveTo(12.51f, 9.1f, 12.26f, 9.0f, 12.0f, 9.0f)
                reflectiveCurveToRelative(-0.51f, 0.1f, -0.71f, 0.29f)
                lineToRelative(-3.0f, 3.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.0f, 3.0f)
                curveTo(11.49f, 16.9f, 11.74f, 17.0f, 12.0f, 17.0f)
                reflectiveCurveToRelative(0.51f, -0.1f, 0.71f, -0.29f)
                lineToRelative(3.0f, -3.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(12.71f, 9.29f)
                close()
                moveTo(12.0f, 14.58f)
                lineTo(10.41f, 13.0f)
                lineTo(12.0f, 11.41f)
                lineTo(13.59f, 13.0f)
                lineTo(12.0f, 14.58f)
                close()
            }
        }
        return _breakfastDining!!
    }

private var _breakfastDining: ImageVector? = null
