/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MoreTime: ImageVector
    get() {
        if (_moreTime != null) {
            return _moreTime!!
        }
        _moreTime = materialIcon(name = "Filled.MoreTime") {
            materialPath {
                moveTo(10.0f, 8.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(4.7f, 2.9f)
                lineToRelative(0.8f, -1.2f)
                lineToRelative(-4.0f, -2.4f)
                lineToRelative(0.0f, -5.3f)
                close()
            }
            materialPath {
                moveTo(17.92f, 12.0f)
                curveToRelative(0.05f, 0.33f, 0.08f, 0.66f, 0.08f, 1.0f)
                curveToRelative(0.0f, 3.9f, -3.1f, 7.0f, -7.0f, 7.0f)
                reflectiveCurveToRelative(-7.0f, -3.1f, -7.0f, -7.0f)
                curveToRelative(0.0f, -3.9f, 3.1f, -7.0f, 7.0f, -7.0f)
                curveToRelative(0.7f, 0.0f, 1.37f, 0.1f, 2.0f, 0.29f)
                verticalLineTo(4.23f)
                curveTo(12.36f, 4.08f, 11.69f, 4.0f, 11.0f, 4.0f)
                curveToRelative(-5.0f, 0.0f, -9.0f, 4.0f, -9.0f, 9.0f)
                reflectiveCurveToRelative(4.0f, 9.0f, 9.0f, 9.0f)
                reflectiveCurveToRelative(9.0f, -4.0f, 9.0f, -9.0f)
                curveToRelative(0.0f, -0.34f, -0.02f, -0.67f, -0.06f, -1.0f)
                horizontalLineTo(17.92f)
                close()
            }
            materialPath {
                moveTo(20.0f, 5.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                close()
            }
        }
        return _moreTime!!
    }

private var _moreTime: ImageVector? = null
