/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.InvertColorsOff: ImageVector
    get() {
        if (_invertColorsOff != null) {
            return _invertColorsOff!!
        }
        _invertColorsOff = materialIcon(name = "Filled.InvertColorsOff") {
            materialPath {
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(4.2f, 4.2f)
                curveToRelative(-1.0f, 1.31f, -1.6f, 2.94f, -1.6f, 4.7f)
                curveTo(4.0f, 17.48f, 7.58f, 21.0f, 12.0f, 21.0f)
                curveToRelative(1.75f, 0.0f, 3.36f, -0.56f, 4.67f, -1.5f)
                lineToRelative(3.1f, 3.1f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(12.0f, 19.0f)
                curveToRelative(-3.31f, 0.0f, -6.0f, -2.63f, -6.0f, -5.87f)
                curveToRelative(0.0f, -1.19f, 0.36f, -2.32f, 1.02f, -3.28f)
                lineTo(12.0f, 14.83f)
                verticalLineTo(19.0f)
                close()
                moveTo(8.38f, 5.56f)
                lineTo(12.0f, 2.0f)
                lineToRelative(5.65f, 5.56f)
                lineToRelative(0.0f, 0.0f)
                curveTo(19.1f, 8.99f, 20.0f, 10.96f, 20.0f, 13.13f)
                curveToRelative(0.0f, 1.18f, -0.27f, 2.29f, -0.74f, 3.3f)
                lineTo(12.0f, 9.17f)
                verticalLineTo(4.81f)
                lineTo(9.8f, 6.97f)
                lineTo(8.38f, 5.56f)
                close()
            }
        }
        return _invertColorsOff!!
    }

private var _invertColorsOff: ImageVector? = null
