/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.HdrAutoSelect: ImageVector
    get() {
        if (_hdrAutoSelect != null) {
            return _hdrAutoSelect!!
        }
        _hdrAutoSelect = materialIcon(name = "Filled.HdrAutoSelect") {
            materialPath {
                moveTo(10.0f, 16.0f)
                horizontalLineTo(6.5f)
                verticalLineToRelative(6.0f)
                horizontalLineTo(10.0f)
                curveToRelative(0.8f, 0.0f, 1.5f, -0.7f, 1.5f, -1.5f)
                verticalLineToRelative(-3.0f)
                curveTo(11.5f, 16.7f, 10.8f, 16.0f, 10.0f, 16.0f)
                close()
                moveTo(10.0f, 20.5f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.5f)
                close()
            }
            materialPath {
                moveTo(16.5f, 16.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.1f)
                lineToRelative(0.9f, 2.0f)
                horizontalLineTo(18.0f)
                lineToRelative(-0.9f, -2.1f)
                curveToRelative(0.5f, -0.3f, 0.9f, -0.8f, 0.9f, -1.4f)
                verticalLineToRelative(-1.0f)
                curveTo(18.0f, 16.7f, 17.3f, 16.0f, 16.5f, 16.0f)
                close()
                moveTo(16.5f, 18.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(18.5f)
                close()
            }
            materialPath {
                moveTo(3.5f, 18.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(0.0f, -2.5f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, 2.5f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(-1.5f, 0.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 18.5f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 1.5f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -1.5f)
                close()
            }
            materialPath {
                moveTo(11.97f, 5.3f)
                lineToRelative(-1.02f, 2.89f)
                lineToRelative(2.1f, 0.0f)
                lineToRelative(-1.02f, -2.89f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(8.69f, 2.0f, 6.0f, 4.69f, 6.0f, 8.0f)
                reflectiveCurveToRelative(2.69f, 6.0f, 6.0f, 6.0f)
                reflectiveCurveToRelative(6.0f, -2.69f, 6.0f, -6.0f)
                reflectiveCurveTo(15.31f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(14.04f, 11.0f)
                lineToRelative(-0.63f, -1.79f)
                horizontalLineToRelative(-2.83f)
                lineTo(9.96f, 11.0f)
                horizontalLineTo(8.74f)
                lineToRelative(2.63f, -7.0f)
                horizontalLineToRelative(1.25f)
                lineToRelative(2.63f, 7.0f)
                horizontalLineTo(14.04f)
                close()
            }
        }
        return _hdrAutoSelect!!
    }

private var _hdrAutoSelect: ImageVector? = null
