/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Attractions: ImageVector
    get() {
        if (_attractions != null) {
            return _attractions!!
        }
        _attractions = materialIcon(name = "Filled.Attractions") {
            materialPath {
                moveTo(10.43f, 18.75f)
                curveTo(10.8f, 18.29f, 11.37f, 18.0f, 12.0f, 18.0f)
                curveToRelative(0.63f, 0.0f, 1.19f, 0.29f, 1.56f, 0.75f)
                curveToRelative(0.39f, -0.09f, 0.76f, -0.21f, 1.12f, -0.36f)
                lineToRelative(-1.42f, -3.18f)
                curveToRelative(-0.39f, 0.15f, -0.82f, 0.23f, -1.26f, 0.23f)
                curveToRelative(-0.46f, 0.0f, -0.9f, -0.09f, -1.3f, -0.25f)
                lineToRelative(-1.43f, 3.19f)
                curveTo(9.65f, 18.54f, 10.03f, 18.67f, 10.43f, 18.75f)
                close()
                moveTo(5.15f, 10.0f)
                curveToRelative(-0.16f, 0.59f, -0.25f, 1.21f, -0.25f, 1.85f)
                curveToRelative(0.0f, 0.75f, 0.12f, 1.47f, 0.33f, 2.15f)
                curveToRelative(0.63f, 0.05f, 1.22f, 0.4f, 1.56f, 0.99f)
                curveToRelative(0.33f, 0.57f, 0.35f, 1.23f, 0.11f, 1.79f)
                curveToRelative(0.27f, 0.27f, 0.56f, 0.53f, 0.87f, 0.76f)
                lineToRelative(1.52f, -3.39f)
                verticalLineToRelative(0.0f)
                curveToRelative(-0.47f, -0.58f, -0.75f, -1.32f, -0.75f, -2.13f)
                curveToRelative(0.0f, -1.89f, 1.55f, -3.41f, 3.46f, -3.41f)
                curveToRelative(1.91f, 0.0f, 3.46f, 1.53f, 3.46f, 3.41f)
                curveToRelative(0.0f, 0.82f, -0.29f, 1.57f, -0.78f, 2.16f)
                lineToRelative(1.5f, 3.35f)
                curveToRelative(0.32f, -0.24f, 0.62f, -0.5f, 0.9f, -0.79f)
                curveToRelative(-0.22f, -0.55f, -0.2f, -1.2f, 0.12f, -1.75f)
                curveToRelative(0.33f, -0.57f, 0.9f, -0.92f, 1.52f, -0.99f)
                curveToRelative(0.22f, -0.68f, 0.34f, -1.41f, 0.34f, -2.16f)
                curveToRelative(0.0f, -0.64f, -0.09f, -1.27f, -0.25f, -1.86f)
                curveToRelative(-0.64f, -0.04f, -1.26f, -0.39f, -1.6f, -1.0f)
                curveToRelative(-0.36f, -0.62f, -0.35f, -1.36f, -0.03f, -1.95f)
                curveToRelative(-0.91f, -0.98f, -2.1f, -1.71f, -3.44f, -2.05f)
                curveTo(13.39f, 5.6f, 12.74f, 6.0f, 12.0f, 6.0f)
                curveToRelative(-0.74f, 0.0f, -1.39f, -0.41f, -1.74f, -1.01f)
                curveTo(8.92f, 5.33f, 7.73f, 6.04f, 6.82f, 7.02f)
                curveTo(7.15f, 7.62f, 7.17f, 8.37f, 6.8f, 9.0f)
                curveTo(6.45f, 9.62f, 5.81f, 9.97f, 5.15f, 10.0f)
                close()
                moveTo(3.85f, 9.58f)
                curveTo(3.07f, 8.98f, 2.83f, 7.88f, 3.34f, 7.0f)
                curveToRelative(0.51f, -0.88f, 1.58f, -1.23f, 2.49f, -0.85f)
                curveToRelative(1.11f, -1.17f, 2.56f, -2.03f, 4.18f, -2.42f)
                curveTo(10.15f, 2.75f, 10.99f, 2.0f, 12.0f, 2.0f)
                curveToRelative(1.01f, 0.0f, 1.85f, 0.75f, 1.98f, 1.73f)
                curveToRelative(1.63f, 0.39f, 3.07f, 1.24f, 4.18f, 2.42f)
                curveToRelative(0.91f, -0.38f, 1.99f, -0.03f, 2.49f, 0.85f)
                curveToRelative(0.51f, 0.88f, 0.27f, 1.98f, -0.51f, 2.58f)
                curveToRelative(0.23f, 0.77f, 0.35f, 1.58f, 0.35f, 2.42f)
                reflectiveCurveToRelative(-0.12f, 1.65f, -0.35f, 2.42f)
                curveToRelative(0.78f, 0.6f, 1.02f, 1.7f, 0.51f, 2.58f)
                curveToRelative(-0.51f, 0.88f, -1.58f, 1.23f, -2.49f, 0.85f)
                curveToRelative(-0.4f, 0.43f, -0.85f, 0.81f, -1.34f, 1.15f)
                lineToRelative(1.34f, 3.0f)
                horizontalLineTo(16.3f)
                lineToRelative(-0.97f, -2.17f)
                curveToRelative(-0.43f, 0.18f, -0.88f, 0.33f, -1.34f, 0.44f)
                curveTo(13.85f, 21.25f, 13.01f, 22.0f, 12.0f, 22.0f)
                curveToRelative(-1.01f, 0.0f, -1.85f, -0.75f, -1.98f, -1.73f)
                curveTo(9.54f, 20.15f, 9.08f, 20.0f, 8.64f, 19.81f)
                lineTo(7.66f, 22.0f)
                horizontalLineTo(5.78f)
                lineToRelative(1.36f, -3.03f)
                curveToRelative(-0.47f, -0.33f, -0.91f, -0.71f, -1.3f, -1.12f)
                curveTo(4.92f, 18.23f, 3.85f, 17.88f, 3.34f, 17.0f)
                curveToRelative(-0.51f, -0.88f, -0.27f, -1.98f, 0.51f, -2.58f)
                curveTo(3.62f, 13.65f, 3.5f, 12.84f, 3.5f, 12.0f)
                reflectiveCurveTo(3.62f, 10.35f, 3.85f, 9.58f)
                close()
            }
        }
        return _attractions!!
    }

private var _attractions: ImageVector? = null
