/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.gradle;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.gradle.ClasspathSnapshot;
import org.jetbrains.compose.reload.gradle.ClasspathSnapshotKt;
import org.jetbrains.compose.reload.gradle.ComposeHotReloadOtherTask;
import org.jetbrains.compose.reload.gradle.JarSnapshot;
import org.jetbrains.compose.reload.gradle.ZipFileChange;
import org.jetbrains.compose.reload.gradle.ZipFileChanges;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@DisableCachingByDefault(because="Should always run")
@InternalHotReloadApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/compose/reload/gradle/ComposeHotSnapshotTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/jetbrains/compose/reload/gradle/ComposeHotReloadOtherTask;", "<init>", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "classpathSnapshotFile", "Lorg/gradle/api/file/RegularFileProperty;", "getClasspathSnapshotFile", "()Lorg/gradle/api/file/RegularFileProperty;", "pendingRequestFile", "getPendingRequestFile", "classesDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getClassesDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "execute", "", "inputs", "Lorg/gradle/work/InputChanges;", "resolveChangedFile", "Lkotlin/Pair;", "Ljava/io/File;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage$ReloadClassesRequest$ChangeType;", "change", "Lorg/gradle/work/FileChange;", "resolveChangedJar", "", "classpathSnapshot", "Lorg/jetbrains/compose/reload/gradle/ClasspathSnapshot;", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nhotSnapshotTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 hotSnapshotTask.kt\norg/jetbrains/compose/reload/gradle/ComposeHotSnapshotTask\n+ 2 utils.kt\norg/jetbrains/compose/reload/gradle/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n149#2,3:201\n157#2,4:206\n1863#3,2:204\n1557#3:211\n1628#3,3:212\n1279#3,2:215\n1293#3,4:217\n1863#3,2:221\n1#4:210\n*S KotlinDebug\n*F\n+ 1 hotSnapshotTask.kt\norg/jetbrains/compose/reload/gradle/ComposeHotSnapshotTask\n*L\n103#1:201,3\n115#1:206,4\n106#1:204,2\n148#1:211\n148#1:212,3\n152#1:215,2\n152#1:217,4\n164#1:221,2\n*E\n"})
public abstract class ComposeHotSnapshotTask
extends DefaultTask
implements ComposeHotReloadOtherTask {
    @NotNull
    private final ConfigurableFileCollection classpath;
    @NotNull
    private final RegularFileProperty classpathSnapshotFile;
    @NotNull
    private final RegularFileProperty pendingRequestFile;
    @NotNull
    private final DirectoryProperty classesDirectory;

    public ComposeHotSnapshotTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.classpath = configurableFileCollection;
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"fileProperty(...)");
        this.classpathSnapshotFile = regularFileProperty;
        RegularFileProperty regularFileProperty2 = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"fileProperty(...)");
        this.pendingRequestFile = regularFileProperty2;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"directoryProperty(...)");
        this.classesDirectory = directoryProperty;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @NotNull
    public final ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getClasspathSnapshotFile() {
        return this.classpathSnapshotFile;
    }

    @Internal
    @NotNull
    public final RegularFileProperty getPendingRequestFile() {
        return this.pendingRequestFile;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getClassesDirectory() {
        return this.classesDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void execute(@NotNull InputChanges inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        Path classpathSnapshotFile = ((RegularFile)this.classpathSnapshotFile.get()).getAsFile().toPath();
        Path pendingRequestFile = ((RegularFile)this.pendingRequestFile.get()).getAsFile().toPath();
        if (!inputs.isIncremental()) {
            this.getLogger().info("Non-incremental run: Taking classpath snapshot");
            Intrinsics.checkNotNull((Object)classpathSnapshotFile);
            ClasspathSnapshotKt.writeClasspathSnapshot(classpathSnapshotFile, ClasspathSnapshotKt.ClasspathSnapshot((Iterable)this.classpath));
            Intrinsics.checkNotNull((Object)pendingRequestFile);
            Files.deleteIfExists(pendingRequestFile);
            return;
        }
        this.getLogger().info("Incremental run: Reloading classes");
        Intrinsics.checkNotNull((Object)classpathSnapshotFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        ClasspathSnapshot snapshot = Files.exists(classpathSnapshotFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? ClasspathSnapshotKt.readClasspathSnapshot(classpathSnapshotFile) : ClasspathSnapshotKt.ClasspathSnapshot((Iterable)this.classpath);
        try {
            void $this$writeObject$iv;
            Map map;
            Object object;
            Intrinsics.checkNotNull((Object)pendingRequestFile);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(pendingRequestFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Path $this$readObject$iv = pendingRequestFile;
                boolean $i$f$readObject = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream($this$readObject$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = new ObjectInputStream(inputStream);
                object = null;
                try {
                    ObjectInputStream ois$iv = (ObjectInputStream)closeable;
                    boolean bl = false;
                    Object object2 = ois$iv.readObject();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.compose.reload.orchestration.OrchestrationMessage.ReloadClassesRequest");
                    }
                    ois$iv = (OrchestrationMessage.ReloadClassesRequest)object2;
                }
                catch (Throwable ois$iv) {
                    object = ois$iv;
                    throw ois$iv;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                map = MapsKt.toMutableMap((Map)ois$iv.getChangedClassFiles());
            } else {
                map = new LinkedHashMap();
            }
            Map changedFiles = map;
            Iterable iterable = inputs.getFileChanges((FileCollection)this.classpath);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileChange change = (FileChange)element$iv;
                boolean bl = false;
                File file = change.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"jar")) {
                    Intrinsics.checkNotNull((Object)change);
                    changedFiles.putAll(this.resolveChangedJar(snapshot, change));
                    continue;
                }
                Map map2 = changedFiles;
                Intrinsics.checkNotNull((Object)change);
                Pair<File, OrchestrationMessage.ReloadClassesRequest.ChangeType> pair = this.resolveChangedFile(change);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            $this$forEach$iv = PathsKt.createParentDirectories((Path)pendingRequestFile, (FileAttribute[])new FileAttribute[0]);
            Serializable value$iv = (Serializable)new OrchestrationMessage.ReloadClassesRequest(changedFiles);
            boolean $i$f$writeObject = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream((Path)$this$writeObject$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            object = new ObjectOutputStream(outputStream);
            Throwable throwable = null;
            try {
                ObjectOutputStream oos$iv = (ObjectOutputStream)object;
                boolean bl = false;
                oos$iv.writeObject(value$iv);
                oos$iv.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            ClasspathSnapshotKt.writeClasspathSnapshot(PathsKt.createParentDirectories((Path)classpathSnapshotFile, (FileAttribute[])new FileAttribute[0]), snapshot);
        }
        catch (Throwable t) {
            this.getLogger().error("Failed to reload classes", t);
            ComposeHotSnapshotTask composeHotSnapshotTask = this;
            try {
                ComposeHotSnapshotTask $this$execute_u24lambda_u241 = composeHotSnapshotTask;
                boolean bl = false;
                Object object = Result.constructor-impl((Object)Files.deleteIfExists(classpathSnapshotFile));
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            throw t;
        }
    }

    private final Pair<File, OrchestrationMessage.ReloadClassesRequest.ChangeType> resolveChangedFile(FileChange change) {
        OrchestrationMessage.ReloadClassesRequest.ChangeType changeType;
        ChangeType changeType2 = change.getChangeType();
        switch (changeType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[changeType2.ordinal()]) {
            case 1: {
                changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Added;
                break;
            }
            case 2: {
                changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified;
                break;
            }
            case 3: {
                changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        OrchestrationMessage.ReloadClassesRequest.ChangeType changeType3 = changeType;
        File dynamicClasspathFile = ((RegularFile)this.classesDirectory.file(change.getNormalizedPath()).get()).getAsFile().getAbsoluteFile();
        switch (WhenMappings.$EnumSwitchMapping$1[changeType3.ordinal()]) {
            case 1: 
            case 2: {
                File file = change.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                Intrinsics.checkNotNull((Object)dynamicClasspathFile);
                Comparable<Boolean> comparable = FilesKt.copyTo$default((File)file, (File)dynamicClasspathFile, (boolean)true, (int)0, (int)4, null);
                break;
            }
            case 3: {
                Comparable<Boolean> comparable = dynamicClasspathFile.delete();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.getLogger().trace("[" + change.getChangeType() + "] " + change.getFile());
        return TuplesKt.to((Object)dynamicClasspathFile, (Object)changeType3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<File, OrchestrationMessage.ReloadClassesRequest.ChangeType> resolveChangedJar(ClasspathSnapshot classpathSnapshot, FileChange change) {
        if (change.getChangeType() == ChangeType.REMOVED) {
            void $this$associateWith$iv;
            File entry;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            JarSnapshot removed;
            File file = change.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            JarSnapshot jarSnapshot = removed = classpathSnapshot.remove(file);
            Collection collection = jarSnapshot != null ? jarSnapshot.entries() : null;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable iterable = collection;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                File file2 = ((RegularFile)this.classesDirectory.file((String)((Object)entry)).get()).getAsFile();
                Path path = file2.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                Files.deleteIfExists(path);
                object.add(file2.getAbsoluteFile());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                entry = (File)element$iv$iv;
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                OrchestrationMessage.ReloadClassesRequest.ChangeType changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed;
                object.put(t, changeType);
            }
            return result$iv;
        }
        if (change.getChangeType() == ChangeType.MODIFIED || change.getChangeType() == ChangeType.ADDED) {
            JarSnapshot jarSnapshot;
            Map result = new LinkedHashMap();
            File file = change.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            JarSnapshot jarSnapshot2 = classpathSnapshot.get(file);
            if (jarSnapshot2 == null) {
                jarSnapshot2 = new JarSnapshot(null, 1, null);
            }
            JarSnapshot previousSnapshot = jarSnapshot2;
            AutoCloseable autoCloseable = new ZipFile(change.getFile());
            Throwable throwable = null;
            try {
                ZipFile zip = (ZipFile)autoCloseable;
                boolean bl = false;
                ZipFileChanges resolvedChanges = ClasspathSnapshotKt.resolveChanges(zip, previousSnapshot);
                Iterable $this$forEach$iv = resolvedChanges.getChanges();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipFileChange change2 = (ZipFileChange)element$iv;
                    boolean bl2 = false;
                    File targetFile = ((RegularFile)this.classesDirectory.file(change2.getEntryName()).get()).getAsFile();
                    ZipFileChange zipFileChange = change2;
                    if (zipFileChange instanceof ZipFileChange.Removed) {
                        Path path = targetFile.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                        Files.deleteIfExists(path);
                        result.put(targetFile, OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed);
                        continue;
                    }
                    if (zipFileChange instanceof ZipFileChange.Added) {
                        ComposeHotSnapshotTask.resolveChangedJar$lambda$7$lambda$6$copyTargetFile(zip, targetFile, ((ZipFileChange.Added)change2).getEntry());
                        result.put(targetFile, OrchestrationMessage.ReloadClassesRequest.ChangeType.Added);
                        continue;
                    }
                    if (zipFileChange instanceof ZipFileChange.Modified) {
                        ComposeHotSnapshotTask.resolveChangedJar$lambda$7$lambda$6$copyTargetFile(zip, targetFile, ((ZipFileChange.Modified)change2).getEntry());
                        result.put(targetFile, OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified);
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                jarSnapshot = resolvedChanges.getSnapshot();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            JarSnapshot newSnapshot = jarSnapshot;
            File file3 = change.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getFile(...)");
            classpathSnapshot.set(file3, newSnapshot);
            return result;
        }
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void resolveChangedJar$lambda$7$lambda$6$copyTargetFile(ZipFile $zip, File targetFile, ZipEntry entry) {
        AutoCloseable autoCloseable = $zip.getInputStream(entry);
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)autoCloseable;
            boolean bl = false;
            Path path = targetFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Object object = PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            Object object2 = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            object = outputStream;
            object2 = null;
            try {
                OutputStream output = (OutputStream)object;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)input);
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                object2 = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object2);
            }
            long l2 = l;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ChangeType.values().length];
            try {
                nArray[ChangeType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.MODIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OrchestrationMessage.ReloadClassesRequest.ChangeType.values().length];
            try {
                nArray[OrchestrationMessage.ReloadClassesRequest.ChangeType.Added.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

