/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.ComposePlugin;
import org.jetbrains.compose.reload.ComposeHotReloadPlugin;
import org.jetbrains.compose.reload.ErrorMessages;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0004"}, d2={"hasComposePluginAccess", "", "Lorg/gradle/api/Project;", "hasKotlinPluginAccess", "hot-reload-gradle-plugin"})
public final class CheckPluginAccessKt {
    public static final boolean hasComposePluginAccess(@NotNull Project $this$hasComposePluginAccess) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasComposePluginAccess, (String)"<this>");
        try {
            if (!Intrinsics.areEqual(Class.forName(ComposePlugin.class.getName(), false, ComposeHotReloadPlugin.class.getClassLoader()), ComposePlugin.class)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Logger logger = $this$hasComposePluginAccess.getLogger();
            Project project = $this$hasComposePluginAccess.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            logger.error(ErrorMessages.INSTANCE.inaccessibleComposePlugin(project));
            bl = false;
        }
        return bl;
    }

    public static final boolean hasKotlinPluginAccess(@NotNull Project $this$hasKotlinPluginAccess) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasKotlinPluginAccess, (String)"<this>");
        try {
            if (!Intrinsics.areEqual(Class.forName(KotlinPluginWrapper.class.getName(), false, ComposeHotReloadPlugin.class.getClassLoader()), KotlinPluginWrapper.class)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Logger logger = $this$hasKotlinPluginAccess.getLogger();
            Project project = $this$hasKotlinPluginAccess.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            logger.error(ErrorMessages.INSTANCE.inaccessibleKotlinPlugin(project));
            bl = false;
        }
        return bl;
    }
}

