/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.annotation.VisibleForTesting;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.ValidatingOffsetMapping;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TransformedText;
import androidx.compose.ui.text.input.VisualTransformation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001e\u0010\u0012\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0007H\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0014"}, d2={"ValidatingEmptyOffsetMappingIdentity", "Landroidx/compose/ui/text/input/OffsetMapping;", "getValidatingEmptyOffsetMappingIdentity", "()Landroidx/compose/ui/text/input/OffsetMapping;", "validateOriginalToTransformed", "", "transformedOffset", "", "transformedLength", "offset", "validateTransformedToOriginal", "originalOffset", "originalLength", "filterWithValidation", "Landroidx/compose/ui/text/input/TransformedText;", "Landroidx/compose/ui/text/input/VisualTransformation;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "throwIfNotValidTransform", "limit", "foundation"})
@SourceDebugExtension(value={"SMAP\nValidatingOffsetMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidatingOffsetMapping.kt\nandroidx/compose/foundation/text/ValidatingOffsetMappingKt\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n*L\n1#1,135:1\n50#2,5:136\n50#2,5:141\n*S KotlinDebug\n*F\n+ 1 ValidatingOffsetMapping.kt\nandroidx/compose/foundation/text/ValidatingOffsetMappingKt\n*L\n117#1:136,5\n129#1:141,5\n*E\n"})
public final class ValidatingOffsetMappingKt {
    @NotNull
    private static final OffsetMapping ValidatingEmptyOffsetMappingIdentity = new ValidatingOffsetMapping(OffsetMapping.Companion.getIdentity(), 0, 0);

    @NotNull
    public static final OffsetMapping getValidatingEmptyOffsetMappingIdentity() {
        return ValidatingEmptyOffsetMappingIdentity;
    }

    @NotNull
    public static final TransformedText filterWithValidation(@NotNull VisualTransformation $this$filterWithValidation, @NotNull AnnotatedString text) {
        Intrinsics.checkNotNullParameter((Object)$this$filterWithValidation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TransformedText delegate = $this$filterWithValidation.filter(text);
        ValidatingOffsetMappingKt.throwIfNotValidTransform$default(delegate, text.length(), 0, 2, null);
        return new TransformedText(delegate.getText(), (OffsetMapping)new ValidatingOffsetMapping(delegate.getOffsetMapping(), text.length(), delegate.getText().length()));
    }

    @VisibleForTesting
    public static final void throwIfNotValidTransform(@NotNull TransformedText $this$throwIfNotValidTransform, int originalLength, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIfNotValidTransform, (String)"<this>");
        int transformedLength = $this$throwIfNotValidTransform.getText().length();
        int n = Math.min(originalLength, limit);
        for (int offset = 0; offset < n; ++offset) {
            int transformedOffset = $this$throwIfNotValidTransform.getOffsetMapping().originalToTransformed(offset);
            ValidatingOffsetMappingKt.validateOriginalToTransformed(transformedOffset, transformedLength, offset);
        }
        int transformedOffset = $this$throwIfNotValidTransform.getOffsetMapping().originalToTransformed(originalLength);
        ValidatingOffsetMappingKt.validateOriginalToTransformed(transformedOffset, transformedLength, originalLength);
        int n2 = Math.min(transformedLength, limit);
        for (int offset = 0; offset < n2; ++offset) {
            int originalOffset = $this$throwIfNotValidTransform.getOffsetMapping().transformedToOriginal(offset);
            ValidatingOffsetMappingKt.validateTransformedToOriginal(originalOffset, originalLength, offset);
        }
        int originalOffset = $this$throwIfNotValidTransform.getOffsetMapping().transformedToOriginal(transformedLength);
        ValidatingOffsetMappingKt.validateTransformedToOriginal(originalOffset, originalLength, transformedLength);
    }

    public static /* synthetic */ void throwIfNotValidTransform$default(TransformedText transformedText, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 100;
        }
        ValidatingOffsetMappingKt.throwIfNotValidTransform(transformedText, n, n2);
    }

    private static final void validateTransformedToOriginal(int originalOffset, int originalLength, int offset) {
        boolean value$iv = 0 <= originalOffset ? originalOffset <= originalLength : false;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("OffsetMapping.transformedToOriginal returned invalid mapping: " + offset + " -> " + originalOffset + " is not in range of original text [0, " + originalLength + "]");
        }
    }

    private static final void validateOriginalToTransformed(int transformedOffset, int transformedLength, int offset) {
        boolean value$iv = 0 <= transformedOffset ? transformedOffset <= transformedLength : false;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("OffsetMapping.originalToTransformed returned invalid mapping: " + offset + " -> " + transformedOffset + " is not in range of transformed text [0, " + transformedLength + "]");
        }
    }

    public static final /* synthetic */ void access$validateOriginalToTransformed(int transformedOffset, int transformedLength, int offset) {
        ValidatingOffsetMappingKt.validateOriginalToTransformed(transformedOffset, transformedLength, offset);
    }

    public static final /* synthetic */ void access$validateTransformedToOriginal(int originalOffset, int originalLength, int offset) {
        ValidatingOffsetMappingKt.validateTransformedToOriginal(originalOffset, originalLength, offset);
    }
}

