/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.gestures.snapping.SnapPositionKt;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.lazy.layout.LazyLayoutMeasureScope;
import androidx.compose.foundation.lazy.layout.ObservableScopeInvalidator;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLazyLayoutItemProvider;
import androidx.compose.foundation.pager.PagerMeasureKt;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.runtime.MutableState;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00ac\u0001\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aH\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u001aH\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0015H\u0002\u001a@\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0015H\u0002\u001a\u0017\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0082\b\u001a\u008c\u0001\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0002\u001aj\u0010\u0014\u001a\u00020\u0004*\u00020\u001f2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010(\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u0010*\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0006H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b=\u0010>\u001a\u00f1\u0001\u0010?\u001a\u00020@*\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u00103\u001a\u0002042\u0006\u0010A\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\u00062\u0006\u0010D\u001a\u0002022\u0006\u0010(\u001a\u00020)2\b\u00109\u001a\u0004\u0018\u00010:2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010*\u001a\u00020+2\u0006\u00105\u001a\u0002062\u0006\u0010/\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2/\u0010I\u001a+\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020\u00190\u0015\u00a2\u0006\u0002\bL\u0012\u0004\u0012\u00020M0JH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\bN\u0010O\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006P"}, d2={"MaxPageOffset", "", "MinPageOffset", "calculateNewCurrentPage", "Landroidx/compose/foundation/pager/MeasuredPage;", "viewportSize", "", "visiblePagesInfo", "", "beforeContentPadding", "afterContentPadding", "itemSize", "snapPosition", "Landroidx/compose/foundation/gestures/snapping/SnapPosition;", "pageCount", "createPagesAfterList", "currentLastPage", "pagesCount", "beyondViewportPageCount", "pinnedPages", "getAndMeasure", "Lkotlin/Function1;", "createPagesBeforeList", "currentFirstPage", "debugLog", "", "generateMsg", "Lkotlin/Function0;", "", "calculatePagesOffsets", "", "Landroidx/compose/foundation/lazy/layout/LazyLayoutMeasureScope;", "pages", "extraPagesBefore", "extraPagesAfter", "layoutWidth", "layoutHeight", "finalMainAxisOffset", "maxOffset", "pagesScrollOffset", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "reverseLayout", "", "density", "Landroidx/compose/ui/unit/Density;", "spaceBetweenPages", "pageAvailableSize", "index", "childConstraints", "Landroidx/compose/ui/unit/Constraints;", "pagerItemProvider", "Landroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;", "visualPageOffset", "Landroidx/compose/ui/unit/IntOffset;", "horizontalAlignment", "Landroidx/compose/ui/Alignment$Horizontal;", "verticalAlignment", "Landroidx/compose/ui/Alignment$Vertical;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getAndMeasure-SGf7dI0", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutMeasureScope;IJLandroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;JLandroidx/compose/foundation/gestures/Orientation;Landroidx/compose/ui/Alignment$Horizontal;Landroidx/compose/ui/Alignment$Vertical;Landroidx/compose/ui/unit/LayoutDirection;ZI)Landroidx/compose/foundation/pager/MeasuredPage;", "measurePager", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "mainAxisAvailableSize", "currentPage", "currentPageOffset", "constraints", "placementScopeInvalidator", "Landroidx/compose/foundation/lazy/layout/ObservableScopeInvalidator;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "layout", "Lkotlin/Function3;", "Landroidx/compose/ui/layout/Placeable$PlacementScope;", "Lkotlin/ExtensionFunctionType;", "Landroidx/compose/ui/layout/MeasureResult;", "measurePager-bmk8ZPk", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutMeasureScope;ILandroidx/compose/foundation/pager/PagerLazyLayoutItemProvider;IIIIIIJLandroidx/compose/foundation/gestures/Orientation;Landroidx/compose/ui/Alignment$Vertical;Landroidx/compose/ui/Alignment$Horizontal;ZJIILjava/util/List;Landroidx/compose/foundation/gestures/snapping/SnapPosition;Landroidx/compose/runtime/MutableState;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function3;)Landroidx/compose/foundation/pager/PagerMeasureResult;", "foundation"})
@SourceDebugExtension(value={"SMAP\nPagerMeasure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerMeasure.kt\nandroidx/compose/foundation/pager/PagerMeasureKt\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,702:1\n698#1,4:713\n698#1,4:717\n698#1,4:721\n698#1,4:725\n698#1,4:729\n698#1,4:733\n698#1,4:784\n96#2,5:703\n96#2,5:708\n96#2,5:737\n50#2,5:813\n96#2,5:818\n34#3,6:742\n34#3,6:748\n230#3,3:754\n34#3,6:757\n233#3:763\n230#3,3:764\n34#3,6:767\n233#3:773\n230#3,3:774\n34#3,6:777\n233#3:783\n34#3,6:788\n34#3,6:794\n168#3,13:800\n34#3,6:824\n34#3,6:830\n34#3,6:836\n1#4:823\n*S KotlinDebug\n*F\n+ 1 PagerMeasure.kt\nandroidx/compose/foundation/pager/PagerMeasureKt\n*L\n71#1:713,4\n139#1:717,4\n160#1:721,4\n181#1:725,4\n220#1:729,4\n244#1:733,4\n456#1:784,4\n67#1:703,5\n68#1:708,5\n301#1:737,5\n626#1:813,5\n634#1:818,5\n348#1:742,6\n373#1:748,6\n410#1:754,3\n410#1:757,6\n410#1:763\n417#1:764,3\n417#1:767,6\n417#1:773\n421#1:774,3\n421#1:777,6\n421#1:783\n516#1:788,6\n541#1:794,6\n560#1:800,13\n672#1:824,6\n679#1:830,6\n685#1:836,6\n*E\n"})
public final class PagerMeasureKt {
    public static final float MinPageOffset = -0.5f;
    public static final float MaxPageOffset = 0.5f;

    @NotNull
    public static final PagerMeasureResult measurePager-bmk8ZPk(@NotNull LazyLayoutMeasureScope $this$measurePager_u2dbmk8ZPk, int pageCount, @NotNull PagerLazyLayoutItemProvider pagerItemProvider2, int mainAxisAvailableSize, int beforeContentPadding, int afterContentPadding, int spaceBetweenPages, int currentPage, int currentPageOffset, long constraints, @NotNull Orientation orientation, @Nullable Alignment.Vertical verticalAlignment, @Nullable Alignment.Horizontal horizontalAlignment, boolean reverseLayout, long visualPageOffset, int pageAvailableSize, int beyondViewportPageCount, @NotNull List<Integer> pinnedPages, @NotNull SnapPosition snapPosition, @NotNull MutableState<Unit> placementScopeInvalidator, @NotNull CoroutineScope coroutineScope, @NotNull Function3<? super Integer, ? super Integer, ? super Function1<? super Placeable.PlacementScope, Unit>, ? extends MeasureResult> layout2) {
        Intrinsics.checkNotNullParameter((Object)$this$measurePager_u2dbmk8ZPk, (String)"$this$measurePager");
        Intrinsics.checkNotNullParameter((Object)pagerItemProvider2, (String)"pagerItemProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter(pinnedPages, (String)"pinnedPages");
        Intrinsics.checkNotNullParameter((Object)snapPosition, (String)"snapPosition");
        Intrinsics.checkNotNullParameter(placementScopeInvalidator, (String)"placementScopeInvalidator");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(layout2, (String)"layout");
        boolean value$iv = beforeContentPadding >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("negative beforeContentPadding");
        }
        value$iv = afterContentPadding >= 0;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("negative afterContentPadding");
        }
        int pageSizeWithSpacing = RangesKt.coerceAtLeast((int)(pageAvailableSize + spaceBetweenPages), (int)0);
        boolean $i$f$debugLog22 = false;
        if (pageCount > 0) {
            MeasuredPage newCurrentPage;
            List list;
            List positionedPagesBefore;
            List list2;
            List visiblePagesInfo;
            List list3;
            List<MeasuredPage> extraPagesAfter2;
            List<MeasuredPage> extraPagesBefore2;
            int firstVisiblePageOffset;
            long childConstraints = ConstraintsKt.Constraints$default((int)0, (int)(orientation == Orientation.Vertical ? Constraints.getMaxWidth-impl((long)constraints) : pageAvailableSize), (int)0, (int)(orientation != Orientation.Vertical ? Constraints.getMaxHeight-impl((long)constraints) : pageAvailableSize), (int)5, null);
            int firstVisiblePage = 0;
            firstVisiblePage = currentPage;
            for (firstVisiblePageOffset = currentPageOffset; firstVisiblePage > 0 && firstVisiblePageOffset > 0; firstVisiblePageOffset -= pageSizeWithSpacing) {
                int n = firstVisiblePage;
                firstVisiblePage = n + -1;
            }
            int firstVisiblePageScrollOffset = firstVisiblePageOffset * -1;
            int currentFirstPage = firstVisiblePage;
            int currentFirstPageScrollOffset = 0;
            currentFirstPageScrollOffset = firstVisiblePageScrollOffset;
            if (currentFirstPage >= pageCount) {
                currentFirstPage = pageCount - 1;
                currentFirstPageScrollOffset = 0;
            }
            boolean $i$f$debugLog = false;
            ArrayDeque visiblePages = new ArrayDeque();
            int minOffset = -beforeContentPadding + (spaceBetweenPages < 0 ? spaceBetweenPages : 0);
            int maxOffset = mainAxisAvailableSize;
            currentFirstPageScrollOffset += minOffset;
            int maxCrossAxis = 0;
            boolean $i$f$debugLog3 = false;
            while (currentFirstPageScrollOffset < 0 && currentFirstPage > 0) {
                int previous = currentFirstPage - 1;
                MeasuredPage measuredPage = PagerMeasureKt.getAndMeasure-SGf7dI0($this$measurePager_u2dbmk8ZPk, previous, childConstraints, pagerItemProvider2, visualPageOffset, orientation, horizontalAlignment, verticalAlignment, $this$measurePager_u2dbmk8ZPk.getLayoutDirection(), reverseLayout, pageAvailableSize);
                boolean $i$f$debugLog4 = false;
                visiblePages.add(0, (Object)measuredPage);
                maxCrossAxis = Math.max(maxCrossAxis, measuredPage.getCrossAxisSize());
                currentFirstPageScrollOffset += pageSizeWithSpacing;
                currentFirstPage = previous;
            }
            if (currentFirstPageScrollOffset < minOffset) {
                currentFirstPageScrollOffset = minOffset;
            }
            int index2 = 0;
            index2 = currentFirstPage;
            int maxMainAxis = RangesKt.coerceAtLeast((int)(maxOffset + afterContentPadding), (int)0);
            int currentMainAxisOffset = -(currentFirstPageScrollOffset -= minOffset);
            boolean remeasureNeeded = false;
            int indexInVisibleItems = 0;
            while (indexInVisibleItems < visiblePages.size()) {
                if (currentMainAxisOffset >= maxMainAxis) {
                    visiblePages.remove(indexInVisibleItems);
                    remeasureNeeded = true;
                    continue;
                }
                int n = index2;
                index2 = n + 1;
                currentMainAxisOffset += pageSizeWithSpacing;
                ++indexInVisibleItems;
            }
            boolean $i$f$debugLog5 = false;
            while (index2 < pageCount && (currentMainAxisOffset < maxMainAxis || currentMainAxisOffset <= 0 || visiblePages.isEmpty())) {
                MeasuredPage measuredPage = PagerMeasureKt.getAndMeasure-SGf7dI0($this$measurePager_u2dbmk8ZPk, index2, childConstraints, pagerItemProvider2, visualPageOffset, orientation, horizontalAlignment, verticalAlignment, $this$measurePager_u2dbmk8ZPk.getLayoutDirection(), reverseLayout, pageAvailableSize);
                int $i$f$debugLog6 = 0;
                if ((currentMainAxisOffset += index2 == pageCount - 1 ? pageAvailableSize : pageSizeWithSpacing) <= minOffset && index2 != pageCount - 1) {
                    currentFirstPage = index2 + 1;
                    currentFirstPageScrollOffset -= pageSizeWithSpacing;
                    remeasureNeeded = true;
                } else {
                    maxCrossAxis = Math.max(maxCrossAxis, measuredPage.getCrossAxisSize());
                    visiblePages.add((Object)measuredPage);
                }
                $i$f$debugLog6 = index2;
                index2 = $i$f$debugLog6 + 1;
            }
            if (currentMainAxisOffset < maxOffset) {
                int toScrollBack = maxOffset - currentMainAxisOffset;
                currentFirstPageScrollOffset -= toScrollBack;
                currentMainAxisOffset += toScrollBack;
                while (currentFirstPageScrollOffset < beforeContentPadding && currentFirstPage > 0) {
                    int previousIndex = currentFirstPage - 1;
                    MeasuredPage measuredPage = PagerMeasureKt.getAndMeasure-SGf7dI0($this$measurePager_u2dbmk8ZPk, previousIndex, childConstraints, pagerItemProvider2, visualPageOffset, orientation, horizontalAlignment, verticalAlignment, $this$measurePager_u2dbmk8ZPk.getLayoutDirection(), reverseLayout, pageAvailableSize);
                    visiblePages.add(0, (Object)measuredPage);
                    maxCrossAxis = Math.max(maxCrossAxis, measuredPage.getCrossAxisSize());
                    currentFirstPageScrollOffset += pageSizeWithSpacing;
                    currentFirstPage = previousIndex;
                }
                if (currentFirstPageScrollOffset < 0) {
                    currentMainAxisOffset += currentFirstPageScrollOffset;
                    currentFirstPageScrollOffset = 0;
                }
            }
            boolean value$iv2 = currentFirstPageScrollOffset >= 0;
            boolean $i$f$requirePrecondition2 = false;
            if (!value$iv2) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalArgumentException("invalid currentFirstPageScrollOffset");
            }
            int visiblePagesScrollOffset = -currentFirstPageScrollOffset;
            MeasuredPage firstPage = (MeasuredPage)visiblePages.first();
            if (beforeContentPadding > 0 || spaceBetweenPages < 0) {
                int n = ((Collection)visiblePages).size();
                for (int i = 0; i < n; ++i) {
                    int size = pageSizeWithSpacing;
                    if (currentFirstPageScrollOffset == 0 || size > currentFirstPageScrollOffset || i == CollectionsKt.getLastIndex((List)((List)visiblePages))) break;
                    currentFirstPageScrollOffset -= size;
                    firstPage = (MeasuredPage)visiblePages.get(i + 1);
                }
            }
            List<MeasuredPage> $this$fastForEach$iv = extraPagesBefore2 = PagerMeasureKt.createPagesBeforeList(currentFirstPage, beyondViewportPageCount, pinnedPages, (Function1<? super Integer, MeasuredPage>)((Function1)new Function1<Integer, MeasuredPage>($this$measurePager_u2dbmk8ZPk, childConstraints, pagerItemProvider2, visualPageOffset, orientation, horizontalAlignment, verticalAlignment, reverseLayout, pageAvailableSize){
                final /* synthetic */ LazyLayoutMeasureScope $this_measurePager;
                final /* synthetic */ long $childConstraints;
                final /* synthetic */ PagerLazyLayoutItemProvider $pagerItemProvider;
                final /* synthetic */ long $visualPageOffset;
                final /* synthetic */ Orientation $orientation;
                final /* synthetic */ Alignment.Horizontal $horizontalAlignment;
                final /* synthetic */ Alignment.Vertical $verticalAlignment;
                final /* synthetic */ boolean $reverseLayout;
                final /* synthetic */ int $pageAvailableSize;
                {
                    this.$this_measurePager = $receiver;
                    this.$childConstraints = $childConstraints;
                    this.$pagerItemProvider = $pagerItemProvider;
                    this.$visualPageOffset = $visualPageOffset;
                    this.$orientation = $orientation;
                    this.$horizontalAlignment = $horizontalAlignment;
                    this.$verticalAlignment = $verticalAlignment;
                    this.$reverseLayout = $reverseLayout;
                    this.$pageAvailableSize = $pageAvailableSize;
                    super(1);
                }

                public final MeasuredPage invoke(int it) {
                    return PagerMeasureKt.access$getAndMeasure-SGf7dI0(this.$this_measurePager, it, this.$childConstraints, this.$pagerItemProvider, this.$visualPageOffset, this.$orientation, this.$horizontalAlignment, this.$verticalAlignment, this.$this_measurePager.getLayoutDirection(), this.$reverseLayout, this.$pageAvailableSize);
                }
            }));
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                MeasuredPage item$iv;
                MeasuredPage it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                maxCrossAxis = Math.max(maxCrossAxis, it.getCrossAxisSize());
            }
            List<MeasuredPage> $this$fastForEach$iv2 = extraPagesAfter2 = PagerMeasureKt.createPagesAfterList(((MeasuredPage)visiblePages.last()).getIndex(), pageCount, beyondViewportPageCount, pinnedPages, (Function1<? super Integer, MeasuredPage>)((Function1)new Function1<Integer, MeasuredPage>($this$measurePager_u2dbmk8ZPk, childConstraints, pagerItemProvider2, visualPageOffset, orientation, horizontalAlignment, verticalAlignment, reverseLayout, pageAvailableSize){
                final /* synthetic */ LazyLayoutMeasureScope $this_measurePager;
                final /* synthetic */ long $childConstraints;
                final /* synthetic */ PagerLazyLayoutItemProvider $pagerItemProvider;
                final /* synthetic */ long $visualPageOffset;
                final /* synthetic */ Orientation $orientation;
                final /* synthetic */ Alignment.Horizontal $horizontalAlignment;
                final /* synthetic */ Alignment.Vertical $verticalAlignment;
                final /* synthetic */ boolean $reverseLayout;
                final /* synthetic */ int $pageAvailableSize;
                {
                    this.$this_measurePager = $receiver;
                    this.$childConstraints = $childConstraints;
                    this.$pagerItemProvider = $pagerItemProvider;
                    this.$visualPageOffset = $visualPageOffset;
                    this.$orientation = $orientation;
                    this.$horizontalAlignment = $horizontalAlignment;
                    this.$verticalAlignment = $verticalAlignment;
                    this.$reverseLayout = $reverseLayout;
                    this.$pageAvailableSize = $pageAvailableSize;
                    super(1);
                }

                public final MeasuredPage invoke(int it) {
                    return PagerMeasureKt.access$getAndMeasure-SGf7dI0(this.$this_measurePager, it, this.$childConstraints, this.$pagerItemProvider, this.$visualPageOffset, this.$orientation, this.$horizontalAlignment, this.$verticalAlignment, this.$this_measurePager.getLayoutDirection(), this.$reverseLayout, this.$pageAvailableSize);
                }
            }));
            boolean $i$f$fastForEach2 = false;
            int item$iv = ((Collection)$this$fastForEach$iv2).size();
            for (int index$iv = 0; index$iv < item$iv; ++index$iv) {
                MeasuredPage item$iv2;
                MeasuredPage it = item$iv2 = $this$fastForEach$iv2.get(index$iv);
                boolean bl = false;
                maxCrossAxis = Math.max(maxCrossAxis, it.getCrossAxisSize());
            }
            boolean noExtraPages = Intrinsics.areEqual((Object)firstPage, (Object)visiblePages.first()) && extraPagesBefore2.isEmpty() && extraPagesAfter2.isEmpty();
            int layoutWidth = ConstraintsKt.constrainWidth-K40F9xA((long)constraints, (int)(orientation == Orientation.Vertical ? maxCrossAxis : currentMainAxisOffset));
            int layoutHeight = ConstraintsKt.constrainHeight-K40F9xA((long)constraints, (int)(orientation == Orientation.Vertical ? currentMainAxisOffset : maxCrossAxis));
            List positionedPages = PagerMeasureKt.calculatePagesOffsets($this$measurePager_u2dbmk8ZPk, (List)visiblePages, extraPagesBefore2, extraPagesAfter2, layoutWidth, layoutHeight, currentMainAxisOffset, maxOffset, visiblePagesScrollOffset, orientation, reverseLayout, (Density)$this$measurePager_u2dbmk8ZPk, spaceBetweenPages, pageAvailableSize);
            if (noExtraPages) {
                list3 = positionedPages;
            } else {
                List $this$fastFilter$iv = positionedPages;
                boolean $i$f$fastFilter = false;
                ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
                List $this$fastForEach$iv$iv = $this$fastFilter$iv;
                boolean $i$f$fastForEach3 = false;
                int n2 = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
                    MeasuredPage item$iv$iv;
                    MeasuredPage it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl = false;
                    MeasuredPage it = it$iv;
                    boolean bl2 = false;
                    if (!(it.getIndex() >= ((MeasuredPage)visiblePages.first()).getIndex() && it.getIndex() <= ((MeasuredPage)visiblePages.last()).getIndex())) continue;
                    ((Collection)target$iv).add(it$iv);
                }
                list3 = visiblePagesInfo = (List)target$iv;
            }
            if (extraPagesBefore2.isEmpty()) {
                list2 = CollectionsKt.emptyList();
            } else {
                List $this$fastFilter$iv = positionedPages;
                boolean $i$f$fastFilter = false;
                ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
                List $this$fastForEach$iv$iv = $this$fastFilter$iv;
                boolean $i$f$fastForEach4 = false;
                int item$iv$iv = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < item$iv$iv; ++index$iv$iv) {
                    Object item$iv$iv2;
                    Object it$iv = item$iv$iv2 = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl = false;
                    MeasuredPage it = (MeasuredPage)it$iv;
                    boolean bl3 = false;
                    if (!(it.getIndex() < ((MeasuredPage)visiblePages.first()).getIndex())) continue;
                    ((Collection)target$iv).add(it$iv);
                }
                list2 = positionedPagesBefore = (List)target$iv;
            }
            if (extraPagesAfter2.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else {
                List $this$fastFilter$iv = positionedPages;
                boolean $i$f$fastFilter = false;
                ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
                List $this$fastForEach$iv$iv = $this$fastFilter$iv;
                boolean $i$f$fastForEach5 = false;
                int n3 = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n3; ++index$iv$iv) {
                    Object item$iv$iv;
                    Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl = false;
                    MeasuredPage it = (MeasuredPage)it$iv;
                    boolean bl4 = false;
                    if (!(it.getIndex() > ((MeasuredPage)visiblePages.last()).getIndex())) continue;
                    ((Collection)target$iv).add(it$iv);
                }
                list = target$iv;
            }
            List positionedPagesAfter = list;
            int layoutSize = mainAxisAvailableSize + beforeContentPadding + afterContentPadding;
            MeasuredPage measuredPage = newCurrentPage = PagerMeasureKt.calculateNewCurrentPage(layoutSize, visiblePagesInfo, beforeContentPadding, afterContentPadding, pageSizeWithSpacing, snapPosition, pageCount);
            int snapOffset = snapPosition.position(layoutSize, pageAvailableSize, beforeContentPadding, afterContentPadding, measuredPage != null ? measuredPage.getIndex() : 0, pageCount);
            MeasuredPage measuredPage2 = newCurrentPage;
            int currentPagePositionOffset = measuredPage2 != null ? measuredPage2.getOffset() : 0;
            float currentPageOffsetFraction = pageSizeWithSpacing == 0 ? 0.0f : RangesKt.coerceIn((float)((float)(snapOffset - currentPagePositionOffset) / (float)pageSizeWithSpacing), (float)-0.5f, (float)0.5f);
            boolean $i$f$debugLog7 = false;
            MeasuredPage measuredPage3 = firstPage;
            int n4 = currentFirstPageScrollOffset;
            MeasureResult measureResult2 = (MeasureResult)layout2.invoke((Object)layoutWidth, (Object)layoutHeight, (Object)new Function1<Placeable.PlacementScope, Unit>(placementScopeInvalidator, (List<MeasuredPage>)positionedPages){
                final /* synthetic */ MutableState<Unit> $placementScopeInvalidator;
                final /* synthetic */ List<MeasuredPage> $positionedPages;
                {
                    this.$placementScopeInvalidator = $placementScopeInvalidator;
                    this.$positionedPages = $positionedPages;
                    super(1);
                }

                public final void invoke(Placeable.PlacementScope $this$invoke) {
                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                    $this$invoke.withMotionFrameOfReferencePlacement((Function1)new Function1<Placeable.PlacementScope, Unit>(this.$positionedPages){
                        final /* synthetic */ List<MeasuredPage> $positionedPages;
                        {
                            this.$positionedPages = $positionedPages;
                            super(1);
                        }

                        public final void invoke(Placeable.PlacementScope $this$withMotionFrameOfReferencePlacement) {
                            Intrinsics.checkNotNullParameter((Object)$this$withMotionFrameOfReferencePlacement, (String)"$this$withMotionFrameOfReferencePlacement");
                            List<MeasuredPage> $this$fastForEach$iv = this.$positionedPages;
                            boolean $i$f$fastForEach = false;
                            int n = ((Collection)$this$fastForEach$iv).size();
                            for (int index$iv = 0; index$iv < n; ++index$iv) {
                                MeasuredPage item$iv;
                                MeasuredPage it = item$iv = $this$fastForEach$iv.get(index$iv);
                                boolean bl = false;
                                it.place($this$withMotionFrameOfReferencePlacement);
                            }
                        }
                    });
                    ObservableScopeInvalidator.attachToScope-impl(this.$placementScopeInvalidator);
                }
            });
            int n5 = -beforeContentPadding;
            int n6 = maxOffset + afterContentPadding;
            boolean bl = index2 < pageCount || currentMainAxisOffset > maxOffset;
            boolean bl5 = remeasureNeeded;
            return new PagerMeasureResult(visiblePagesInfo, pageAvailableSize, spaceBetweenPages, afterContentPadding, orientation, n5, n6, reverseLayout, beyondViewportPageCount, measuredPage3, newCurrentPage, currentPageOffsetFraction, n4, bl, snapPosition, measureResult2, bl5, positionedPagesBefore, positionedPagesAfter, coroutineScope);
        }
        List $i$f$debugLog22 = CollectionsKt.emptyList();
        int n = -beforeContentPadding;
        int n7 = mainAxisAvailableSize + afterContentPadding;
        MeasureResult measureResult3 = (MeasureResult)layout2.invoke((Object)Constraints.getMinWidth-impl((long)constraints), (Object)Constraints.getMinHeight-impl((long)constraints), (Object)measurePager.4.INSTANCE);
        return new PagerMeasureResult($i$f$debugLog22, pageAvailableSize, spaceBetweenPages, afterContentPadding, orientation, n, n7, false, beyondViewportPageCount, null, null, 0.0f, 0, false, snapPosition, measureResult3, false, null, null, coroutineScope, 393216, null);
    }

    private static final List<MeasuredPage> createPagesAfterList(int currentLastPage, int pagesCount, int beyondViewportPageCount, List<Integer> pinnedPages, Function1<? super Integer, MeasuredPage> getAndMeasure) {
        List list = null;
        int i = currentLastPage + 1;
        int end = Math.min(currentLastPage + beyondViewportPageCount, pagesCount - 1);
        if (i <= end) {
            while (true) {
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(getAndMeasure.invoke((Object)i));
                if (i == end) break;
                ++i;
            }
        }
        List<Integer> $this$fastForEach$iv = pinnedPages;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Integer item$iv = $this$fastForEach$iv.get(index$iv);
            int pageIndex = ((Number)item$iv).intValue();
            boolean bl = false;
            boolean bl2 = end + 1 <= pageIndex ? pageIndex < pagesCount : false;
            if (!bl2) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(getAndMeasure.invoke((Object)pageIndex));
        }
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final List<MeasuredPage> createPagesBeforeList(int currentFirstPage, int beyondViewportPageCount, List<Integer> pinnedPages, Function1<? super Integer, MeasuredPage> getAndMeasure) {
        int i;
        List list = null;
        int start = Math.max(0, currentFirstPage - beyondViewportPageCount);
        if (start <= (i = currentFirstPage - 1)) {
            while (true) {
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(getAndMeasure.invoke((Object)i));
                if (i == start) break;
                --i;
            }
        }
        List<Integer> $this$fastForEach$iv = pinnedPages;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Integer item$iv = $this$fastForEach$iv.get(index$iv);
            int pageIndex = ((Number)item$iv).intValue();
            boolean bl = false;
            if (pageIndex >= start) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(getAndMeasure.invoke((Object)pageIndex));
        }
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final MeasuredPage calculateNewCurrentPage(int viewportSize, List<MeasuredPage> visiblePagesInfo, int beforeContentPadding, int afterContentPadding, int itemSize, SnapPosition snapPosition, int pageCount) {
        MeasuredPage measuredPage;
        List<MeasuredPage> $this$fastMaxBy$iv = visiblePagesInfo;
        boolean $i$f$fastMaxBy = false;
        if ($this$fastMaxBy$iv.isEmpty()) {
            measuredPage = null;
        } else {
            MeasuredPage maxElem$iv;
            MeasuredPage it = maxElem$iv = $this$fastMaxBy$iv.get(0);
            boolean bl = false;
            float maxValue$iv = -Math.abs(SnapPositionKt.calculateDistanceToDesiredSnapPosition(viewportSize, beforeContentPadding, afterContentPadding, itemSize, it.getOffset(), it.getIndex(), snapPosition, pageCount));
            int i$iv = 1;
            int n = CollectionsKt.getLastIndex($this$fastMaxBy$iv);
            if (i$iv <= n) {
                while (true) {
                    MeasuredPage e$iv;
                    it = e$iv = $this$fastMaxBy$iv.get(i$iv);
                    bl = false;
                    float v$iv = -Math.abs(SnapPositionKt.calculateDistanceToDesiredSnapPosition(viewportSize, beforeContentPadding, afterContentPadding, itemSize, it.getOffset(), it.getIndex(), snapPosition, pageCount));
                    if (Float.compare(maxValue$iv, v$iv) < 0) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            measuredPage = maxElem$iv;
        }
        return measuredPage;
    }

    private static final MeasuredPage getAndMeasure-SGf7dI0(LazyLayoutMeasureScope $this$getAndMeasure_u2dSGf7dI0, int index2, long childConstraints, PagerLazyLayoutItemProvider pagerItemProvider2, long visualPageOffset, Orientation orientation, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, int pageAvailableSize) {
        Object key = pagerItemProvider2.getKey(index2);
        List<Placeable> placeable = $this$getAndMeasure_u2dSGf7dI0.measure-0kLqBqw(index2, childConstraints);
        return new MeasuredPage(index2, pageAvailableSize, placeable, visualPageOffset, key, orientation, horizontalAlignment, verticalAlignment, layoutDirection, reverseLayout, null);
    }

    private static final List<MeasuredPage> calculatePagesOffsets(LazyLayoutMeasureScope $this$calculatePagesOffsets, List<MeasuredPage> pages, List<MeasuredPage> extraPagesBefore2, List<MeasuredPage> extraPagesAfter2, int layoutWidth, int layoutHeight, int finalMainAxisOffset, int maxOffset, int pagesScrollOffset, Orientation orientation, boolean reverseLayout, Density density, int spaceBetweenPages, int pageAvailableSize) {
        boolean hasSpareSpace;
        int pageSizeWithSpacing = pageAvailableSize + spaceBetweenPages;
        int mainAxisLayoutSize = orientation == Orientation.Vertical ? layoutHeight : layoutWidth;
        boolean bl = hasSpareSpace = finalMainAxisOffset < Math.min(mainAxisLayoutSize, maxOffset);
        if (hasSpareSpace) {
            boolean value$iv = pagesScrollOffset == 0;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl2 = false;
                InlineClassHelperKt.throwIllegalStateException("non-zero pagesScrollOffset=" + pagesScrollOffset);
            }
        }
        ArrayList<MeasuredPage> positionedPages = new ArrayList<MeasuredPage>(pages.size() + extraPagesBefore2.size() + extraPagesAfter2.size());
        if (hasSpareSpace) {
            int n;
            boolean value$iv = extraPagesBefore2.isEmpty() && extraPagesAfter2.isEmpty();
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                n = 0;
                InlineClassHelperKt.throwIllegalArgumentException("No extra pages");
            }
            int pagesCount = pages.size();
            n = 0;
            int[] nArray = new int[pagesCount];
            while (n < pagesCount) {
                int n2 = n++;
                nArray[n2] = pageAvailableSize;
            }
            int[] sizes = nArray;
            int[] offsets = new int[pagesCount];
            Arrangement.HorizontalOrVertical arrangement = Arrangement.Absolute.INSTANCE.spacedBy-0680j_4($this$calculatePagesOffsets.toDp-u2uoSUM(spaceBetweenPages));
            if (orientation == Orientation.Vertical) {
                Arrangement.HorizontalOrVertical $this$calculatePagesOffsets_u24lambda_u2420 = arrangement;
                boolean bl3 = false;
                $this$calculatePagesOffsets_u24lambda_u2420.arrange(density, mainAxisLayoutSize, sizes, offsets);
            } else {
                Arrangement.HorizontalOrVertical $this$calculatePagesOffsets_u24lambda_u2421 = arrangement;
                boolean bl4 = false;
                $this$calculatePagesOffsets_u24lambda_u2421.arrange(density, mainAxisLayoutSize, sizes, LayoutDirection.Ltr, offsets);
            }
            IntProgression reverseAwareOffsetIndices = !reverseLayout ? (IntProgression)ArraysKt.getIndices((int[])offsets) : RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((int[])offsets)));
            int index2 = reverseAwareOffsetIndices.getFirst();
            int n3 = reverseAwareOffsetIndices.getLast();
            int n4 = reverseAwareOffsetIndices.getStep();
            if (n4 > 0 && index2 <= n3 || n4 < 0 && n3 <= index2) {
                while (true) {
                    int absoluteOffset = offsets[index2];
                    MeasuredPage page = pages.get(PagerMeasureKt.calculatePagesOffsets$reverseAware(index2, reverseLayout, pagesCount));
                    int relativeOffset = reverseLayout ? mainAxisLayoutSize - absoluteOffset - page.getSize() : absoluteOffset;
                    page.position(relativeOffset, layoutWidth, layoutHeight);
                    positionedPages.add(page);
                    if (index2 != n3) {
                        index2 += n4;
                        continue;
                    }
                    break;
                }
            }
        } else {
            MeasuredPage it;
            MeasuredPage item$iv;
            int index$iv;
            int currentMainAxis = 0;
            currentMainAxis = pagesScrollOffset;
            List<MeasuredPage> $this$fastForEach$iv = extraPagesBefore2;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl5 = false;
                it.position(currentMainAxis -= pageSizeWithSpacing, layoutWidth, layoutHeight);
                positionedPages.add(it);
            }
            currentMainAxis = pagesScrollOffset;
            $this$fastForEach$iv = pages;
            $i$f$fastForEach = false;
            n = ((Collection)$this$fastForEach$iv).size();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl6 = false;
                it.position(currentMainAxis, layoutWidth, layoutHeight);
                positionedPages.add(it);
                currentMainAxis += pageSizeWithSpacing;
            }
            $this$fastForEach$iv = extraPagesAfter2;
            $i$f$fastForEach = false;
            n = ((Collection)$this$fastForEach$iv).size();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl7 = false;
                it.position(currentMainAxis, layoutWidth, layoutHeight);
                positionedPages.add(it);
                currentMainAxis += pageSizeWithSpacing;
            }
        }
        return positionedPages;
    }

    private static final void debugLog(Function0<String> generateMsg) {
        boolean $i$f$debugLog = false;
    }

    private static final int calculatePagesOffsets$reverseAware(int $this$calculatePagesOffsets_u24reverseAware, boolean $reverseLayout, int pagesCount) {
        return !$reverseLayout ? $this$calculatePagesOffsets_u24reverseAware : pagesCount - $this$calculatePagesOffsets_u24reverseAware - 1;
    }

    public static final /* synthetic */ MeasuredPage access$getAndMeasure-SGf7dI0(LazyLayoutMeasureScope $receiver, int index2, long childConstraints, PagerLazyLayoutItemProvider pagerItemProvider2, long visualPageOffset, Orientation orientation, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, int pageAvailableSize) {
        return PagerMeasureKt.getAndMeasure-SGf7dI0($receiver, index2, childConstraints, pagerItemProvider2, visualPageOffset, orientation, horizontalAlignment, verticalAlignment, layoutDirection, reverseLayout, pageAvailableSize);
    }
}

