/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.annotation.FloatRange;
import androidx.compose.animation.SplineBasedDecayAnimationSpec_desktopKt;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.VisibilityThresholdsKt;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.TargetedFlingBehavior;
import androidx.compose.foundation.gestures.snapping.PagerSnapLayoutInfoProviderKt;
import androidx.compose.foundation.gestures.snapping.SnapFlingBehaviorKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.pager.DefaultPagerNestedScrollConnection;
import androidx.compose.foundation.pager.PagerSnapDistance;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.input.nestedscroll.NestedScrollConnection;
import androidx.compose.ui.platform.CompositionLocalsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\b\b\u0003\u0010\u0010\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/pager/PagerDefaults;", "", "()V", "BeyondViewportPageCount", "", "flingBehavior", "Landroidx/compose/foundation/gestures/TargetedFlingBehavior;", "state", "Landroidx/compose/foundation/pager/PagerState;", "pagerSnapDistance", "Landroidx/compose/foundation/pager/PagerSnapDistance;", "decayAnimationSpec", "Landroidx/compose/animation/core/DecayAnimationSpec;", "", "snapAnimationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "snapPositionalThreshold", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/pager/PagerSnapDistance;Landroidx/compose/animation/core/DecayAnimationSpec;Landroidx/compose/animation/core/AnimationSpec;FLandroidx/compose/runtime/Composer;II)Landroidx/compose/foundation/gestures/TargetedFlingBehavior;", "pageNestedScrollConnection", "Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/gestures/Orientation;Landroidx/compose/runtime/Composer;I)Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;", "foundation"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nPager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pager.kt\nandroidx/compose/foundation/pager/PagerDefaults\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n+ 4 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,592:1\n96#2,5:593\n75#3:598\n75#3:599\n1247#4,6:600\n1247#4,6:606\n*S KotlinDebug\n*F\n+ 1 Pager.kt\nandroidx/compose/foundation/pager/PagerDefaults\n*L\n385#1:593,5\n389#1:598\n390#1:599\n391#1:600,6\n434#1:606,6\n*E\n"})
public final class PagerDefaults {
    @NotNull
    public static final PagerDefaults INSTANCE = new PagerDefaults();
    public static final int BeyondViewportPageCount = 0;
    public static final int $stable;

    private PagerDefaults() {
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public final TargetedFlingBehavior flingBehavior(@NotNull PagerState state, @Nullable PagerSnapDistance pagerSnapDistance, @Nullable DecayAnimationSpec<Float> decayAnimationSpec, @Nullable AnimationSpec<Float> snapAnimationSpec, @FloatRange(from=0.0, to=1.0) float snapPositionalThreshold, @Nullable Composer $composer, int $changed, int n) {
        Object object;
        void invalid$iv;
        void $this$cache$iv;
        void this_$iv;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)1559769181, (String)"C(flingBehavior)P(4,1)376@20879L26,388@21477L7,389@21536L7,390@21559L1055:Pager.kt#g6yjnt");
        if ((n & 2) != 0) {
            pagerSnapDistance = PagerSnapDistance.Companion.atMost(1);
        }
        if ((n & 4) != 0) {
            decayAnimationSpec = SplineBasedDecayAnimationSpec_desktopKt.rememberSplineBasedDecay((Composer)$composer, (int)0);
        }
        if ((n & 8) != 0) {
            snapAnimationSpec = (AnimationSpec)AnimationSpecKt.spring$default((float)0.0f, (float)400.0f, (Object)Float.valueOf(VisibilityThresholdsKt.getVisibilityThreshold((IntCompanionObject)IntCompanionObject.INSTANCE)), (int)1, null);
        }
        if ((n & 0x10) != 0) {
            snapPositionalThreshold = 0.5f;
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)1559769181, (int)$changed, (int)-1, (String)"androidx.compose.foundation.pager.PagerDefaults.flingBehavior (Pager.kt:383)");
        }
        boolean value$iv = 0.0f <= snapPositionalThreshold ? snapPositionalThreshold <= 1.0f : false;
        boolean $i$f$requirePrecondition22 = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("snapPositionalThreshold should be a number between 0 and 1. You've specified " + snapPositionalThreshold);
        }
        CompositionLocal $i$f$requirePrecondition22 = (CompositionLocal)CompositionLocalsKt.getLocalDensity();
        boolean $changed$iv22 = false;
        boolean $i$f$getCurrent = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
        Object object2 = $composer.consume((CompositionLocal)this_$iv2);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        Density density = (Density)object2;
        CompositionLocal $changed$iv22 = (CompositionLocal)CompositionLocalsKt.getLocalLayoutDirection();
        boolean $changed$iv = false;
        boolean $i$f$getCurrent22 = false;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
        Object object3 = $composer.consume((CompositionLocal)this_$iv);
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        LayoutDirection layoutDirection = (LayoutDirection)object3;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-1107366577, (String)"CC(remember):Pager.kt#9igjgp");
        Composer $i$f$getCurrent22 = $composer;
        boolean bl = (($changed & 0xE ^ 6) > 4 && $composer.changed((Object)state) || ($changed & 6) == 4) | $composer.changed((Object)decayAnimationSpec) | $composer.changed((Object)snapAnimationSpec) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed((Object)pagerSnapDistance) || ($changed & 0x30) == 32) | $composer.changed((Object)density) | $composer.changed((Object)layoutDirection);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl2 = false;
        if (invalid$iv != false || it$iv == Composer.Companion.getEmpty()) {
            boolean bl3 = false;
            SnapLayoutInfoProvider snapLayoutInfoProvider2 = PagerSnapLayoutInfoProviderKt.SnapLayoutInfoProvider(state, pagerSnapDistance, (Function3<? super Float, ? super Float, ? super Float, Float>)((Function3)new Function3<Float, Float, Float, Float>(state, layoutDirection, snapPositionalThreshold){
                final /* synthetic */ PagerState $state;
                final /* synthetic */ LayoutDirection $layoutDirection;
                final /* synthetic */ float $snapPositionalThreshold;
                {
                    this.$state = $state;
                    this.$layoutDirection = $layoutDirection;
                    this.$snapPositionalThreshold = $snapPositionalThreshold;
                    super(3);
                }

                public final Float invoke(float flingVelocity, float lowerBound, float upperBound) {
                    return Float.valueOf(PagerSnapLayoutInfoProviderKt.calculateFinalSnappingBound(this.$state, this.$layoutDirection, this.$snapPositionalThreshold, flingVelocity, lowerBound, upperBound));
                }
            }));
            TargetedFlingBehavior value$iv2 = SnapFlingBehaviorKt.snapFlingBehavior(snapLayoutInfoProvider2, (DecayAnimationSpec<Float>)decayAnimationSpec, (AnimationSpec<Float>)snapAnimationSpec);
            $this$cache$iv.updateRememberedValue((Object)value$iv2);
            object = value$iv2;
        } else {
            object = it$iv;
        }
        TargetedFlingBehavior targetedFlingBehavior = (TargetedFlingBehavior)object;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        TargetedFlingBehavior targetedFlingBehavior2 = targetedFlingBehavior;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return targetedFlingBehavior2;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public final NestedScrollConnection pageNestedScrollConnection(@NotNull PagerState state, @NotNull Orientation orientation, @Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)877583120, (String)"C(pageNestedScrollConnection)P(1)433@23084L107:Pager.kt#g6yjnt");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)877583120, (int)$changed, (int)-1, (String)"androidx.compose.foundation.pager.PagerDefaults.pageNestedScrollConnection (Pager.kt:432)");
        }
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-1511118598, (String)"CC(remember):Pager.kt#9igjgp");
        Composer composer = $composer;
        boolean invalid$iv = (($changed & 0xE ^ 6) > 4 && $composer.changed((Object)state) || ($changed & 6) == 4) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed((Object)orientation) || ($changed & 0x30) == 32);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            boolean bl2 = false;
            DefaultPagerNestedScrollConnection value$iv = new DefaultPagerNestedScrollConnection(state, orientation);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        DefaultPagerNestedScrollConnection defaultPagerNestedScrollConnection = (DefaultPagerNestedScrollConnection)object;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        DefaultPagerNestedScrollConnection defaultPagerNestedScrollConnection2 = defaultPagerNestedScrollConnection;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return defaultPagerNestedScrollConnection2;
    }
}

