/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.nestedscroll.NestedScrollConnection;
import androidx.compose.ui.input.nestedscroll.NestedScrollSource;
import androidx.compose.ui.unit.Velocity;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\f*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e*\u00020\u0012H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Landroidx/compose/foundation/pager/DefaultPagerNestedScrollConnection;", "Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;", "state", "Landroidx/compose/foundation/pager/PagerState;", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/gestures/Orientation;)V", "getOrientation", "()Landroidx/compose/foundation/gestures/Orientation;", "getState", "()Landroidx/compose/foundation/pager/PagerState;", "onPostFling", "Landroidx/compose/ui/unit/Velocity;", "consumed", "available", "onPostFling-RZ2iAVY", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onPostScroll", "Landroidx/compose/ui/geometry/Offset;", "source", "Landroidx/compose/ui/input/nestedscroll/NestedScrollSource;", "onPostScroll-DzOQY0M", "(JJI)J", "onPreScroll", "onPreScroll-OzD1aCk", "(JI)J", "consumeOnOrientation", "consumeOnOrientation-QWom1Mo", "(JLandroidx/compose/foundation/gestures/Orientation;)J", "mainAxis", "", "mainAxis-k-4lQ0M", "(J)F", "foundation"})
@SourceDebugExtension(value={"SMAP\nPager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pager.kt\nandroidx/compose/foundation/pager/DefaultPagerNestedScrollConnection\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,592:1\n65#2:593\n69#2:596\n65#2:598\n69#2:601\n65#2:604\n69#2:607\n60#3:594\n70#3:597\n60#3:599\n70#3:602\n60#3:605\n70#3:608\n22#4:595\n22#4:600\n22#4:603\n22#4:606\n*S KotlinDebug\n*F\n+ 1 Pager.kt\nandroidx/compose/foundation/pager/DefaultPagerNestedScrollConnection\n*L\n505#1:593\n505#1:596\n510#1:598\n511#1:601\n534#1:604\n534#1:607\n505#1:594\n505#1:597\n510#1:599\n511#1:602\n534#1:605\n534#1:608\n505#1:595\n510#1:600\n511#1:603\n534#1:606\n*E\n"})
final class DefaultPagerNestedScrollConnection
implements NestedScrollConnection {
    @NotNull
    private final PagerState state;
    @NotNull
    private final Orientation orientation;

    public DefaultPagerNestedScrollConnection(@NotNull PagerState state, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.state = state;
        this.orientation = orientation;
    }

    @NotNull
    public final PagerState getState() {
        return this.state;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final long consumeOnOrientation-QWom1Mo(long $this$consumeOnOrientation_u2dQWom1Mo, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        return orientation == Orientation.Vertical ? Velocity.copy-OhffZ5M$default((long)$this$consumeOnOrientation_u2dQWom1Mo, (float)0.0f, (float)0.0f, (int)2, null) : Velocity.copy-OhffZ5M$default((long)$this$consumeOnOrientation_u2dQWom1Mo, (float)0.0f, (float)0.0f, (int)1, null);
    }

    public long onPreScroll-OzD1aCk(long available, int source) {
        long l;
        if (NestedScrollSource.equals-impl0((int)source, (int)NestedScrollSource.Companion.getUserInput-WNlRxjI()) && (double)Math.abs(this.state.getCurrentPageOffsetFraction()) > 1.0E-6) {
            float f;
            boolean $i$f$floatFromBits;
            int bits$iv$iv$iv;
            float f2;
            float f3;
            boolean $i$f$floatFromBits2;
            int bits$iv$iv$iv2;
            long value$iv$iv;
            float currentPageOffset = this.state.getCurrentPageOffsetFraction() * (float)this.state.getPageSize$foundation();
            int pageAvailableSpace = this.state.getLayoutInfo().getPageSize() + this.state.getLayoutInfo().getPageSpacing();
            float nextClosestPageOffset = currentPageOffset + (float)pageAvailableSpace * -Math.signum(this.state.getCurrentPageOffsetFraction());
            float minBound = 0.0f;
            float maxBound = 0.0f;
            if (this.state.getCurrentPageOffsetFraction() > 0.0f) {
                minBound = nextClosestPageOffset;
                maxBound = currentPageOffset;
            } else {
                minBound = currentPageOffset;
                maxBound = nextClosestPageOffset;
            }
            if (this.orientation == Orientation.Horizontal) {
                boolean bl = false;
                value$iv$iv = available;
                boolean $i$f$unpackFloat1 = false;
                bits$iv$iv$iv2 = (int)(value$iv$iv >> 32);
                $i$f$floatFromBits2 = false;
                f3 = Float.intBitsToFloat(bits$iv$iv$iv2);
            } else {
                boolean bl = false;
                value$iv$iv = available;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv2 = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits2 = false;
                f3 = Float.intBitsToFloat(bits$iv$iv$iv2);
            }
            float delta = f3;
            float coerced = RangesKt.coerceIn((float)delta, (float)minBound, (float)maxBound);
            float consumed = -this.state.dispatchRawDelta(-coerced);
            if (this.orientation == Orientation.Horizontal) {
                f2 = consumed;
            } else {
                boolean bl = false;
                long value$iv$iv2 = available;
                boolean $i$f$unpackFloat1 = false;
                bits$iv$iv$iv = (int)(value$iv$iv2 >> 32);
                $i$f$floatFromBits = false;
                f2 = Float.intBitsToFloat(bits$iv$iv$iv);
            }
            if (this.orientation == Orientation.Vertical) {
                f = consumed;
            } else {
                boolean bl = false;
                long value$iv$iv3 = available;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv3 & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                f = Float.intBitsToFloat(bits$iv$iv$iv);
            }
            l = Offset.copy-dBAh8RU((long)available, (float)f2, (float)f);
        } else {
            l = Offset.Companion.getZero-F1C5BW0();
        }
        return l;
    }

    public long onPostScroll-DzOQY0M(long consumed, long available, int source) {
        if (NestedScrollSource.equals-impl0((int)source, (int)NestedScrollSource.Companion.getSideEffect-WNlRxjI()) && !(this.mainAxis-k-4lQ0M(available) == 0.0f)) {
            throw new CancellationException("Scroll cancelled");
        }
        return Offset.Companion.getZero-F1C5BW0();
    }

    @Nullable
    public Object onPostFling-RZ2iAVY(long consumed, long available, @NotNull Continuation<? super Velocity> $completion) {
        return Velocity.box-impl((long)this.consumeOnOrientation-QWom1Mo(available, this.orientation));
    }

    private final float mainAxis-k-4lQ0M(long $this$mainAxis_u2dk_u2d4lQ0M) {
        float f;
        if (this.orientation == Orientation.Horizontal) {
            boolean bl = false;
            long value$iv$iv = $this$mainAxis_u2dk_u2d4lQ0M;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            f = Float.intBitsToFloat(bits$iv$iv$iv);
        } else {
            boolean bl = false;
            long value$iv$iv = $this$mainAxis_u2dk_u2d4lQ0M;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits = false;
            f = Float.intBitsToFloat(bits$iv$iv$iv);
        }
        return f;
    }
}

