/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.SpringSpec;
import androidx.compose.animation.core.VisibilityThresholdsKt;
import androidx.compose.foundation.lazy.grid.GridItemSpan;
import androidx.compose.foundation.lazy.grid.LazyGridPositionedItem;
import androidx.compose.foundation.lazy.grid.LazyGridSpanLayoutProvider;
import androidx.compose.ui.unit.IntOffset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a\f\u0010\b\u001a\u00020\u0004*\u00020\u0005H\u0002\u001a\"\u0010\t\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a2\u0010\u000e\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"InterruptionSpec", "Landroidx/compose/animation/core/SpringSpec;", "Landroidx/compose/ui/unit/IntOffset;", "firstIndexInLineContaining", "", "Landroidx/compose/foundation/lazy/grid/LazyGridSpanLayoutProvider;", "index", "firstIndexInNextLineAfter", "getFirstIndexInNextLineAfterTheLastKnownOne", "getLineSize", "", "Landroidx/compose/foundation/lazy/grid/LazyGridPositionedItem;", "itemIndex", "fallback", "getLinesMainAxisSizesSum", "fromIndex", "toIndex", "averageLineMainAxisSize", "visibleItems", "lastIndexInPreviousLineBefore", "foundation"})
@SourceDebugExtension(value={"SMAP\nLazyGridItemPlacementAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridItemPlacementAnimator.kt\nandroidx/compose/foundation/lazy/grid/LazyGridItemPlacementAnimatorKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,560:1\n33#2,6:561\n*S KotlinDebug\n*F\n+ 1 LazyGridItemPlacementAnimator.kt\nandroidx/compose/foundation/lazy/grid/LazyGridItemPlacementAnimatorKt\n*L\n552#1:561,6\n*E\n"})
public final class LazyGridItemPlacementAnimatorKt {
    @NotNull
    private static final SpringSpec<IntOffset> InterruptionSpec = AnimationSpecKt.spring$default((float)0.0f, (float)400.0f, (Object)IntOffset.box-impl((long)VisibilityThresholdsKt.getVisibilityThreshold((IntOffset.Companion)IntOffset.Companion)), (int)1, null);

    private static final int getLinesMainAxisSizesSum(LazyGridSpanLayoutProvider $this$getLinesMainAxisSizesSum, int fromIndex, int toIndex, int averageLineMainAxisSize2, List<LazyGridPositionedItem> visibleItems) {
        int index2 = fromIndex;
        int sizes = 0;
        while (index2 <= toIndex) {
            int lastItemInTheLine = LazyGridItemPlacementAnimatorKt.firstIndexInNextLineAfter($this$getLinesMainAxisSizesSum, index2) - 1;
            if (lastItemInTheLine <= toIndex) {
                sizes += LazyGridItemPlacementAnimatorKt.getLineSize(visibleItems, lastItemInTheLine, averageLineMainAxisSize2);
            }
            index2 = lastItemInTheLine + 1;
        }
        return sizes;
    }

    private static final int getLineSize(List<LazyGridPositionedItem> $this$getLineSize, int itemIndex, int fallback) {
        if ($this$getLineSize.isEmpty() || itemIndex < ((LazyGridPositionedItem)CollectionsKt.first($this$getLineSize)).getIndex() || itemIndex > ((LazyGridPositionedItem)CollectionsKt.last($this$getLineSize)).getIndex()) {
            return fallback;
        }
        if (itemIndex - ((LazyGridPositionedItem)CollectionsKt.first($this$getLineSize)).getIndex() < ((LazyGridPositionedItem)CollectionsKt.last($this$getLineSize)).getIndex() - itemIndex) {
            int n = $this$getLineSize.size();
            for (int index2 = 0; index2 < n; ++index2) {
                LazyGridPositionedItem item2 = $this$getLineSize.get(index2);
                if (item2.getIndex() == itemIndex) {
                    return item2.getLineMainAxisSizeWithSpacings();
                }
                if (item2.getIndex() <= itemIndex) {
                    continue;
                }
                break;
            }
        } else {
            for (int index3 = CollectionsKt.getLastIndex($this$getLineSize); -1 < index3; --index3) {
                LazyGridPositionedItem item3 = $this$getLineSize.get(index3);
                if (item3.getIndex() == itemIndex) {
                    return item3.getLineMainAxisSizeWithSpacings();
                }
                if (item3.getIndex() >= itemIndex) {
                    continue;
                }
                break;
            }
        }
        return fallback;
    }

    private static final int lastIndexInPreviousLineBefore(LazyGridSpanLayoutProvider $this$lastIndexInPreviousLineBefore, int index2) {
        return LazyGridItemPlacementAnimatorKt.firstIndexInLineContaining($this$lastIndexInPreviousLineBefore, index2) - 1;
    }

    private static final int firstIndexInNextLineAfter(LazyGridSpanLayoutProvider $this$firstIndexInNextLineAfter, int index2) {
        int n;
        if (index2 >= $this$firstIndexInNextLineAfter.getTotalSize()) {
            n = LazyGridItemPlacementAnimatorKt.firstIndexInLineContaining($this$firstIndexInNextLineAfter, index2) + $this$firstIndexInNextLineAfter.getSlotsPerLine();
        } else {
            int lineIndex = $this$firstIndexInNextLineAfter.getLineIndexOfItem--_Ze7BM(index2);
            LazyGridSpanLayoutProvider.LineConfiguration lineConfiguration = $this$firstIndexInNextLineAfter.getLineConfiguration(lineIndex);
            n = lineConfiguration.getFirstItemIndex() + lineConfiguration.getSpans().size();
        }
        return n;
    }

    private static final int firstIndexInLineContaining(LazyGridSpanLayoutProvider $this$firstIndexInLineContaining, int index2) {
        int n;
        if (index2 >= $this$firstIndexInLineContaining.getTotalSize()) {
            int firstIndexForLastKnowLine = LazyGridItemPlacementAnimatorKt.getFirstIndexInNextLineAfterTheLastKnownOne($this$firstIndexInLineContaining);
            int linesBetween = (index2 - firstIndexForLastKnowLine) / $this$firstIndexInLineContaining.getSlotsPerLine();
            n = firstIndexForLastKnowLine + $this$firstIndexInLineContaining.getSlotsPerLine() * linesBetween;
        } else {
            int lineIndex = $this$firstIndexInLineContaining.getLineIndexOfItem--_Ze7BM(index2);
            LazyGridSpanLayoutProvider.LineConfiguration lineConfiguration = $this$firstIndexInLineContaining.getLineConfiguration(lineIndex);
            n = lineConfiguration.getFirstItemIndex();
        }
        return n;
    }

    private static final int getFirstIndexInNextLineAfterTheLastKnownOne(LazyGridSpanLayoutProvider $this$getFirstIndexInNextLineAfterTheLastKnownOne) {
        LazyGridSpanLayoutProvider.LineConfiguration lineConfiguration = $this$getFirstIndexInNextLineAfterTheLastKnownOne.getLineConfiguration($this$getFirstIndexInNextLineAfterTheLastKnownOne.getLineIndexOfItem--_Ze7BM($this$getFirstIndexInNextLineAfterTheLastKnownOne.getTotalSize() - 1));
        int currentSpan = 0;
        int currentIndex = 0;
        currentIndex = lineConfiguration.getFirstItemIndex() - 1;
        List<GridItemSpan> $this$fastForEach$iv = lineConfiguration.getSpans();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            GridItemSpan item$iv = $this$fastForEach$iv.get(index$iv);
            long it = item$iv.unbox-impl();
            boolean bl = false;
            currentSpan += GridItemSpan.getCurrentLineSpan-impl(it);
            ++currentIndex;
        }
        return currentIndex += $this$getFirstIndexInNextLineAfterTheLastKnownOne.getSlotsPerLine() - currentSpan + 1;
    }

    public static final /* synthetic */ int access$firstIndexInNextLineAfter(LazyGridSpanLayoutProvider $receiver, int index2) {
        return LazyGridItemPlacementAnimatorKt.firstIndexInNextLineAfter($receiver, index2);
    }

    public static final /* synthetic */ int access$lastIndexInPreviousLineBefore(LazyGridSpanLayoutProvider $receiver, int index2) {
        return LazyGridItemPlacementAnimatorKt.lastIndexInPreviousLineBefore($receiver, index2);
    }

    public static final /* synthetic */ int access$getLinesMainAxisSizesSum(LazyGridSpanLayoutProvider $receiver, int fromIndex, int toIndex, int averageLineMainAxisSize2, List visibleItems) {
        return LazyGridItemPlacementAnimatorKt.getLinesMainAxisSizesSum($receiver, fromIndex, toIndex, averageLineMainAxisSize2, visibleItems);
    }

    public static final /* synthetic */ SpringSpec access$getInterruptionSpec$p() {
        return InterruptionSpec;
    }
}

