/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import androidx.compose.foundation.LazyScrollbarAdapter;
import androidx.compose.foundation.ScrollbarAdapter;
import androidx.compose.foundation.gestures.ScrollExtensionsKt;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\fH\u0016J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/LazyScrollbarAdapter;", "Landroidx/compose/foundation/ScrollbarAdapter;", "scrollState", "Landroidx/compose/foundation/lazy/LazyListState;", "(Landroidx/compose/foundation/lazy/LazyListState;)V", "averageItemSize", "", "getAverageItemSize", "()F", "averageItemSize$delegate", "Landroidx/compose/runtime/State;", "itemCount", "", "getItemCount", "()I", "scrollOffset", "getScrollOffset", "maxScrollOffset", "containerSize", "scrollTo", "", "(IFLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "snapTo", "foundation"})
@SourceDebugExtension(value={"SMAP\nScrollbar.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scrollbar.desktop.kt\nandroidx/compose/foundation/LazyScrollbarAdapter\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,627:1\n76#2:628\n*S KotlinDebug\n*F\n+ 1 Scrollbar.desktop.kt\nandroidx/compose/foundation/LazyScrollbarAdapter\n*L\n483#1:628\n*E\n"})
final class LazyScrollbarAdapter
implements ScrollbarAdapter {
    @NotNull
    private final LazyListState scrollState;
    @NotNull
    private final State averageItemSize$delegate;

    public LazyScrollbarAdapter(@NotNull LazyListState scrollState) {
        Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
        this.scrollState = scrollState;
        this.averageItemSize$delegate = SnapshotStateKt.derivedStateOf((Function0)((Function0)new Function0<Float>(this){
            final /* synthetic */ LazyScrollbarAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                return Float.valueOf((float)SequencesKt.averageOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)LazyScrollbarAdapter.access$getScrollState$p(this.this$0).getLayoutInfo().getVisibleItemsInfo()), (Function1)averageItemSize.1.INSTANCE)));
            }
        }));
    }

    @Override
    public float getScrollOffset() {
        return (float)this.scrollState.getFirstVisibleItemIndex() * this.getAverageItemSize() + (float)this.scrollState.getFirstVisibleItemScrollOffset();
    }

    @Override
    @Nullable
    public Object scrollTo(int containerSize, float scrollOffset, @NotNull Continuation<? super Unit> $completion) {
        float distance = scrollOffset - this.getScrollOffset();
        if (Math.abs(distance) <= (float)containerSize) {
            Object object = ScrollExtensionsKt.scrollBy(this.scrollState, distance, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.snapTo(containerSize, scrollOffset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object snapTo(int containerSize, float scrollOffset, Continuation<? super Unit> $completion) {
        double maximumValue = this.maxScrollOffset(containerSize);
        double scrollOffsetCoerced = RangesKt.coerceIn((double)scrollOffset, (double)0.0, (double)maximumValue);
        double averageItemSize2 = this.getAverageItemSize();
        int index2 = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)((int)(scrollOffsetCoerced / averageItemSize2)), (int)0), (int)(this.getItemCount() - 1));
        int offset = RangesKt.coerceAtLeast((int)((int)(scrollOffsetCoerced - (double)index2 * averageItemSize2)), (int)0);
        Object object = this.scrollState.scrollToItem(index2, offset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public float maxScrollOffset(int containerSize) {
        return RangesKt.coerceAtLeast((float)(this.getAverageItemSize() * (float)this.getItemCount() + (float)this.scrollState.getLayoutInfo().getBeforeContentPadding() + (float)this.scrollState.getLayoutInfo().getAfterContentPadding() - (float)containerSize), (float)0.0f);
    }

    private final int getItemCount() {
        return this.scrollState.getLayoutInfo().getTotalItemsCount();
    }

    /*
     * WARNING - void declaration
     */
    private final float getAverageItemSize() {
        void $this$getValue$iv;
        State state = this.averageItemSize$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).floatValue();
    }

    public static final /* synthetic */ Object access$snapTo(LazyScrollbarAdapter $this, int containerSize, float scrollOffset, Continuation $completion) {
        return $this.snapTo(containerSize, scrollOffset, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ LazyListState access$getScrollState$p(LazyScrollbarAdapter $this) {
        return $this.scrollState;
    }
}

