/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.IdeaImportTask;
import org.jetbrains.compose.internal.com.squareup.kotlinpoet.FileSpec;
import org.jetbrains.compose.resources.GeneratedResClassSpecKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/compose/resources/GenerateExpectResourceCollectorsTask;", "Lorg/jetbrains/compose/internal/IdeaImportTask;", "()V", "codeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getCodeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "makeAccessorsPublic", "Lorg/gradle/api/provider/Property;", "", "getMakeAccessorsPublic", "()Lorg/gradle/api/provider/Property;", "packageName", "", "getPackageName", "resClassName", "getResClassName", "safeAction", "", "compose"})
public abstract class GenerateExpectResourceCollectorsTask
extends IdeaImportTask {
    @Input
    @NotNull
    public abstract Property<String> getPackageName();

    @Input
    @NotNull
    public abstract Property<String> getResClassName();

    @Input
    @NotNull
    public abstract Property<Boolean> getMakeAccessorsPublic();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCodeDir();

    @Override
    public void safeAction() {
        File kotlinDir = ((Directory)this.getCodeDir().get()).getAsFile();
        this.getLogger().info("Clean directory " + kotlinDir);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinDir, (String)"kotlinDir");
        FilesKt.deleteRecursively((File)kotlinDir);
        kotlinDir.mkdirs();
        this.getLogger().info("Generate expect ResourceCollectors for " + kotlinDir);
        String pkgName = (String)this.getPackageName().get();
        String resClassName2 = (String)this.getResClassName().get();
        Boolean isPublic = (Boolean)this.getMakeAccessorsPublic().get();
        Intrinsics.checkNotNullExpressionValue((Object)pkgName, (String)"pkgName");
        Intrinsics.checkNotNullExpressionValue((Object)resClassName2, (String)"resClassName");
        Intrinsics.checkNotNullExpressionValue((Object)isPublic, (String)"isPublic");
        FileSpec spec = GeneratedResClassSpecKt.getExpectResourceCollectorsFileSpec(pkgName, "ExpectResourceCollectors", resClassName2, isPublic);
        spec.writeTo(kotlinDir);
    }
}

