/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"BUNDLE_ID_FORMAT", "", "ERR_BUNDLE_ID_IS_EMPTY", "ERR_BUNDLE_ID_WRONG_FORMAT", "ERR_PREFIX", "validateBundleID", "bundleIDProvider", "Lorg/gradle/api/provider/Provider;", "compose"})
@SourceDebugExtension(value={"SMAP\nvalidateBundleID.kt\nKotlin\n*S Kotlin\n*F\n+ 1 validateBundleID.kt\norg/jetbrains/compose/desktop/application/internal/validation/ValidateBundleIDKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class ValidateBundleIDKt {
    @NotNull
    private static final String ERR_PREFIX = "macOS settings error:";
    @NotNull
    private static final String BUNDLE_ID_FORMAT = "bundleID may only contain alphanumeric characters (A-Z, a-z, 0-9), hyphen (-) and period (.) characters";
    @NotNull
    private static final String ERR_BUNDLE_ID_IS_EMPTY = "macOS settings error: bundleID is empty or null. To specify:\n  * Use 'nativeDistributions.macOS.bundleID' DSL property;\n  * bundleID may only contain alphanumeric characters (A-Z, a-z, 0-9), hyphen (-) and period (.) characters;\n  * Use reverse DNS notation (e.g. \"com.mycompany.myapp\");\n";
    @NotNull
    private static final String ERR_BUNDLE_ID_WRONG_FORMAT = "macOS settings error: bundleID may only contain alphanumeric characters (A-Z, a-z, 0-9), hyphen (-) and period (.) characters";

    @NotNull
    public static final String validateBundleID(@NotNull Provider<String> bundleIDProvider) {
        Intrinsics.checkNotNullParameter(bundleIDProvider, (String)"bundleIDProvider");
        String bundleID = (String)bundleIDProvider.getOrNull();
        CharSequence charSequence = bundleID;
        if (!(!(charSequence == null || charSequence.length() == 0))) {
            boolean $i$a$-check-ValidateBundleIDKt$validateBundleID$32 = false;
            String $i$a$-check-ValidateBundleIDKt$validateBundleID$32 = ERR_BUNDLE_ID_IS_EMPTY;
            throw new IllegalStateException($i$a$-check-ValidateBundleIDKt$validateBundleID$32.toString());
        }
        charSequence = bundleID;
        if (!new Regex("[A-Za-z0-9\\-\\.]+").matches(charSequence)) {
            boolean bl = false;
            String string = ERR_BUNDLE_ID_WRONG_FORMAT;
            throw new IllegalStateException(string.toString());
        }
        return bundleID;
    }
}

