/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.DownloadAction;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.DownloadDetails;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.DownloadSpec;

public class Download
extends DefaultTask
implements DownloadSpec {
    private final DownloadAction action;

    public Download() {
        boolean isOffline = this.getProject().getGradle().getStartParameter().isOffline();
        this.action = new DownloadAction(this.getProject(), (Task)this);
        this.getOutputs().upToDateWhen(task -> !this.isOnlyIfModified() && !this.isOverwrite());
        this.onlyIf(task -> {
            if (isOffline) {
                for (File f : this.getOutputFiles()) {
                    if (f.exists()) {
                        if (this.isQuiet()) continue;
                        this.getProject().getLogger().info("Skipping existing file '" + f.getName() + "' in offline mode.");
                        continue;
                    }
                    throw new IllegalStateException("Unable to download file '" + f.getName() + "' in offline mode.");
                }
                return false;
            }
            return true;
        });
    }

    @TaskAction
    public void download() throws IOException {
        this.action.execute().thenRun(() -> {
            if (this.action.isUpToDate()) {
                this.getState().setDidWork(false);
            }
        });
    }

    @OutputFiles
    public List<File> getOutputFiles() {
        return this.action.getOutputFiles();
    }

    @Override
    public void src(Object src) {
        this.action.src(src);
    }

    @Override
    public void dest(Object dest) {
        this.action.dest(dest);
    }

    @Override
    public void quiet(boolean quiet) {
        this.action.quiet(quiet);
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.action.overwrite(overwrite);
    }

    @Override
    public void onlyIfModified(boolean onlyIfModified) {
        this.action.onlyIfModified(onlyIfModified);
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.action.onlyIfNewer(onlyIfNewer);
    }

    @Override
    public void compress(boolean compress) {
        this.action.compress(compress);
    }

    @Override
    public void username(String username) {
        this.action.username(username);
    }

    @Override
    public void password(String password) {
        this.action.password(password);
    }

    @Override
    public void preemptiveAuth(boolean preemptiveAuth) {
        this.action.preemptiveAuth(preemptiveAuth);
    }

    @Override
    public void headers(Map<String, String> headers) {
        this.action.headers(headers);
    }

    @Override
    public void header(String name, String value) {
        this.action.header(name, value);
    }

    @Override
    public void acceptAnyCertificate(boolean accept) {
        this.action.acceptAnyCertificate(accept);
    }

    @Override
    public void connectTimeout(int milliseconds) {
        this.action.connectTimeout(milliseconds);
    }

    @Override
    public void readTimeout(int milliseconds) {
        this.action.readTimeout(milliseconds);
    }

    @Override
    public void retries(int retries) {
        this.action.retries(retries);
    }

    @Override
    public void downloadTaskDir(Object dir2) {
        this.action.downloadTaskDir(dir2);
    }

    @Override
    public void tempAndMove(boolean tempAndMove) {
        this.action.tempAndMove(tempAndMove);
    }

    @Override
    public void useETag(Object useETag) {
        this.action.useETag(useETag);
    }

    @Override
    public void cachedETagsFile(Object location) {
        this.action.cachedETagsFile(location);
    }

    @Override
    public void eachFile(Action<? super DownloadDetails> action2) {
        this.action.eachFile(action2);
    }

    @Override
    public void method(String method) {
        this.action.method(method);
    }

    @Override
    public void body(String body) {
        this.action.body(body);
    }

    @Override
    @Input
    public Object getSrc() {
        return this.action.getSrc();
    }

    @Override
    @Internal
    public File getDest() {
        return this.action.getDest();
    }

    @Override
    @Console
    public boolean isQuiet() {
        return this.action.isQuiet();
    }

    @Override
    @Input
    public boolean isOverwrite() {
        return this.action.isOverwrite();
    }

    @Override
    @Input
    public boolean isOnlyIfModified() {
        return this.action.isOnlyIfModified();
    }

    @Override
    @Input
    public boolean isOnlyIfNewer() {
        return this.action.isOnlyIfNewer();
    }

    @Override
    @Input
    public boolean isCompress() {
        return this.action.isCompress();
    }

    @Override
    @Input
    @Optional
    public String getUsername() {
        return this.action.getUsername();
    }

    @Override
    @Input
    @Optional
    public String getPassword() {
        return this.action.getPassword();
    }

    @Override
    @Input
    public boolean isPreemptiveAuth() {
        return this.action.isPreemptiveAuth();
    }

    @Override
    @Input
    @Optional
    public Map<String, String> getHeaders() {
        return this.action.getHeaders();
    }

    @Override
    public String getHeader(String name) {
        return this.action.getHeader(name);
    }

    @Override
    @Input
    public boolean isAcceptAnyCertificate() {
        return this.action.isAcceptAnyCertificate();
    }

    @Override
    @Input
    public int getConnectTimeout() {
        return this.action.getConnectTimeout();
    }

    @Override
    @Input
    public int getReadTimeout() {
        return this.action.getReadTimeout();
    }

    @Override
    @Input
    public int getRetries() {
        return this.action.getRetries();
    }

    @Override
    @Internal
    public File getDownloadTaskDir() {
        return this.action.getDownloadTaskDir();
    }

    @Override
    @Input
    public boolean isTempAndMove() {
        return this.action.isTempAndMove();
    }

    @Override
    @Input
    @Optional
    public Object getUseETag() {
        return this.action.getUseETag();
    }

    @Override
    @Internal
    public File getCachedETagsFile() {
        return this.action.getCachedETagsFile();
    }

    @Override
    @Input
    @Optional
    public String getMethod() {
        return this.action.getMethod();
    }

    @Override
    @Input
    @Optional
    public String getBody() {
        return this.action.getBody();
    }
}

