/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.dsl.MacOSNotarizationSettings;
import org.jetbrains.compose.desktop.application.dsl.TargetFormat;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSNotarizationSettings;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSNotarizationSettingsKt;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.internal.utils.MacUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0007J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\n8AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractNotarizationTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "targetFormat", "Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;", "(Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;)V", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "nonValidatedNotarizationSettings", "Lorg/jetbrains/compose/desktop/application/dsl/MacOSNotarizationSettings;", "getNonValidatedNotarizationSettings$compose", "()Lorg/jetbrains/compose/desktop/application/dsl/MacOSNotarizationSettings;", "setNonValidatedNotarizationSettings$compose", "(Lorg/jetbrains/compose/desktop/application/dsl/MacOSNotarizationSettings;)V", "getTargetFormat", "()Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;", "notarize", "", "notarization", "Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSNotarizationSettings;", "packageFile", "Ljava/io/File;", "run", "staple", "compose"})
@SourceDebugExtension(value={"SMAP\nAbstractNotarizationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractNotarizationTask.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractNotarizationTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public abstract class AbstractNotarizationTask
extends AbstractComposeDesktopTask {
    @NotNull
    private final TargetFormat targetFormat;
    @Nullable
    private MacOSNotarizationSettings nonValidatedNotarizationSettings;
    @NotNull
    private final DirectoryProperty inputDir;

    @Inject
    public AbstractNotarizationTask(@NotNull TargetFormat targetFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetFormat), (String)"targetFormat");
        this.targetFormat = targetFormat;
        DirectoryProperty directoryProperty = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.inputDir = directoryProperty;
        if (!(this.targetFormat != TargetFormat.AppImage)) {
            boolean bl = false;
            String string = TargetFormat.AppImage + " cannot be notarized!";
            throw new IllegalStateException(string.toString());
        }
    }

    @Input
    @NotNull
    public final TargetFormat getTargetFormat() {
        return this.targetFormat;
    }

    @Nested
    @Optional
    @Nullable
    public final MacOSNotarizationSettings getNonValidatedNotarizationSettings$compose() {
        return this.nonValidatedNotarizationSettings;
    }

    public final void setNonValidatedNotarizationSettings$compose(@Nullable MacOSNotarizationSettings macOSNotarizationSettings) {
        this.nonValidatedNotarizationSettings = macOSNotarizationSettings;
    }

    @InputDirectory
    @NotNull
    public final DirectoryProperty getInputDir() {
        return this.inputDir;
    }

    @TaskAction
    public final void run() {
        ValidatedMacOSNotarizationSettings notarization = ValidatedMacOSNotarizationSettingsKt.validate(this.nonValidatedNotarizationSettings);
        File packageFile = FileUtilsKt.checkExistingFile(FileUtilsKt.findOutputFileOrDir(org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile((Provider)this.inputDir), this.targetFormat));
        this.notarize(notarization, packageFile);
        this.staple(packageFile);
    }

    private final void notarize(ValidatedMacOSNotarizationSettings notarization, File packageFile) {
        this.getLogger().info("Uploading '" + packageFile.getName() + "' for notarization");
        Object[] objectArray = new String[]{"notarytool", "submit", "--wait", "--apple-id", notarization.getAppleID(), "--team-id", notarization.getTeamID(), packageFile.getAbsolutePath()};
        List args2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), MacUtils.INSTANCE.getXcrun(), args2, null, null, false, null, null, notarization.getPassword(), 124, null);
    }

    private final void staple(File packageFile) {
        Object[] objectArray = new String[]{"stapler", "staple", packageFile.getAbsolutePath()};
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), MacUtils.INSTANCE.getXcrun(), CollectionsKt.listOf((Object[])objectArray), null, null, false, null, null, null, 252, null);
    }
}

