/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.tasks;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u001c\u0010\u0013\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001bH\u0002R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/compose/desktop/tasks/AbstractJarsFlattenTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "flattenedJar", "Lorg/gradle/api/file/RegularFileProperty;", "getFlattenedJar", "()Lorg/gradle/api/file/RegularFileProperty;", "inputFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "seenEntryNames", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getSeenEntryNames", "()Ljava/util/HashSet;", "execute", "", "writeEntryIfNotSeen", "Ljava/util/zip/ZipOutputStream;", "entry", "Ljava/util/zip/ZipEntry;", "inputStream", "Ljava/io/InputStream;", "writeFile", "file", "Ljava/io/File;", "writeJarContent", "jarFile", "compose"})
public abstract class AbstractJarsFlattenTask
extends AbstractComposeDesktopTask {
    @NotNull
    private final ConfigurableFileCollection inputFiles;
    @NotNull
    private final RegularFileProperty flattenedJar;
    @NotNull
    private final HashSet<String> seenEntryNames;

    public AbstractJarsFlattenTask() {
        ConfigurableFileCollection configurableFileCollection = this.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objects.fileCollection()");
        this.inputFiles = configurableFileCollection;
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.flattenedJar = regularFileProperty;
        this.seenEntryNames = new HashSet();
    }

    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getInputFiles() {
        return this.inputFiles;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getFlattenedJar() {
        return this.flattenedJar;
    }

    @Internal
    @NotNull
    public final HashSet<String> getSeenEntryNames() {
        return this.seenEntryNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void execute() {
        this.seenEntryNames.clear();
        Object object = new Object[]{this.flattenedJar};
        org.jetbrains.compose.internal.utils.FileUtilsKt.delete(this.getFileOperations(), object);
        object = new FileOutputStream(org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile((Provider)this.flattenedJar));
        int n = 8192;
        object = new ZipOutputStream(object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n));
        Throwable throwable = null;
        try {
            ZipOutputStream outputStream = (ZipOutputStream)object;
            boolean bl = false;
            FileTree fileTree = this.inputFiles.getAsFileTree().visit(arg_0 -> AbstractJarsFlattenTask.execute$lambda$1$lambda$0((Function1)new Function1<FileVisitDetails, Unit>(this, outputStream){
                final /* synthetic */ AbstractJarsFlattenTask this$0;
                final /* synthetic */ ZipOutputStream $outputStream;
                {
                    this.this$0 = $receiver;
                    this.$outputStream = $outputStream;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final void invoke(FileVisitDetails it) {
                    if (!it.isDirectory()) {
                        File file2 = it.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.file");
                        if (FileUtilsKt.isJarFile(file2)) {
                            File file3 = it.getFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it.file");
                            AbstractJarsFlattenTask.access$writeJarContent(this.this$0, this.$outputStream, file3);
                            return;
                        }
                    }
                    if (it.isDirectory()) return;
                    File file4 = it.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"it.file");
                    AbstractJarsFlattenTask.access$writeFile(this.this$0, this.$outputStream, file4);
                }
            }, arg_0));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeJarContent(ZipOutputStream $this$writeJarContent, File jarFile) {
        Closeable closeable = new ZipInputStream(new FileInputStream(jarFile));
        Throwable throwable = null;
        try {
            ZipInputStream inputStream = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry inputEntry = inputStream.getNextEntry();
            while (inputEntry != null) {
                this.writeEntryIfNotSeen($this$writeJarContent, inputEntry, inputStream);
                inputEntry = inputStream.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeFile(ZipOutputStream $this$writeFile, File file2) {
        Closeable closeable = new FileInputStream(file2);
        Throwable throwable = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            this.writeEntryIfNotSeen($this$writeFile, new ZipEntry(file2.getName()), inputStream);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void writeEntryIfNotSeen(ZipOutputStream $this$writeEntryIfNotSeen, ZipEntry entry, InputStream inputStream) {
        if (!this.seenEntryNames.contains(entry.getName())) {
            FileUtilsKt.copyZipEntry(entry, inputStream, $this$writeEntryIfNotSeen);
            ((Collection)this.seenEntryNames).add(entry.getName());
        }
    }

    private static final void execute$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$writeJarContent(AbstractJarsFlattenTask $this, ZipOutputStream $receiver, File jarFile) {
        $this.writeJarContent($receiver, jarFile);
    }

    public static final /* synthetic */ void access$writeFile(AbstractJarsFlattenTask $this, ZipOutputStream $receiver, File file2) {
        $this.writeFile($receiver, file2);
    }
}

