/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.DownloadAction;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.DownloadSpec;

public class DownloadExtension {
    private final ProjectLayout projectLayout;
    private final Logger logger;
    private final Object servicesOwner;
    private final ObjectFactory objectFactory;
    private final boolean isOffline;
    private final File buildDir;

    public DownloadExtension(Project project) {
        this(project, null);
    }

    @Inject
    public DownloadExtension(Task task2) {
        this(task2.getProject(), task2);
    }

    public DownloadExtension(Project project, @Nullable Task task2) {
        this(project.getLayout(), project.getLogger(), task2 != null ? task2 : project, project.getObjects(), project.getGradle().getStartParameter().isOffline(), (File)project.getLayout().getBuildDirectory().getAsFile().get());
    }

    private DownloadExtension(ProjectLayout projectLayout, Logger logger, Object servicesOwner, ObjectFactory objectFactory, boolean isOffline, File buildDir2) {
        this.projectLayout = projectLayout;
        this.logger = logger;
        this.servicesOwner = servicesOwner;
        this.objectFactory = objectFactory;
        this.isOffline = isOffline;
        this.buildDir = buildDir2;
    }

    public void run(Action<DownloadSpec> action2) {
        DownloadAction da = new DownloadAction(this.projectLayout, this.logger, this.servicesOwner, this.objectFactory, this.isOffline, this.buildDir);
        action2.execute((Object)da);
        try {
            da.execute(false).get();
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Could not download file";
            }
            throw new IllegalStateException(message, e);
        }
    }

    public CompletableFuture<Void> runAsync(Action<DownloadSpec> action2) {
        DownloadAction da = new DownloadAction(this.projectLayout, this.logger, this.servicesOwner, this.objectFactory, this.isOffline, this.buildDir);
        action2.execute((Object)da);
        try {
            return da.execute(false);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Could not download file";
            }
            throw new IllegalStateException(message, e);
        }
    }
}

