/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.NativeApplication;
import org.jetbrains.compose.desktop.application.dsl.TargetFormat;
import org.jetbrains.compose.desktop.application.internal.ConfigureNativeApplicationKt;
import org.jetbrains.compose.desktop.application.tasks.AbstractNativeMacApplicationPackageAppDirTask;
import org.jetbrains.compose.desktop.application.tasks.AbstractNativeMacApplicationPackageDmgTask;
import org.jetbrains.compose.desktop.application.tasks.AbstractNativeMacApplicationPackageTask;
import org.jetbrains.compose.desktop.tasks.AbstractUnpackDefaultComposeApplicationResourcesTask;
import org.jetbrains.compose.internal.utils.OS;
import org.jetbrains.compose.internal.utils.OsUtilsKt;
import org.jetbrains.compose.internal.utils.StringUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBinary;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeOutputKind;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001ap\u0010\u0010\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u0001H\u0011H\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u0001H\u0011H\u0011\u0018\u00010\u00070\u0007\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0019\b\n\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00010\u001a\u00a2\u0006\u0002\b\u001bH\u0082\b\u001a$\u0010\u001c\u001a\u00020\u0001*\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"configureNativeApplication", "", "project", "Lorg/gradle/api/Project;", "app", "Lorg/jetbrains/compose/desktop/application/dsl/NativeApplication;", "unpackDefaultResources", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeTarget;", "binary", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBinary;", "desktopNativeTaskName", "", "action", "composeDesktopNativeTask", "T", "kotlin.jvm.PlatformType", "Lorg/gradle/api/Task;", "Lorg/gradle/api/tasks/TaskContainer;", "name", "args", "", "", "configureFn", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "configureNativePackageTask", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractNativeMacApplicationPackageTask;", "format", "Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;", "compose"})
@SourceDebugExtension(value={"SMAP\nconfigureNativeApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 configureNativeApplication.kt\norg/jetbrains/compose/desktop/application/internal/ConfigureNativeApplicationKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n120#1,5:130\n125#1,5:137\n120#1,5:142\n125#1,5:149\n37#2,2:135\n37#2,2:147\n37#2,2:154\n1#3:156\n*S KotlinDebug\n*F\n+ 1 configureNativeApplication.kt\norg/jetbrains/compose/desktop/application/internal/ConfigureNativeApplicationKt\n*L\n57#1:130,5\n57#1:137,5\n76#1:142,5\n76#1:149,5\n57#1:135,2\n76#1:147,2\n124#1:154,2\n*E\n"})
public final class ConfigureNativeApplicationKt {
    public static final void configureNativeApplication(@NotNull Project project, @NotNull NativeApplication app, @NotNull TaskProvider<AbstractUnpackDefaultComposeApplicationResourcesTask> unpackDefaultResources2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter(unpackDefaultResources2, (String)"unpackDefaultResources");
        if (OsUtilsKt.getCurrentOS() != OS.MacOS) {
            return;
        }
        for (KotlinNativeTarget target : app.get_targets$compose()) {
            Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
            ConfigureNativeApplicationKt.configureNativeApplication(project, app, target, unpackDefaultResources2);
        }
    }

    private static final void configureNativeApplication(Project project, NativeApplication app, KotlinNativeTarget target, TaskProvider<AbstractUnpackDefaultComposeApplicationResourcesTask> unpackDefaultResources2) {
        for (NativeBinary binary : target.getBinaries()) {
            if (binary.getOutputKind() != NativeOutputKind.EXECUTABLE) continue;
            Intrinsics.checkNotNullExpressionValue((Object)binary, (String)"binary");
            ConfigureNativeApplicationKt.configureNativeApplication(project, app, binary, unpackDefaultResources2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void configureNativeApplication(Project project, NativeApplication app, NativeBinary binary, TaskProvider<AbstractUnpackDefaultComposeApplicationResourcesTask> unpackDefaultResources2) {
        TaskContainer name$iv;
        void $this$composeDesktopNativeTask_u24default$iv;
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = ConfigureNativeApplicationKt.desktopNativeTaskName("createDistributableNative", binary);
        Function1 configureFn$iv = (Function1)new Function1<AbstractNativeMacApplicationPackageAppDirTask, Unit>(app, binary, unpackDefaultResources2, project){
            final /* synthetic */ NativeApplication $app;
            final /* synthetic */ NativeBinary $binary;
            final /* synthetic */ TaskProvider<AbstractUnpackDefaultComposeApplicationResourcesTask> $unpackDefaultResources;
            final /* synthetic */ Project $project;
            {
                this.$app = $app;
                this.$binary = $binary;
                this.$unpackDefaultResources = $unpackDefaultResources;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull AbstractNativeMacApplicationPackageAppDirTask $this$composeDesktopNativeTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$composeDesktopNativeTask), (String)"$this$composeDesktopNativeTask");
                ConfigureNativeApplicationKt.access$configureNativePackageTask($this$composeDesktopNativeTask, this.$app, this.$binary, TargetFormat.AppImage);
                Object[] objectArray = new Object[]{this.$unpackDefaultResources};
                $this$composeDesktopNativeTask.dependsOn(objectArray);
                RegularFileProperty macIcon2 = this.$app.getDistributions().getMacOS().getIconFile();
                Provider defaultIcon2 = this.$unpackDefaultResources.flatMap(arg_0 -> configureNativeApplication.createDistributable.1.invoke$lambda$0(configureNativeApplication.createDistributable.defaultIcon.1.INSTANCE, arg_0));
                $this$composeDesktopNativeTask.getIconFile().set(macIcon2.orElse(defaultIcon2));
                Object[] objectArray2 = new Object[]{this.$binary.getLinkTaskProvider()};
                $this$composeDesktopNativeTask.dependsOn(objectArray2);
                $this$composeDesktopNativeTask.getExecutable().set(this.$project.getLayout().file(this.$binary.getLinkTaskProvider().map(arg_0 -> configureNativeApplication.createDistributable.1.invoke$lambda$1(configureNativeApplication.createDistributable.1.INSTANCE, arg_0))));
                $this$composeDesktopNativeTask.getAppCategory().set(this.$project.provider(() -> configureNativeApplication.createDistributable.1.invoke$lambda$2(this.$app)));
                $this$composeDesktopNativeTask.getCopyright().set(this.$project.provider(() -> configureNativeApplication.createDistributable.1.invoke$lambda$3(this.$app)));
            }

            private static final Provider invoke$lambda$0(Function1 $tmp0, Object in) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Provider)$tmp0.invoke(in);
            }

            private static final File invoke$lambda$1(Function1 $tmp0, Object in) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (File)$tmp0.invoke(in);
            }

            private static final String invoke$lambda$2(NativeApplication $app) {
                Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
                String string = $app.getDistributions().getMacOS().getAppCategory();
                if (string == null) {
                    string = "Unknown";
                }
                return string;
            }

            private static final String invoke$lambda$3(NativeApplication $app) {
                Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
                String string = $app.getDistributions().getCopyright();
                if (string == null) {
                    string = "Copyright (C) " + Calendar.getInstance().get(1);
                }
                return string;
            }
        };
        Object args$iv = CollectionsKt.emptyList();
        boolean $i$f$composeDesktopNativeTask = false;
        Collection $this$toTypedArray$iv$iv = (Collection)args$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        TaskProvider taskProvider = thisCollection$iv$iv.toArray(new Object[0]);
        TaskProvider $this$composeDesktopNativeTask_u24lambda_u243$iv = taskProvider = $this$composeDesktopNativeTask_u24default$iv.register((String)name$iv, AbstractNativeMacApplicationPackageAppDirTask.class, Arrays.copyOf(taskProvider, ((Object[])taskProvider).length));
        boolean bl = false;
        thisCollection$iv$iv = (Function1)new Function1<AbstractNativeMacApplicationPackageAppDirTask, Unit>(configureFn$iv){
            final /* synthetic */ Function1 $configureFn;
            {
                this.$configureFn = $configureFn;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(Task it) {
                it.setGroup("compose desktop (native)");
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.$configureFn.invoke((Object)it);
            }
        };
        $this$composeDesktopNativeTask_u24lambda_u243$iv.configure(new Action((Function1)thisCollection$iv$iv, null){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
            {
                this(function);
            }
        });
        TaskProvider createDistributable2 = taskProvider;
        if (app.getDistributions().getTargetFormats().contains((Object)TargetFormat.Dmg)) {
            void name$iv2;
            void $this$composeDesktopNativeTask_u24default$iv2;
            TaskContainer taskContainer3 = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"project.tasks");
            name$iv = taskContainer3;
            args$iv = ConfigureNativeApplicationKt.desktopNativeTaskName("packageDmgNative", binary);
            Function1 configureFn$iv2 = (Function1)new Function1<AbstractNativeMacApplicationPackageDmgTask, Unit>(app, binary, (TaskProvider<AbstractNativeMacApplicationPackageAppDirTask>)createDistributable2, project){
                final /* synthetic */ NativeApplication $app;
                final /* synthetic */ NativeBinary $binary;
                final /* synthetic */ TaskProvider<AbstractNativeMacApplicationPackageAppDirTask> $createDistributable;
                final /* synthetic */ Project $project;
                {
                    this.$app = $app;
                    this.$binary = $binary;
                    this.$createDistributable = $createDistributable;
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(@NotNull AbstractNativeMacApplicationPackageDmgTask $this$composeDesktopNativeTask) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$composeDesktopNativeTask), (String)"$this$composeDesktopNativeTask");
                    ConfigureNativeApplicationKt.access$configureNativePackageTask($this$composeDesktopNativeTask, this.$app, this.$binary, TargetFormat.Dmg);
                    Object[] objectArray = new Object[]{this.$createDistributable};
                    $this$composeDesktopNativeTask.dependsOn(objectArray);
                    $this$composeDesktopNativeTask.getAppDir().set(this.$createDistributable.flatMap(arg_0 -> configureNativeApplication.packageDmg.1.invoke$lambda$0(configureNativeApplication.packageDmg.1.INSTANCE, arg_0)));
                    $this$composeDesktopNativeTask.getInstallDir().set(this.$project.provider(() -> configureNativeApplication.packageDmg.1.invoke$lambda$1(this.$app)));
                }

                private static final Provider invoke$lambda$0(Function1 $tmp0, Object in) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Provider)$tmp0.invoke(in);
                }

                private static final String invoke$lambda$1(NativeApplication $app) {
                    Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
                    String string = $app.getDistributions().getMacOS().getInstallationPath();
                    if (string == null) {
                        string = "/Applications";
                    }
                    return string;
                }
            };
            List args$iv2 = CollectionsKt.emptyList();
            boolean $i$f$composeDesktopNativeTask2 = false;
            Collection $this$toTypedArray$iv$iv2 = args$iv2;
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv$iv2 = $this$toTypedArray$iv$iv2;
            TaskProvider taskProvider2 = thisCollection$iv$iv2.toArray(new Object[0]);
            TaskProvider $this$composeDesktopNativeTask_u24lambda_u243$iv2 = taskProvider2 = $this$composeDesktopNativeTask_u24default$iv2.register((String)name$iv2, AbstractNativeMacApplicationPackageDmgTask.class, Arrays.copyOf(taskProvider2, ((Object[])taskProvider2).length));
            $i$a$-apply-ConfigureNativeApplicationKt$composeDesktopNativeTask$2$iv = false;
            taskProvider = (Function1)new Function1<AbstractNativeMacApplicationPackageDmgTask, Unit>(configureFn$iv2){
                final /* synthetic */ Function1 $configureFn;
                {
                    this.$configureFn = $configureFn;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(Task it) {
                    it.setGroup("compose desktop (native)");
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$configureFn.invoke((Object)it);
                }
            };
            $this$composeDesktopNativeTask_u24lambda_u243$iv2.configure(new /* invalid duplicate definition of identical inner class */);
            taskContainer2 = taskProvider2;
        }
    }

    private static final void configureNativePackageTask(AbstractNativeMacApplicationPackageTask $this$configureNativePackageTask, NativeApplication app, NativeBinary binary, TargetFormat format) {
        $this$configureNativePackageTask.getPackageName().set($this$configureNativePackageTask.getProject().provider(() -> ConfigureNativeApplicationKt.configureNativePackageTask$lambda$0(app, $this$configureNativePackageTask)));
        $this$configureNativePackageTask.getPackageVersion().set($this$configureNativePackageTask.getProject().provider(() -> ConfigureNativeApplicationKt.configureNativePackageTask$lambda$2(app, $this$configureNativePackageTask)));
        DirectoryProperty directoryProperty = $this$configureNativePackageTask.getDestinationDir();
        DirectoryProperty directoryProperty2 = app.getDistributions().getOutputBaseDir();
        StringBuilder stringBuilder = new StringBuilder().append(app.getName()).append("/native-").append(binary.getTarget().getName()).append('-');
        String string = binary.getBuildType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        directoryProperty.set(directoryProperty2.dir(stringBuilder.append(string).append('-').append(format.getId$compose()).toString()));
    }

    private static final String desktopNativeTaskName(String action2, NativeBinary binary) {
        String[] stringArray = new String[3];
        stringArray[0] = action2;
        Intrinsics.checkNotNullExpressionValue((Object)binary.getBuildType().name().toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        stringArray[2] = binary.getTarget().getName();
        return StringUtilsKt.joinLowerCamelCase(stringArray);
    }

    private static final /* synthetic */ <T extends Task> TaskProvider<T> composeDesktopNativeTask(TaskContainer $this$composeDesktopNativeTask, String name, List<? extends Object> args2, Function1<? super T, Unit> configureFn) {
        boolean $i$f$composeDesktopNativeTask = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Collection $this$toTypedArray$iv = args2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TaskProvider taskProvider = thisCollection$iv.toArray(new Object[0]);
        TaskProvider $this$composeDesktopNativeTask_u24lambda_u243 = taskProvider = $this$composeDesktopNativeTask.register(name, Task.class, Arrays.copyOf(taskProvider, ((Object[])taskProvider).length));
        boolean bl = false;
        Intrinsics.needClassReification();
        Function1 function1 = new Function1<T, Unit>(configureFn){
            final /* synthetic */ Function1<T, Unit> $configureFn;
            {
                this.$configureFn = $configureFn;
                super(1);
            }

            public final void invoke(T it) {
                it.setGroup("compose desktop (native)");
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                this.$configureFn.invoke(it);
            }
        };
        $this$composeDesktopNativeTask_u24lambda_u243.configure(new /* invalid duplicate definition of identical inner class */);
        return taskProvider;
    }

    static /* synthetic */ TaskProvider composeDesktopNativeTask$default(TaskContainer $this$composeDesktopNativeTask_u24default, String name, List args2, Function1 configureFn, int n, Object taskProvider) {
        if ((n & 2) != 0) {
            args2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            Intrinsics.needClassReification();
            configureFn = composeDesktopNativeTask.1.INSTANCE;
        }
        boolean $i$f$composeDesktopNativeTask = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Collection $this$toTypedArray$iv = args2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        taskProvider = thisCollection$iv.toArray(new Object[0]);
        TaskProvider $this$composeDesktopNativeTask_u24lambda_u243 = taskProvider = $this$composeDesktopNativeTask_u24default.register(name, Task.class, Arrays.copyOf(taskProvider, ((Object[])taskProvider).length));
        boolean bl = false;
        Intrinsics.needClassReification();
        Function1 function1 = new /* invalid duplicate definition of identical inner class */;
        $this$composeDesktopNativeTask_u24lambda_u243.configure(new /* invalid duplicate definition of identical inner class */);
        return taskProvider;
    }

    private static final String configureNativePackageTask$lambda$0(NativeApplication $app, AbstractNativeMacApplicationPackageTask $this_configureNativePackageTask) {
        Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
        Intrinsics.checkNotNullParameter((Object)((Object)$this_configureNativePackageTask), (String)"$this_configureNativePackageTask");
        String string = $app.getDistributions().getMacOS().getPackageName();
        if (string == null && (string = $app.getDistributions().getPackageName()) == null) {
            string = $this_configureNativePackageTask.getProject().getName();
        }
        return string;
    }

    private static final String configureNativePackageTask$lambda$2(NativeApplication $app, AbstractNativeMacApplicationPackageTask $this_configureNativePackageTask) {
        Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
        Intrinsics.checkNotNullParameter((Object)((Object)$this_configureNativePackageTask), (String)"$this_configureNativePackageTask");
        String string = $app.getDistributions().getMacOS().getPackageVersion();
        if (string == null && (string = $app.getDistributions().getPackageVersion()) == null) {
            String string2;
            String it = string2 = $this_configureNativePackageTask.getProject().getVersion().toString();
            boolean bl = false;
            string = !Intrinsics.areEqual((Object)it, (Object)"unspecified") ? string2 : null;
            if (string == null) {
                string = "1.0.0";
            }
        }
        return string;
    }

    public static final /* synthetic */ void access$configureNativePackageTask(AbstractNativeMacApplicationPackageTask $receiver, NativeApplication app, NativeBinary binary, TargetFormat format) {
        ConfigureNativeApplicationKt.configureNativePackageTask($receiver, app, binary, format);
    }
}

