/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.ComposeProperties;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.internal.utils.FileUtilsKt;
import org.jetbrains.compose.internal.utils.OsUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0017H\u0014J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cH\u0014J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0007J\b\u0010%\u001a\u00020\u0017H\u0014R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractJvmToolOperationTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "toolName", "", "(Ljava/lang/String;)V", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "freeArgs", "Lorg/gradle/api/provider/ListProperty;", "getFreeArgs", "()Lorg/gradle/api/provider/ListProperty;", "javaHome", "Lorg/gradle/api/provider/Property;", "getJavaHome", "()Lorg/gradle/api/provider/Property;", "workingDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getWorkingDir", "()Lorg/gradle/api/provider/Provider;", "checkResult", "", "result", "Lorg/gradle/process/ExecResult;", "initState", "jvmToolEnvironment", "", "makeArgs", "", "tmpDir", "Ljava/io/File;", "prepareWorkingDir", "inputChanges", "Lorg/gradle/work/InputChanges;", "run", "saveStateAfterFinish", "compose"})
public abstract class AbstractJvmToolOperationTask
extends AbstractComposeDesktopTask {
    @NotNull
    private final String toolName;
    @NotNull
    private final Provider<Directory> workingDir;
    @NotNull
    private final DirectoryProperty destinationDir;
    @NotNull
    private final ListProperty<String> freeArgs;
    @NotNull
    private final Property<String> javaHome;

    /*
     * WARNING - void declaration
     */
    public AbstractJvmToolOperationTask(@NotNull String toolName) {
        void $this$javaHome_u24lambda_u240;
        Property property;
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        this.toolName = toolName;
        Provider provider = this.getProject().getLayout().getBuildDirectory().dir("compose/tmp/" + this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026.dir(\"compose/tmp/$name\")");
        this.workingDir = provider;
        DirectoryProperty directoryProperty = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.destinationDir = directoryProperty;
        ListProperty listProperty = this.getObjects().listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"objects.listProperty(String::class.java)");
        this.freeArgs = listProperty;
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty22 = false;
        Property property2 = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        Property $i$f$notNullProperty22 = property = property2;
        AbstractJvmToolOperationTask abstractJvmToolOperationTask = this;
        boolean bl = false;
        $this$javaHome_u24lambda_u240.set(this.getProviders().systemProperty("java.home"));
        abstractJvmToolOperationTask.javaHome = property;
    }

    @LocalState
    @NotNull
    protected final Provider<Directory> getWorkingDir() {
        return this.workingDir;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @Input
    @Optional
    @NotNull
    public final ListProperty<String> getFreeArgs() {
        return this.freeArgs;
    }

    @Internal
    @NotNull
    public final Property<String> getJavaHome() {
        return this.javaHome;
    }

    protected void prepareWorkingDir(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        Provider[] providerArray = new Provider[]{this.workingDir};
        FileUtilsKt.clearDirs(this.getFileOperations(), providerArray);
    }

    @NotNull
    protected List<String> makeArgs(@NotNull File tmpDir) {
        ArrayList<String> arrayList;
        block1: {
            List list;
            Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
            ArrayList<String> $this$makeArgs_u24lambda_u242 = arrayList = new ArrayList<String>();
            boolean bl = false;
            List list2 = list = (List)this.freeArgs.getOrNull();
            if (list2 == null) break block1;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"orNull");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                $this$makeArgs_u24lambda_u242.add(it);
            }
        }
        return arrayList;
    }

    @NotNull
    protected Map<String, String> jvmToolEnvironment() {
        return new HashMap();
    }

    protected void checkResult(@NotNull ExecResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        result2.assertNormalExitValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public final void run(@NotNull InputChanges inputChanges) {
        block3: {
            Object[] objectArray;
            File file2;
            Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
            this.initState();
            File jtool = OsUtilsKt.jvmToolFile(this.toolName, (Provider<String>)((Provider)this.javaHome));
            Object[] objectArray2 = new Object[]{this.destinationDir};
            FileUtilsKt.delete(this.getFileOperations(), objectArray2);
            this.prepareWorkingDir(inputChanges);
            File dir2 = FileUtilsKt.getIoFile(this.workingDir);
            boolean bl = false;
            List<String> args2 = this.makeArgs(dir2);
            File $this$run_u24lambda_u244_u24lambda_u243 = file2 = FilesKt.resolveSibling((File)dir2, (String)(this.getName() + ".args.txt"));
            boolean bl2 = false;
            FilesKt.writeText$default((File)$this$run_u24lambda_u244_u24lambda_u243, (String)CollectionsKt.joinToString$default((Iterable)args2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
            File argsFile = file2;
            try {
                Object[] it = objectArray = ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), jtool, CollectionsKt.listOf((Object)('@' + argsFile.getAbsolutePath())), this.jvmToolEnvironment(), null, false, null, null, 120, null);
                boolean bl3 = false;
                this.checkResult((ExecResult)it);
                if (((Boolean)ComposeProperties.INSTANCE.preserveWorkingDir(this.getProviders()).get()).booleanValue()) break block3;
            }
            catch (Throwable throwable) {
                if (!((Boolean)ComposeProperties.INSTANCE.preserveWorkingDir(this.getProviders()).get()).booleanValue()) {
                    Object[] objectArray3 = new Object[]{this.workingDir};
                    FileUtilsKt.delete(this.getFileOperations(), objectArray3);
                }
                throw throwable;
            }
            objectArray = new Object[]{this.workingDir};
            FileUtilsKt.delete(this.getFileOperations(), objectArray);
        }
        this.saveStateAfterFinish();
    }

    protected void initState() {
    }

    protected void saveStateAfterFinish() {
    }
}

