/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.message;

import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.Contract;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HeaderElement;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.NameValuePair;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.message.HeaderValueFormatter;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.CharArrayBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    public static final BasicHeaderValueFormatter INSTANCE = new BasicHeaderValueFormatter();
    private static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    private static final String UNSAFE_CHARS = "\"\\";

    @Override
    public void formatElements(CharArrayBuffer buffer, HeaderElement[] elems, boolean quote) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(elems, "Header element array");
        for (int i2 = 0; i2 < elems.length; ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            this.formatHeaderElement(buffer, elems[i2], quote);
        }
    }

    @Override
    public void formatHeaderElement(CharArrayBuffer buffer, HeaderElement elem, boolean quote) {
        int c;
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(elem, "Header element");
        buffer.append(elem.getName());
        String value = elem.getValue();
        if (value != null) {
            buffer.append('=');
            this.formatValue(buffer, value, quote);
        }
        if ((c = elem.getParameterCount()) > 0) {
            for (int i2 = 0; i2 < c; ++i2) {
                buffer.append("; ");
                this.formatNameValuePair(buffer, elem.getParameter(i2), quote);
            }
        }
    }

    @Override
    public void formatParameters(CharArrayBuffer buffer, NameValuePair[] nvps, boolean quote) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(nvps, "Header parameter array");
        for (int i2 = 0; i2 < nvps.length; ++i2) {
            if (i2 > 0) {
                buffer.append("; ");
            }
            this.formatNameValuePair(buffer, nvps[i2], quote);
        }
    }

    @Override
    public void formatNameValuePair(CharArrayBuffer buffer, NameValuePair nvp, boolean quote) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(nvp, "Name / value pair");
        buffer.append(nvp.getName());
        String value = nvp.getValue();
        if (value != null) {
            buffer.append('=');
            this.formatValue(buffer, value, quote);
        }
    }

    void formatValue(CharArrayBuffer buffer, String value, boolean quote) {
        int i2;
        boolean quoteFlag = quote;
        if (!quoteFlag) {
            for (i2 = 0; i2 < value.length() && !quoteFlag; ++i2) {
                quoteFlag = this.isSeparator(value.charAt(i2));
            }
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
        for (i2 = 0; i2 < value.length(); ++i2) {
            char ch = value.charAt(i2);
            if (this.isUnsafe(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
    }

    boolean isSeparator(char ch) {
        return SEPARATORS.indexOf(ch) >= 0;
    }

    boolean isUnsafe(char ch) {
        return UNSAFE_CHARS.indexOf(ch) >= 0;
    }
}

