/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.internal;

import java.net.URL;
import java.util.Objects;
import org.gradle.api.file.RelativePath;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.DownloadDetails;

public class DefaultDownloadDetails
implements DownloadDetails {
    private RelativePath relativePath;
    private final URL sourceURL;

    public DefaultDownloadDetails(RelativePath relativePath, URL sourceURL) {
        this.relativePath = relativePath;
        this.sourceURL = sourceURL;
    }

    @Override
    public void setName(String name) {
        this.relativePath = this.relativePath.replaceLastName(name);
    }

    @Override
    public String getName() {
        return this.relativePath.getLastName();
    }

    @Override
    public URL getSourceURL() {
        return this.sourceURL;
    }

    @Override
    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void setRelativePath(RelativePath path) {
        this.relativePath = path;
    }

    @Override
    public String getPath() {
        return this.relativePath.getPathString();
    }

    @Override
    public void setPath(String path) {
        this.relativePath = RelativePath.parse((boolean)this.relativePath.isFile(), (String)path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDownloadDetails that = (DefaultDownloadDetails)o;
        return this.relativePath.equals((Object)that.relativePath) && this.sourceURL.equals(that.sourceURL);
    }

    public int hashCode() {
        return Objects.hash(this.relativePath, this.sourceURL);
    }

    public String toString() {
        return "DefaultDownloadDetails{relativePath='" + this.relativePath + '\'' + ", sourceURL=" + this.sourceURL + '}';
    }
}

