/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.ComposeCompilerKotlinSupportPluginKt;
import org.jetbrains.compose.experimental.internal.ConfigureNativeCompilerCachingKt;
import org.jetbrains.compose.internal.utils.BuildEventsListenerRegistryProvider;
import org.jetbrains.compose.internal.utils.FileUtilsKt;
import org.jetbrains.compose.internal.utils.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginArtifact;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\bR\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00150\u0007X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\n\u00a8\u0006#"}, d2={"Lorg/jetbrains/compose/ComposeMultiplatformBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/compose/ComposeMultiplatformBuildService$Parameters;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "delayedWarnings", "Lorg/gradle/api/provider/SetProperty;", "", "getDelayedWarnings$compose", "()Lorg/gradle/api/provider/SetProperty;", "gradlePropertiesSnapshot", "", "getGradlePropertiesSnapshot$compose", "()Ljava/util/Map;", "localPropertiesSnapshot", "getLocalPropertiesSnapshot$compose", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "unsupportedCompilerPlugins", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginArtifact;", "getUnsupportedCompilerPlugins$compose", "close", "", "logDelayedWarnings", "notifyAboutUnsupportedCompilerPlugin", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "warnOnceAfterBuild", "message", "Companion", "Parameters", "compose"})
public abstract class ComposeMultiplatformBuildService
implements BuildService<Parameters>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final Map<String, String> gradlePropertiesSnapshot;
    @NotNull
    private final Map<String, String> localPropertiesSnapshot;
    private static final String COMPOSE_SERVICE_FQ_NAME = ComposeMultiplatformBuildService.class.getCanonicalName();

    public ComposeMultiplatformBuildService() {
        Object object = ((Parameters)this.getParameters()).getGradlePropertiesCacheKindSnapshot().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.gradlePropertiesCacheKindSnapshot.get()");
        this.gradlePropertiesSnapshot = (Map)object;
        Object object2 = ((Parameters)this.getParameters()).getLocalPropertiesCacheKindSnapshot().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.localPropertiesCacheKindSnapshot.get()");
        this.localPropertiesSnapshot = (Map)object2;
    }

    @NotNull
    public abstract SetProperty<Provider<SubpluginArtifact>> getUnsupportedCompilerPlugins$compose();

    @NotNull
    public abstract SetProperty<String> getDelayedWarnings$compose();

    @NotNull
    public final Map<String, String> getGradlePropertiesSnapshot$compose() {
        return this.gradlePropertiesSnapshot;
    }

    @NotNull
    public final Map<String, String> getLocalPropertiesSnapshot$compose() {
        return this.localPropertiesSnapshot;
    }

    public final void warnOnceAfterBuild(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getDelayedWarnings$compose().add((Object)message);
    }

    @Override
    public void close() {
        this.notifyAboutUnsupportedCompilerPlugin();
        this.logDelayedWarnings();
    }

    private final void notifyAboutUnsupportedCompilerPlugin() {
        Provider provider;
        SubpluginArtifact unsupportedCompilerPlugin;
        Set set = (Set)this.getUnsupportedCompilerPlugins$compose().getOrNull();
        SubpluginArtifact subpluginArtifact = unsupportedCompilerPlugin = set != null && (provider = (Provider)CollectionsKt.firstOrNull((Iterable)set)) != null ? (SubpluginArtifact)provider.getOrNull() : null;
        if (unsupportedCompilerPlugin != null) {
            this.log.error(ComposeCompilerKotlinSupportPluginKt.createWarningAboutNonCompatibleCompiler(unsupportedCompilerPlugin.getGroupId()));
        }
    }

    private final void logDelayedWarnings() {
        for (String warning : (Set)this.getDelayedWarnings$compose().get()) {
            this.log.warn(warning);
        }
    }

    public void onFinish(@NotNull FinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/compose/ComposeMultiplatformBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "()V", "gradlePropertiesCacheKindSnapshot", "Lorg/gradle/api/provider/MapProperty;", "", "getGradlePropertiesCacheKindSnapshot", "()Lorg/gradle/api/provider/MapProperty;", "localPropertiesCacheKindSnapshot", "getLocalPropertiesCacheKindSnapshot", "compose"})
    public static abstract class Parameters
    implements BuildServiceParameters {
        @NotNull
        public abstract MapProperty<String, String> getGradlePropertiesCacheKindSnapshot();

        @NotNull
        public abstract MapProperty<String, String> getLocalPropertiesCacheKindSnapshot();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\r\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/compose/ComposeMultiplatformBuildService$Companion;", "", "()V", "COMPOSE_SERVICE_FQ_NAME", "", "kotlin.jvm.PlatformType", "findExistingComposeService", "Lorg/jetbrains/compose/ComposeMultiplatformBuildService;", "project", "Lorg/gradle/api/Project;", "getInstance", "init", "", "initPropertiesSnapshots", "Lorg/jetbrains/compose/ComposeMultiplatformBuildService$Parameters;", "rootProject", "compose"})
    public static final class Companion {
        private Companion() {
        }

        private final ComposeMultiplatformBuildService findExistingComposeService(Project project) {
            BuildService service;
            BuildServiceRegistration registration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(COMPOSE_SERVICE_FQ_NAME);
            BuildServiceRegistration buildServiceRegistration = registration;
            BuildService buildService = buildServiceRegistration != null && (buildServiceRegistration = buildServiceRegistration.getService()) != null ? (BuildService)buildServiceRegistration.getOrNull() : (service = null);
            if (service != null) {
                if (!(service instanceof ComposeMultiplatformBuildService)) {
                    if (Intrinsics.areEqual((Object)service.getClass().getCanonicalName(), (Object)ComposeMultiplatformBuildService.class.getCanonicalName())) {
                        File rootScript = project.getRootProject().getBuildFile();
                        throw new IllegalStateException(StringsKt.trimIndent((String)("\n                            Compose Multiplatform Gradle plugin has been loaded in multiple classloaders.\n                            To avoid classloading issues, declare Compose Gradle Plugin in root build file " + rootScript + ".\n                        ")).toString());
                    }
                    throw new IllegalStateException(("Shared build service '" + COMPOSE_SERVICE_FQ_NAME + "' has unexpected type: " + service.getClass().getCanonicalName()).toString());
                }
                return (ComposeMultiplatformBuildService)service;
            }
            return null;
        }

        @NotNull
        public final ComposeMultiplatformBuildService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComposeMultiplatformBuildService composeMultiplatformBuildService = this.findExistingComposeService(project);
            if (composeMultiplatformBuildService == null) {
                throw new IllegalStateException("ComposeMultiplatformBuildService was not initialized!".toString());
            }
            return composeMultiplatformBuildService;
        }

        public final void init(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComposeMultiplatformBuildService existingService = this.findExistingComposeService(project);
            if (existingService != null) {
                return;
            }
            Provider newService2 = project.getGradle().getSharedServices().registerIfAbsent(COMPOSE_SERVICE_FQ_NAME, ComposeMultiplatformBuildService.class, arg_0 -> Companion.init$lambda$0((Function1)new Function1<BuildServiceSpec<Parameters>, Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Parameters> it) {
                    BuildServiceParameters buildServiceParameters = it.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)buildServiceParameters, (String)"it.parameters");
                    Parameters parameters = (Parameters)buildServiceParameters;
                    Project project = this.$project.getRootProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
                    org.jetbrains.compose.ComposeMultiplatformBuildService$Companion.access$initPropertiesSnapshots(ComposeMultiplatformBuildService.Companion, parameters, project);
                }
            }, arg_0));
            BuildEventsListenerRegistryProvider.Companion.getInstance(project).onTaskCompletion(newService2);
        }

        private final void initPropertiesSnapshots(Parameters $this$initPropertiesSnapshots, Project rootProject) {
            File file2 = GradleUtilsKt.getLocalPropertiesFile(rootProject);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"rootProject.localPropertiesFile");
            Properties localProperties = FileUtilsKt.loadProperties(file2);
            for (String cacheKindProperty : ConfigureNativeCompilerCachingKt.getSUPPORTED_NATIVE_CACHE_KIND_PROPERTIES()) {
                Object object;
                Object value;
                Object object2 = rootProject.findProperty(cacheKindProperty);
                if (object2 != null && (object2 = object2.toString()) != null) {
                    value = object2;
                    boolean bl = false;
                    $this$initPropertiesSnapshots.getGradlePropertiesCacheKindSnapshot().put((Object)cacheKindProperty, value);
                }
                if ((object = localProperties.get(cacheKindProperty)) == null || (object = object.toString()) == null) continue;
                value = object;
                boolean bl = false;
                $this$initPropertiesSnapshots.getLocalPropertiesCacheKindSnapshot().put((Object)cacheKindProperty, value);
            }
        }

        private static final void init$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$initPropertiesSnapshots(Companion $this, Parameters $receiver, Project rootProject) {
            $this.initPropertiesSnapshots($receiver, rootProject);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

