/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.experimental.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.ProjectExtensionsKt;
import org.jetbrains.compose.internal.utils.KGPPropertyProvider;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.UtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\fH\u0002\u001a\f\u0010\u001a\u001a\u00020\u0019*\u00020\u001bH\u0000\u001a\f\u0010\u001c\u001a\u00020\u0019*\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u001d"}, d2={"COMPOSE_NATIVE_MANAGE_CACHE_KIND", "", "NONE_VALUE", "PROJECT_CACHE_KIND_PROPERTY_NAME", "SUPPORTED_NATIVE_CACHE_KIND_PROPERTIES", "", "getSUPPORTED_NATIVE_CACHE_KIND_PROPERTIES", "()Ljava/util/List;", "SUPPORTED_NATIVE_TARGETS", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "targetCacheKindPropertyName", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeTarget;", "getTargetCacheKindPropertyName", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeTarget;)Ljava/lang/String;", "(Lorg/jetbrains/kotlin/konan/target/KonanTarget;)Ljava/lang/String;", "explicitCacheKindErrorMessage", "cacheKindProperty", "value", "provider", "Lorg/jetbrains/compose/internal/utils/KGPPropertyProvider;", "kotlinVersionNumbers", "Lkotlin/KotlinVersion;", "version", "checkExplicitCacheKind", "", "configureNativeCompilerCaching", "Lorg/gradle/api/Project;", "disableKotlinNativeCache", "compose"})
@SourceDebugExtension(value={"SMAP\nconfigureNativeCompilerCaching.kt\nKotlin\n*S Kotlin\n*F\n+ 1 configureNativeCompilerCaching.kt\norg/jetbrains/compose/experimental/internal/ConfigureNativeCompilerCachingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1549#2:131\n1620#2,3:132\n*S KotlinDebug\n*F\n+ 1 configureNativeCompilerCaching.kt\norg/jetbrains/compose/experimental/internal/ConfigureNativeCompilerCachingKt\n*L\n50#1:131\n50#1:132,3\n*E\n"})
public final class ConfigureNativeCompilerCachingKt {
    @NotNull
    private static final String PROJECT_CACHE_KIND_PROPERTY_NAME = "kotlin.native.cacheKind";
    @NotNull
    private static final String COMPOSE_NATIVE_MANAGE_CACHE_KIND = "compose.kotlin.native.manageCacheKind";
    @NotNull
    private static final String NONE_VALUE = "none";
    @NotNull
    private static final Set<KonanTarget> SUPPORTED_NATIVE_TARGETS;
    @NotNull
    private static final List<String> SUPPORTED_NATIVE_CACHE_KIND_PROPERTIES;

    @NotNull
    public static final List<String> getSUPPORTED_NATIVE_CACHE_KIND_PROPERTIES() {
        return SUPPORTED_NATIVE_CACHE_KIND_PROPERTIES;
    }

    public static final void configureNativeCompilerCaching(@NotNull Project $this$configureNativeCompilerCaching) {
        Intrinsics.checkNotNullParameter((Object)$this$configureNativeCompilerCaching, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$configureNativeCompilerCaching.findProperty(COMPOSE_NATIVE_MANAGE_CACHE_KIND), (Object)"false")) {
            return;
        }
        $this$configureNativeCompilerCaching.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> ConfigureNativeCompilerCachingKt.configureNativeCompilerCaching$lambda$1((Function1)new Function1<Plugin<?>, Unit>($this$configureNativeCompilerCaching){
            final /* synthetic */ Project $this_configureNativeCompilerCaching;
            {
                this.$this_configureNativeCompilerCaching = $receiver;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                Project project = this.$this_configureNativeCompilerCaching.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                KotlinVersion kotlinPluginVersion = ConfigureNativeCompilerCachingKt.kotlinVersionNumbers(KotlinPluginWrapperKt.getKotlinPluginVersion((Project)project));
                DomainObjectCollection $this$configureEachWithType$iv = (DomainObjectCollection)ProjectExtensionsKt.getMppExt(this.$this_configureNativeCompilerCaching).getTargets();
                boolean $i$f$configureEachWithType = false;
                $this$configureEachWithType$iv.configureEach(new Action(kotlinPluginVersion){
                    final /* synthetic */ KotlinVersion $kotlinPluginVersion$inlined;
                    {
                        this.$kotlinPluginVersion$inlined = kotlinVersion;
                    }

                    public final void execute(Object it) {
                        if (it instanceof KotlinNativeTarget) {
                            KotlinNativeTarget $this$invoke_u24lambda_u240 = (KotlinNativeTarget)it;
                            boolean bl = false;
                            if (ConfigureNativeCompilerCachingKt.access$getSUPPORTED_NATIVE_TARGETS$p().contains($this$invoke_u24lambda_u240.getKonanTarget())) {
                                ConfigureNativeCompilerCachingKt.access$checkExplicitCacheKind($this$invoke_u24lambda_u240);
                                if (this.$kotlinPluginVersion$inlined.compareTo(new KotlinVersion(1, 9, 20)) < 0) {
                                    ConfigureNativeCompilerCachingKt.access$disableKotlinNativeCache($this$invoke_u24lambda_u240);
                                }
                            }
                        }
                    }
                });
            }
        }, arg_0));
    }

    private static final void checkExplicitCacheKind(KotlinNativeTarget $this$checkExplicitCacheKind) {
        Object[] objectArray = new String[]{ConfigureNativeCompilerCachingKt.getTargetCacheKindPropertyName($this$checkExplicitCacheKind), PROJECT_CACHE_KIND_PROPERTY_NAME};
        List cacheKindProperties = CollectionsKt.listOf((Object[])objectArray);
        KGPPropertyProvider[] kGPPropertyProviderArray = new KGPPropertyProvider[]{new KGPPropertyProvider.GradleProperties($this$checkExplicitCacheKind.getProject()), new KGPPropertyProvider.LocalProperties($this$checkExplicitCacheKind.getProject())};
        List propertyProviders = CollectionsKt.listOf((Object[])kGPPropertyProviderArray);
        for (String cacheKindProperty : cacheKindProperties) {
            for (KGPPropertyProvider provider : propertyProviders) {
                String value = provider.valueOrNull(cacheKindProperty);
                if (value == null) continue;
                throw new IllegalStateException(ConfigureNativeCompilerCachingKt.explicitCacheKindErrorMessage(cacheKindProperty, value, provider).toString());
            }
        }
    }

    private static final String explicitCacheKindErrorMessage(String cacheKindProperty, String value, KGPPropertyProvider provider) {
        return StringsKt.trimMargin$default((String)("\n    |Error: '" + cacheKindProperty + "' is explicitly set to '" + value + "'.\n    |This option significantly slows the Kotlin/Native compiler.\n    |Compose Multiplatform Gradle plugin manages this property automatically based on a Kotlin compiler version being used.\n    |  * Recommended action: remove explicit '" + cacheKindProperty + '=' + value + "' from " + provider.getLocation() + ". \n    |  * Alternative action: disable cache kind management by adding 'compose.kotlin.native.manageCacheKind=false' to your 'gradle.properties'.\n"), null, (int)1, null);
    }

    private static final String getTargetCacheKindPropertyName(KotlinNativeTarget $this$targetCacheKindPropertyName) {
        return ConfigureNativeCompilerCachingKt.getTargetCacheKindPropertyName($this$targetCacheKindPropertyName.getKonanTarget());
    }

    private static final String getTargetCacheKindPropertyName(KonanTarget $this$targetCacheKindPropertyName) {
        return "kotlin.native.cacheKind." + UtilsKt.getPresetName((KonanTarget)$this$targetCacheKindPropertyName);
    }

    private static final void disableKotlinNativeCache(KotlinNativeTarget $this$disableKotlinNativeCache) {
        String existingValue;
        Object object = $this$disableKotlinNativeCache.getProject().findProperty(ConfigureNativeCompilerCachingKt.getTargetCacheKindPropertyName($this$disableKotlinNativeCache));
        String string = existingValue = object != null ? object.toString() : null;
        if (StringsKt.equals((String)NONE_VALUE, (String)existingValue, (boolean)true)) {
            return;
        }
        Map map = $this$disableKotlinNativeCache.getProject().getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"project.properties");
        Map map2 = map;
        if (map2.containsKey(ConfigureNativeCompilerCachingKt.getTargetCacheKindPropertyName($this$disableKotlinNativeCache))) {
            $this$disableKotlinNativeCache.getProject().setProperty(ConfigureNativeCompilerCachingKt.getTargetCacheKindPropertyName($this$disableKotlinNativeCache), (Object)NONE_VALUE);
        } else {
            $this$disableKotlinNativeCache.getProject().getExtensions().getExtraProperties().set(ConfigureNativeCompilerCachingKt.getTargetCacheKindPropertyName($this$disableKotlinNativeCache), (Object)NONE_VALUE);
        }
    }

    @NotNull
    public static final KotlinVersion kotlinVersionNumbers(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        MatchResult matchResult = Regex.find$default((Regex)new Regex("(\\d+)\\.(\\d+)\\.(\\d+)"), (CharSequence)version, (int)0, (int)2, null);
        if (matchResult == null) {
            throw new IllegalStateException(("Kotlin version has unexpected format: '" + version + '\'').toString());
        }
        MatchResult m = matchResult;
        List list = m.getGroupValues();
        String majorPart = (String)list.get(1);
        String minorPart = (String)list.get(2);
        String patchPart = (String)list.get(3);
        Integer n = StringsKt.toIntOrNull((String)majorPart);
        if (n == null) {
            throw new IllegalStateException(("Could not parse major part '" + majorPart + "' of Kotlin plugin version: '" + version + '\'').toString());
        }
        Integer n2 = StringsKt.toIntOrNull((String)minorPart);
        if (n2 == null) {
            throw new IllegalStateException(("Could not parse minor part '" + minorPart + "' of Kotlin plugin version: '" + version + '\'').toString());
        }
        Integer n3 = StringsKt.toIntOrNull((String)patchPart);
        if (n3 == null) {
            throw new IllegalStateException(("Could not parse patch part '" + patchPart + "' of Kotlin plugin version: '" + version + '\'').toString());
        }
        return new KotlinVersion(n.intValue(), n2.intValue(), n3.intValue());
    }

    private static final void configureNativeCompilerCaching$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Set access$getSUPPORTED_NATIVE_TARGETS$p() {
        return SUPPORTED_NATIVE_TARGETS;
    }

    public static final /* synthetic */ void access$checkExplicitCacheKind(KotlinNativeTarget $receiver) {
        ConfigureNativeCompilerCachingKt.checkExplicitCacheKind($receiver);
    }

    public static final /* synthetic */ void access$disableKotlinNativeCache(KotlinNativeTarget $receiver) {
        ConfigureNativeCompilerCachingKt.disableKotlinNativeCache($receiver);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Object[] objectArray = new KonanTarget[]{KonanTarget.IOS_ARM32.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.IOS_ARM64.INSTANCE, KonanTarget.IOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.MACOS_X64.INSTANCE, KonanTarget.MACOS_ARM64.INSTANCE, KonanTarget.TVOS_X64.INSTANCE, KonanTarget.TVOS_ARM64.INSTANCE, KonanTarget.TVOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.WATCHOS_ARM64.INSTANCE, KonanTarget.WATCHOS_ARM32.INSTANCE, KonanTarget.WATCHOS_X64.INSTANCE, KonanTarget.WATCHOS_X86.INSTANCE, KonanTarget.WATCHOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.MINGW_X64.INSTANCE, KonanTarget.LINUX_X64.INSTANCE};
        SUPPORTED_NATIVE_TARGETS = SetsKt.setOf((Object[])objectArray);
        Iterable $this$map$iv = SUPPORTED_NATIVE_TARGETS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KonanTarget konanTarget = (KonanTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ConfigureNativeCompilerCachingKt.getTargetCacheKindPropertyName((KonanTarget)it));
        }
        SUPPORTED_NATIVE_CACHE_KIND_PROPERTIES = CollectionsKt.plus((Collection)((List)var3_3), (Object)PROJECT_CACHE_KIND_PROPERTY_NAME);
    }
}

