/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.utils;

import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.internal.utils.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a%\u0010\t\u001a\u00020\n*\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u000e\u001a5\u0010\t\u001a\u00020\n*\u00020\u000b2\"\u0010\f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00040\r\"\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0004H\u0000\u00a2\u0006\u0002\u0010\u000f\u001a%\u0010\u0010\u001a\u00020\n*\u00020\u000b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\r\"\u00020\u0012H\u0000\u00a2\u0006\u0002\u0010\u0013\u001a \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004*\b\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004*\b\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004*\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a'\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\r*\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00040\rH\u0002\u00a2\u0006\u0002\u0010\u001e\u001a%\u0010\u001f\u001a\u00020\n*\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u000e\u001a5\u0010\u001f\u001a\u00020\n*\u00020\u000b2\"\u0010\f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00040\r\"\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0004H\u0000\u00a2\u0006\u0002\u0010\u000f\u001a \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u0004*\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\"(\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"*\u0010\u0007\u001a\u0004\u0018\u00010\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006!"}, d2={"ioFile", "Ljava/io/File;", "T", "Lorg/gradle/api/file/FileSystemLocation;", "Lorg/gradle/api/provider/Provider;", "getIoFile", "(Lorg/gradle/api/provider/Provider;)Ljava/io/File;", "ioFileOrNull", "getIoFileOrNull", "clearDirs", "", "Lorg/gradle/api/file/FileSystemOperations;", "dirs", "", "(Lorg/gradle/api/file/FileSystemOperations;[Ljava/io/File;)V", "(Lorg/gradle/api/file/FileSystemOperations;[Lorg/gradle/api/provider/Provider;)V", "delete", "files", "", "(Lorg/gradle/api/file/FileSystemOperations;[Ljava/lang/Object;)V", "dir", "Lorg/gradle/api/file/Directory;", "relativePath", "", "file", "Lorg/gradle/api/file/RegularFile;", "fileToDir", "project", "Lorg/gradle/api/Project;", "ioFiles", "([Lorg/gradle/api/provider/Provider;)[Ljava/io/File;", "mkdirs", "toDir", "compose"})
public final class FileUtilsKt {
    @NotNull
    public static final Provider<Directory> toDir(@NotNull Provider<String> $this$toDir, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$toDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Provider provider = project.getLayout().dir($this$toDir.map(arg_0 -> FileUtilsKt.toDir$lambda$0(toDir.1.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.dir(map { File(it) })");
        return provider;
    }

    @NotNull
    public static final Provider<Directory> fileToDir(@NotNull Provider<File> $this$fileToDir, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$fileToDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Provider provider = project.getLayout().dir($this$fileToDir);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.dir(this)");
        return provider;
    }

    @NotNull
    public static final Provider<RegularFile> file(@NotNull Provider<Directory> $this$file, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Provider provider = $this$file.map(arg_0 -> FileUtilsKt.file$lambda$1((Function1)new Function1<Directory, RegularFile>(relativePath){
            final /* synthetic */ String $relativePath;
            {
                this.$relativePath = $relativePath;
                super(1);
            }

            public final RegularFile invoke(Directory it) {
                return it.file(this.$relativePath);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"relativePath: String): P\u2026{ it.file(relativePath) }");
        return provider;
    }

    @NotNull
    public static final Provider<Directory> dir(@NotNull Provider<Directory> $this$dir, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$dir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Provider provider = $this$dir.map(arg_0 -> FileUtilsKt.dir$lambda$2((Function1)new Function1<Directory, Directory>(relativePath){
            final /* synthetic */ String $relativePath;
            {
                this.$relativePath = $relativePath;
                super(1);
            }

            public final Directory invoke(Directory it) {
                return it.dir(this.$relativePath);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"relativePath: String): P\u2026 { it.dir(relativePath) }");
        return provider;
    }

    @NotNull
    public static final <T extends FileSystemLocation> File getIoFile(@NotNull Provider<T> $this$ioFile) {
        Intrinsics.checkNotNullParameter($this$ioFile, (String)"<this>");
        File file2 = ((FileSystemLocation)$this$ioFile.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"get().asFile");
        return file2;
    }

    @Nullable
    public static final <T extends FileSystemLocation> File getIoFileOrNull(@NotNull Provider<T> $this$ioFileOrNull) {
        Intrinsics.checkNotNullParameter($this$ioFileOrNull, (String)"<this>");
        FileSystemLocation fileSystemLocation = (FileSystemLocation)$this$ioFileOrNull.getOrNull();
        return fileSystemLocation != null ? fileSystemLocation.getAsFile() : null;
    }

    public static final void delete(@NotNull FileSystemOperations $this$delete, Object ... files) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        $this$delete.delete(arg_0 -> FileUtilsKt.delete$lambda$3((Function1)new Function1<DeleteSpec, Unit>(files){
            final /* synthetic */ Object[] $files;
            {
                this.$files = $files;
                super(1);
            }

            public final void invoke(DeleteSpec it) {
                it.delete(Arrays.copyOf(this.$files, this.$files.length));
            }
        }, arg_0));
    }

    public static final void mkdirs(@NotNull FileSystemOperations $this$mkdirs, File ... dirs) {
        Intrinsics.checkNotNullParameter((Object)$this$mkdirs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dirs, (String)"dirs");
        for (File dir2 : dirs) {
            dir2.mkdirs();
        }
    }

    public static final void mkdirs(@NotNull FileSystemOperations $this$mkdirs, Provider<? extends FileSystemLocation> ... dirs) {
        Intrinsics.checkNotNullParameter((Object)$this$mkdirs, (String)"<this>");
        Intrinsics.checkNotNullParameter(dirs, (String)"dirs");
        File[] fileArray = FileUtilsKt.ioFiles(dirs);
        FileUtilsKt.mkdirs($this$mkdirs, Arrays.copyOf(fileArray, fileArray.length));
    }

    public static final void clearDirs(@NotNull FileSystemOperations $this$clearDirs, File ... dirs) {
        Intrinsics.checkNotNullParameter((Object)$this$clearDirs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dirs, (String)"dirs");
        FileUtilsKt.delete($this$clearDirs, Arrays.copyOf(dirs, dirs.length));
        FileUtilsKt.mkdirs($this$clearDirs, Arrays.copyOf(dirs, dirs.length));
    }

    public static final void clearDirs(@NotNull FileSystemOperations $this$clearDirs, Provider<? extends FileSystemLocation> ... dirs) {
        Intrinsics.checkNotNullParameter((Object)$this$clearDirs, (String)"<this>");
        Intrinsics.checkNotNullParameter(dirs, (String)"dirs");
        File[] fileArray = FileUtilsKt.ioFiles(dirs);
        FileUtilsKt.clearDirs($this$clearDirs, Arrays.copyOf(fileArray, fileArray.length));
    }

    private static final File[] ioFiles(Provider<? extends FileSystemLocation>[] $this$ioFiles) {
        Provider<? extends FileSystemLocation>[] providers = $this$ioFiles;
        boolean bl = false;
        int n = 0;
        int n2 = $this$ioFiles.length;
        File[] fileArray = new File[n2];
        while (n < n2) {
            int n3 = n++;
            fileArray[n3] = FileUtilsKt.getIoFile(providers[n3]);
        }
        return fileArray;
    }

    private static final File toDir$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    private static final RegularFile file$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RegularFile)$tmp0.invoke(p0);
    }

    private static final Directory dir$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Directory)$tmp0.invoke(p0);
    }

    private static final void delete$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

