/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl;

import java.nio.ByteBuffer;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;

abstract class SSLManagedBuffer {
    SSLManagedBuffer() {
    }

    abstract ByteBuffer acquire();

    abstract void release();

    abstract boolean isAcquired();

    abstract boolean hasData();

    static SSLManagedBuffer create(SSLBufferMode mode, int size2) {
        return mode == SSLBufferMode.DYNAMIC ? new DynamicBuffer(size2) : new StaticBuffer(size2);
    }

    static final class DynamicBuffer
    extends SSLManagedBuffer {
        private ByteBuffer wrapped;
        private final int length;

        public DynamicBuffer(int size2) {
            Args.positive(size2, "size");
            this.length = size2;
        }

        @Override
        public ByteBuffer acquire() {
            if (this.wrapped != null) {
                return this.wrapped;
            }
            this.wrapped = ByteBuffer.allocate(this.length);
            return this.wrapped;
        }

        @Override
        public void release() {
            this.wrapped = null;
        }

        @Override
        public boolean isAcquired() {
            return this.wrapped != null;
        }

        @Override
        public boolean hasData() {
            return this.wrapped != null && this.wrapped.position() > 0;
        }
    }

    static final class StaticBuffer
    extends SSLManagedBuffer {
        private final ByteBuffer buffer;

        public StaticBuffer(int size2) {
            Args.positive(size2, "size");
            this.buffer = ByteBuffer.allocate(size2);
        }

        @Override
        public ByteBuffer acquire() {
            return this.buffer;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isAcquired() {
            return true;
        }

        @Override
        public boolean hasData() {
            return this.buffer.position() > 0;
        }
    }
}

