/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.preview.tasks;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.OsUtilsKt;
import org.jetbrains.compose.desktop.preview.tasks.AbstractConfigureDesktopPreviewTask;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.CommandsKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewHostConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnection;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnectionKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0007J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0012\u0010$\u001a\u00020\n*\b\u0012\u0004\u0012\u00020#0%H\u0002R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00128AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00168AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u001e\u0010\u001d\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007\u00a8\u0006'"}, d2={"Lorg/jetbrains/compose/desktop/preview/tasks/AbstractConfigureDesktopPreviewTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "hostClasspath", "Lorg/gradle/api/artifacts/Configuration;", "kotlin.jvm.PlatformType", "getHostClasspath$compose", "()Lorg/gradle/api/artifacts/Configuration;", "idePort", "Lorg/gradle/api/provider/Provider;", "", "getIdePort$compose", "()Lorg/gradle/api/provider/Provider;", "javaHome", "Lorg/gradle/api/provider/Property;", "getJavaHome$compose", "()Lorg/gradle/api/provider/Property;", "jvmArgs", "Lorg/gradle/api/provider/ListProperty;", "getJvmArgs$compose", "()Lorg/gradle/api/provider/ListProperty;", "previewClasspath", "Lorg/gradle/api/file/FileCollection;", "getPreviewClasspath$compose", "()Lorg/gradle/api/file/FileCollection;", "setPreviewClasspath$compose", "(Lorg/gradle/api/file/FileCollection;)V", "previewTarget", "getPreviewTarget$compose", "uiTooling", "getUiTooling$compose", "run", "", "tryGetSkikoRuntimeFilesIfNeeded", "", "Ljava/io/File;", "pathString", "Lkotlin/sequences/Sequence;", "GradlePreviewLoggerAdapter", "compose"})
public abstract class AbstractConfigureDesktopPreviewTask
extends AbstractComposeDesktopTask {
    public FileCollection previewClasspath;
    @NotNull
    private final Property<String> javaHome;
    @NotNull
    private final ListProperty<String> jvmArgs;
    @NotNull
    private final Provider<String> previewTarget;
    @NotNull
    private final Provider<String> idePort;
    private final Configuration uiTooling;
    private final Configuration hostClasspath;

    /*
     * WARNING - void declaration
     */
    public AbstractConfigureDesktopPreviewTask() {
        void $this$uiTooling_u24lambda_u241;
        Dependency[] $this$javaHome_u24lambda_u240;
        Dependency[] dependencyArray;
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty22 = false;
        Dependency[] dependencyArray2 = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyArray2, (String)"property(T::class.java)");
        Dependency[] $i$f$notNullProperty22 = dependencyArray = dependencyArray2;
        AbstractConfigureDesktopPreviewTask abstractConfigureDesktopPreviewTask = this;
        boolean bl = false;
        $this$javaHome_u24lambda_u240.set(this.getProviders().systemProperty("java.home"));
        abstractConfigureDesktopPreviewTask.javaHome = dependencyArray;
        ListProperty listProperty = this.getObjects().listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"objects.listProperty(String::class.java)");
        this.jvmArgs = listProperty;
        Provider provider = this.getProject().getProviders().gradleProperty("compose.desktop.preview.target");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.providers.gradle\u2026.desktop.preview.target\")");
        this.previewTarget = provider;
        Provider provider2 = this.getProject().getProviders().gradleProperty("compose.desktop.preview.ide.port");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.providers.gradle\u2026esktop.preview.ide.port\")");
        this.idePort = provider2;
        dependencyArray = new Dependency[]{this.getProject().getDependencies().create((Object)"org.jetbrains.compose.ui:ui-tooling-desktop:1.2.2")};
        $this$javaHome_u24lambda_u240 = dependencyArray = this.getProject().getConfigurations().detachedConfiguration(dependencyArray);
        abstractConfigureDesktopPreviewTask = this;
        boolean bl2 = false;
        $this$uiTooling_u24lambda_u241.setTransitive(false);
        abstractConfigureDesktopPreviewTask.uiTooling = dependencyArray;
        dependencyArray = new Dependency[]{this.getProject().getDependencies().create((Object)"org.jetbrains.compose:preview-rpc:1.2.2")};
        this.hostClasspath = this.getProject().getConfigurations().detachedConfiguration(dependencyArray);
    }

    @InputFiles
    @NotNull
    public final FileCollection getPreviewClasspath$compose() {
        FileCollection fileCollection = this.previewClasspath;
        if (fileCollection != null) {
            return fileCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"previewClasspath");
        return null;
    }

    public final void setPreviewClasspath$compose(@NotNull FileCollection fileCollection) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"<set-?>");
        this.previewClasspath = fileCollection;
    }

    @Internal
    @NotNull
    public final Property<String> getJavaHome$compose() {
        return this.javaHome;
    }

    @Input
    @Optional
    @NotNull
    public final ListProperty<String> getJvmArgs$compose() {
        return this.jvmArgs;
    }

    @Input
    @NotNull
    public final Provider<String> getPreviewTarget$compose() {
        return this.previewTarget;
    }

    @Input
    @NotNull
    public final Provider<String> getIdePort$compose() {
        return this.idePort;
    }

    @InputFiles
    public final Configuration getUiTooling$compose() {
        return this.uiTooling;
    }

    @InputFiles
    public final Configuration getHostClasspath$compose() {
        return this.hostClasspath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        Object object = this.javaHome.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaHome.get()");
        String string = OsUtilsKt.javaExecutable((String)object);
        Set set = this.hostClasspath.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"hostClasspath.files");
        PreviewHostConfig hostConfig = new PreviewHostConfig(string, this.pathString((Sequence<? extends File>)CollectionsKt.asSequence((Iterable)set)));
        Set set2 = this.getPreviewClasspath$compose().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"previewClasspath.files");
        Sequence sequence = CollectionsKt.asSequence((Iterable)set2);
        Set set3 = this.uiTooling.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"uiTooling.files");
        String previewClasspathString = this.pathString((Sequence<? extends File>)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence((Iterable)set3)), (Sequence)CollectionsKt.asSequence((Iterable)this.tryGetSkikoRuntimeFilesIfNeeded())));
        Logger gradleLogger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)gradleLogger, (String)"gradleLogger");
        GradlePreviewLoggerAdapter previewLogger = new GradlePreviewLoggerAdapter(gradleLogger);
        Object object2 = this.idePort.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"idePort.get()");
        RemoteConnection connection2 = RemoteConnectionKt.getLocalConnectionOrNull(Integer.parseInt((String)object2), previewLogger, (Function0<Unit>)((Function0)run.connection.1.INSTANCE));
        if (connection2 != null) {
            AutoCloseable autoCloseable = connection2;
            Throwable throwable = null;
            try {
                RemoteConnection it = (RemoteConnection)autoCloseable;
                boolean bl = false;
                Object object3 = this.previewTarget.get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"previewTarget.get()");
                CommandsKt.sendConfigFromGradle(connection2, hostConfig, previewClasspathString, (String)object3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        } else {
            gradleLogger.error("Could not connect to IDE");
        }
    }

    private final Collection<File> tryGetSkikoRuntimeFilesIfNeeded() {
        try {
            boolean hasSkikoJvm = false;
            boolean hasSkikoJvmRuntime = false;
            String skikoVersion = null;
            for (File file2 : this.getPreviewClasspath$compose().getFiles()) {
                String string = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                String string2 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
                if (StringsKt.startsWith$default((String)string2, (String)"skiko-awt-runtime-", (boolean)false, (int)2, null)) {
                    hasSkikoJvmRuntime = true;
                    continue;
                }
                String string3 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
                if (!StringsKt.startsWith$default((String)string3, (String)"skiko-awt-", (boolean)false, (int)2, null)) continue;
                hasSkikoJvm = true;
                String string4 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.name");
                skikoVersion = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string4, (CharSequence)"skiko-awt-"), (CharSequence)".jar");
            }
            if (hasSkikoJvmRuntime) {
                return CollectionsKt.emptyList();
            }
            if (hasSkikoJvm && skikoVersion != null && !StringsKt.isBlank((CharSequence)skikoVersion)) {
                Configuration configuration = new Configuration[]{this.getProject().getDependencies().create((Object)("org.jetbrains.skiko:skiko-awt-runtime-" + OsUtilsKt.getCurrentTarget().getId() + ':' + skikoVersion))};
                Configuration $this$tryGetSkikoRuntimeFilesIfNeeded_u24lambda_u243 = configuration = this.getProject().getConfigurations().detachedConfiguration((Dependency[])configuration);
                boolean bl = false;
                $this$tryGetSkikoRuntimeFilesIfNeeded_u24lambda_u243.setTransitive(false);
                Configuration skikoRuntimeConfig = configuration;
                Set set = skikoRuntimeConfig.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"skikoRuntimeConfig.files");
                return set;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CollectionsKt.emptyList();
    }

    private final String pathString(Sequence<? extends File> $this$pathString) {
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return SequencesKt.joinToString$default($this$pathString, (CharSequence)string, null, null, (int)0, null, (Function1)pathString.1.INSTANCE, (int)30, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/compose/desktop/preview/tasks/AbstractConfigureDesktopPreviewTask$GradlePreviewLoggerAdapter;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "isEnabled", "", "()Z", "log", "", "s", "", "compose"})
    private static final class GradlePreviewLoggerAdapter
    extends PreviewLogger {
        @NotNull
        private final Logger logger;

        public GradlePreviewLoggerAdapter(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
        }

        @Override
        public boolean isEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void log(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.logger.info("Compose Preview: " + s);
        }
    }
}

