/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.GradleUtilsKt;
import org.jetbrains.compose.desktop.application.internal.JvmRuntimeProperties;
import org.jetbrains.compose.desktop.application.internal.OsUtilsKt;
import org.jetbrains.compose.desktop.application.tasks.AbstractCheckNativeDistributionRuntime;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R2\u0010\u0013\u001a&\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014 \u0015*\u0012\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractCheckNativeDistributionRuntime;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "javaExec", "Ljava/io/File;", "getJavaExec", "()Ljava/io/File;", "javaHome", "Lorg/gradle/api/provider/Property;", "", "getJavaHome", "()Lorg/gradle/api/provider/Property;", "javaRuntimePropertiesFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getJavaRuntimePropertiesFile", "()Lorg/gradle/api/provider/Provider;", "javacExec", "getJavacExec", "taskDir", "Lorg/gradle/api/file/Directory;", "kotlin.jvm.PlatformType", "workingDir", "getWorkingDir", "getJavaRuntimeVersionUnsafe", "getTool", "toolName", "run", "", "compose"})
public abstract class AbstractCheckNativeDistributionRuntime
extends AbstractComposeDesktopTask {
    @NotNull
    private final Property<String> javaHome;
    private final Provider<Directory> taskDir;
    @NotNull
    private final Provider<RegularFile> javaRuntimePropertiesFile;
    @NotNull
    private final Provider<Directory> workingDir;

    public AbstractCheckNativeDistributionRuntime() {
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty = false;
        Property property = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.javaHome = property;
        this.taskDir = this.getProject().getLayout().getBuildDirectory().dir("compose/tmp/" + this.getName());
        Provider provider = this.taskDir.map(arg_0 -> AbstractCheckNativeDistributionRuntime.javaRuntimePropertiesFile$lambda$0(javaRuntimePropertiesFile.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"taskDir.map { it.file(\"properties.bin\") }");
        this.javaRuntimePropertiesFile = provider;
        Provider provider2 = this.taskDir.map(arg_0 -> AbstractCheckNativeDistributionRuntime.workingDir$lambda$1(workingDir.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"taskDir.map { it.dir(\"localState\") }");
        this.workingDir = provider2;
    }

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputDirectory
    @NotNull
    public final Property<String> getJavaHome() {
        return this.javaHome;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getJavaRuntimePropertiesFile() {
        return this.javaRuntimePropertiesFile;
    }

    @LocalState
    @NotNull
    public final Provider<Directory> getWorkingDir() {
        return this.workingDir;
    }

    private final File getJavaExec() {
        return this.getTool("java");
    }

    private final File getJavacExec() {
        return this.getTool("javac");
    }

    private final File getTool(String toolName) {
        File javaHomeBin = FilesKt.resolve((File)new File((String)this.javaHome.get()), (String)"bin");
        File tool = FilesKt.resolve((File)javaHomeBin, (String)OsUtilsKt.executableName(toolName));
        if (!tool.exists()) {
            boolean bl = false;
            String string = "Could not find " + tool + " at: " + tool.getAbsolutePath() + '}';
            throw new IllegalStateException(string.toString());
        }
        return tool;
    }

    @TaskAction
    public final void run() {
        int n;
        Provider<Directory> provider = this.taskDir;
        Intrinsics.checkNotNullExpressionValue(provider, (String)"taskDir");
        GradleUtilsKt.getIoFile(provider).mkdirs();
        try {
            Object object = this.getJavaRuntimeVersionUnsafe();
            n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : -1;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not infer Java runtime version for Java home directory: " + (String)this.javaHome.get(), e);
        }
        int javaRuntimeVersion = n;
        if (!(javaRuntimeVersion >= 15)) {
            boolean $i$a$-check-AbstractCheckNativeDistributionRuntime$run$22 = false;
            String $i$a$-check-AbstractCheckNativeDistributionRuntime$run$22 = StringsKt.trimMargin$default((String)("|Packaging native distributions requires JDK runtime version >= 15\n               |Actual version: '" + Integer.valueOf(javaRuntimeVersion) + "'\n               |Java home: " + (String)this.javaHome.get() + "\n            "), null, (int)1, null);
            throw new IllegalStateException($i$a$-check-AbstractCheckNativeDistributionRuntime$run$22.toString());
        }
        ArrayList<String> modules = new ArrayList<String>();
        ExternalToolRunner $i$a$-check-AbstractCheckNativeDistributionRuntime$run$22 = this.getRunExternalTool$compose();
        File file2 = this.getJavaExec();
        List list = CollectionsKt.listOf((Object)"--list-modules");
        ExternalToolRunner.LogToConsole logToConsole = ExternalToolRunner.LogToConsole.Never;
        ExternalToolRunner.invoke$default($i$a$-check-AbstractCheckNativeDistributionRuntime$run$22, file2, list, null, null, false, (Function1)new Function1<String, Unit>(modules){
            final /* synthetic */ ArrayList<String> $modules;
            {
                this.$modules = $modules;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String stdout) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                Sequence sequence = StringsKt.lineSequence((CharSequence)stdout);
                ArrayList<String> arrayList = this.$modules;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl = false;
                    String moduleName = StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"@", null, (int)2, null);
                    if (!(!StringsKt.isBlank((CharSequence)moduleName))) continue;
                    arrayList.add(moduleName);
                }
            }
        }, logToConsole, 28, null);
        JvmRuntimeProperties properties = new JvmRuntimeProperties(javaRuntimeVersion, (List<String>)modules);
        JvmRuntimeProperties.Companion.writeToFile(properties, GradleUtilsKt.getIoFile(this.javaRuntimePropertiesFile));
    }

    private final String getJavaRuntimeVersionUnsafe() {
        Object[] objectArray;
        Provider[] providerArray = new Provider[]{this.workingDir};
        this.cleanDirs(providerArray);
        File workingDir2 = GradleUtilsKt.getIoFile(this.workingDir);
        String printJavaRuntimeClassName = "PrintJavaRuntimeVersion";
        String javaVersionPrefix = "Java runtime version = '";
        String javaVersionSuffix = "'";
        Object[] $this$getJavaRuntimeVersionUnsafe_u24lambda_u244 = objectArray = FilesKt.resolve((File)workingDir2, (String)("java/" + printJavaRuntimeClassName + ".java"));
        boolean bl = false;
        $this$getJavaRuntimeVersionUnsafe_u24lambda_u244.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$getJavaRuntimeVersionUnsafe_u24lambda_u244, (String)StringsKt.trimIndent((String)("\n                import java.lang.reflect.Method;\n\n                public class " + printJavaRuntimeClassName + " {\n                    public static void main(String[] args) {\n                        Class<Runtime> runtimeClass = Runtime.class;\n                        try {\n                            Method version = runtimeClass.getMethod(\"version\");\n                            Object runtimeVer = version.invoke(runtimeClass);\n                            Class<? extends Object> runtimeVerClass = runtimeVer.getClass();\n                            try {\n                                int feature = (int) runtimeVerClass.getMethod(\"feature\").invoke(runtimeVer);\n                                printVersionAndHalt((Integer.valueOf(feature)).toString());\n                            } catch (NoSuchMethodException e) {\n                                int major = (int) runtimeVerClass.getMethod(\"major\").invoke(runtimeVer);\n                                printVersionAndHalt((Integer.valueOf(major)).toString());\n                            }\n                        } catch (Exception e) {\n                            printVersionAndHalt(System.getProperty(\"java.version\"));\n                        }\n                    }\n\n                    private static void printVersionAndHalt(String version) {\n                        System.out.println(\"" + javaVersionPrefix + "\" + version + \"" + javaVersionSuffix + "\");\n                        Runtime.getRuntime().exit(0);\n                    }\n                }\n            ")), null, (int)2, null);
        Object[] printJavaRuntimeJava = objectArray;
        File classFilesDir = FilesKt.resolve((File)workingDir2, (String)"out-classes");
        $this$getJavaRuntimeVersionUnsafe_u24lambda_u244 = new String[]{"-source", "1.8", "-target", "1.8", "-d", classFilesDir.getAbsolutePath(), printJavaRuntimeJava.getAbsolutePath()};
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), this.getJavacExec(), CollectionsKt.listOf((Object[])$this$getJavaRuntimeVersionUnsafe_u24lambda_u244), null, null, false, null, null, 124, null);
        Ref.ObjectRef javaRuntimeVersion = new Ref.ObjectRef();
        Object[] objectArray2 = new String[]{"-cp", classFilesDir.getAbsolutePath(), printJavaRuntimeClassName};
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), this.getJavaExec(), CollectionsKt.listOf((Object[])objectArray2), null, null, false, (Function1)new Function1<String, Unit>(javaVersionPrefix, javaVersionSuffix, (Ref.ObjectRef<String>)javaRuntimeVersion){
            final /* synthetic */ String $javaVersionPrefix;
            final /* synthetic */ String $javaVersionSuffix;
            final /* synthetic */ Ref.ObjectRef<String> $javaRuntimeVersion;
            {
                this.$javaVersionPrefix = $javaVersionPrefix;
                this.$javaVersionSuffix = $javaVersionSuffix;
                this.$javaRuntimeVersion = $javaRuntimeVersion;
                super(1);
            }

            public final void invoke(@NotNull String stdout) {
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                MatchResult m = Regex.find$default((Regex)new Regex(this.$javaVersionPrefix + "(.+)" + this.$javaVersionSuffix), (CharSequence)stdout, (int)0, (int)2, null);
                Object object = m;
                this.$javaRuntimeVersion.element = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
            }
        }, null, 92, null);
        return (String)javaRuntimeVersion.element;
    }

    private static final RegularFile javaRuntimePropertiesFile$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RegularFile)$tmp0.invoke(p0);
    }

    private static final Directory workingDir$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Directory)$tmp0.invoke(p0);
    }
}

