/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.MacOSSigningSettings;
import org.jetbrains.compose.desktop.application.internal.OS;
import org.jetbrains.compose.desktop.application.internal.OsUtilsKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidateBundleIDKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSSigningSettings;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a4\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ERR_PREFIX", "", "ERR_UNKNOWN_PREFIX", "ERR_UNKNOWN_SIGN_ID", "ERR_WRONG_OS", "validate", "Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;", "Lorg/jetbrains/compose/desktop/application/dsl/MacOSSigningSettings;", "bundleIDProvider", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "appStoreProvider", "", "compose"})
public final class ValidatedMacOSSigningSettingsKt {
    @NotNull
    private static final String ERR_PREFIX = "Signing settings error:";
    @NotNull
    private static final String ERR_WRONG_OS = "Signing settings error: macOS was expected, actual OS is " + (Object)((Object)OsUtilsKt.getCurrentOS());
    @NotNull
    private static final String ERR_UNKNOWN_PREFIX = StringsKt.trimMargin$default((String)"|Signing settings error: Could not infer signing prefix. To specify:\n       |  * Set bundleID to reverse DNS notation (e.g. \"com.mycompany.myapp\");\n       |  * Use 'compose.desktop.mac.signing.prefix' Gradle property;\n       |  * Use 'nativeExecutables.macOS.signing.prefix' DSL property;\n    ", null, (int)1, null);
    @NotNull
    private static final String ERR_UNKNOWN_SIGN_ID = StringsKt.trimMargin$default((String)"|Signing settings error: signing identity is null or empty. To specify:\n       |  * Use 'compose.desktop.mac.signing.identity' Gradle property;\n       |  * Use 'nativeExecutables.macOS.signing.identity' DSL property;\n    ", null, (int)1, null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ValidatedMacOSSigningSettings validate(@NotNull MacOSSigningSettings $this$validate, @NotNull Provider<String> bundleIDProvider, @NotNull Project project, @NotNull Provider<Boolean> appStoreProvider) {
        File file2;
        Object it;
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        Intrinsics.checkNotNullParameter(bundleIDProvider, (String)"bundleIDProvider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(appStoreProvider, (String)"appStoreProvider");
        if (!(OsUtilsKt.getCurrentOS() == OS.MacOS)) {
            boolean $i$a$-check-ValidatedMacOSSigningSettingsKt$validate$22 = false;
            String $i$a$-check-ValidatedMacOSSigningSettingsKt$validate$22 = ERR_WRONG_OS;
            throw new IllegalStateException($i$a$-check-ValidatedMacOSSigningSettingsKt$validate$22.toString());
        }
        String bundleID = ValidateBundleIDKt.validateBundleID(bundleIDProvider);
        Object object = (Object[])$this$validate.getPrefix().getOrNull();
        if (object == null) {
            Object[] objectArray;
            it = objectArray = StringsKt.substringBeforeLast$default((String)bundleID, (String)".", null, (int)2, null) + '.';
            boolean bl = false;
            object = StringsKt.contains$default((CharSequence)bundleID, (char)'.', (boolean)false, (int)2, null) ? objectArray : null;
            if (object == null) {
                throw new IllegalStateException(ERR_UNKNOWN_PREFIX.toString());
            }
        }
        Object[] signPrefix = object;
        String string = (String)$this$validate.getIdentity().getOrNull();
        if (string == null) {
            throw new IllegalStateException(ERR_UNKNOWN_SIGN_ID.toString());
        }
        String signIdentity = string;
        String keychainPath = (String)$this$validate.getKeychain().getOrNull();
        if (keychainPath != null) {
            Object v2;
            block8: {
                void $this$firstOrNull$iv;
                it = new File[]{project.file((Object)keychainPath), project.getRootProject().file((Object)keychainPath)};
                it = CollectionsKt.listOf((Object[])it);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it2 = (File)element$iv;
                    boolean bl = false;
                    if (!it2.exists()) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            File keychainFile = v2;
            if (!(keychainFile != null)) {
                boolean bl = false;
                String string2 = "Signing settings error: could not find the specified keychain: " + keychainPath;
                throw new IllegalStateException(string2.toString());
            }
            file2 = keychainFile;
        } else {
            file2 = null;
        }
        File keychainFile = file2;
        boolean appStore = Intrinsics.areEqual((Object)appStoreProvider.getOrNull(), (Object)true);
        return new ValidatedMacOSSigningSettings(bundleID, signIdentity, keychainFile, (String)signPrefix, appStore);
    }
}

