/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.TargetFormat;
import org.jetbrains.compose.desktop.application.internal.JvmApplicationContext;
import org.jetbrains.compose.desktop.application.internal.OS;
import org.jetbrains.compose.desktop.application.internal.PackageVersionsKt;
import org.jetbrains.compose.desktop.application.internal.validation.DebVersionChecker;
import org.jetbrains.compose.desktop.application.internal.validation.ErrorsCollector;
import org.jetbrains.compose.desktop.application.internal.validation.MacVersionChecker;
import org.jetbrains.compose.desktop.application.internal.validation.RpmVersionChecker;
import org.jetbrains.compose.desktop.application.internal.validation.VersionChecker;
import org.jetbrains.compose.desktop.application.internal.validation.WindowsVersionChecker;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"dslPropertiesFor", "", "", "targetFormat", "Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;", "validatePackageVersions", "", "Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationContext;", "compose"})
public final class ValidatePackageVersionsKt {
    public static final void validatePackageVersions(@NotNull JvmApplicationContext $this$validatePackageVersions) {
        Intrinsics.checkNotNullParameter((Object)$this$validatePackageVersions, (String)"<this>");
        ErrorsCollector errors = new ErrorsCollector();
        for (TargetFormat targetFormat : $this$validatePackageVersions.getApp().getNativeDistributions().getTargetFormats()) {
            VersionChecker versionChecker;
            VersionChecker versionChecker2;
            switch (WhenMappings.$EnumSwitchMapping$0[targetFormat.ordinal()]) {
                case 1: {
                    versionChecker2 = null;
                    break;
                }
                case 2: {
                    versionChecker2 = DebVersionChecker.INSTANCE;
                    break;
                }
                case 3: {
                    versionChecker2 = RpmVersionChecker.INSTANCE;
                    break;
                }
                case 4: 
                case 5: {
                    versionChecker2 = WindowsVersionChecker.INSTANCE;
                    break;
                }
                case 6: 
                case 7: {
                    versionChecker2 = MacVersionChecker.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            VersionChecker versionChecker3 = versionChecker2;
            String packageVersion = (String)PackageVersionsKt.packageVersionFor($this$validatePackageVersions, targetFormat).getOrNull();
            if (packageVersion == null) {
                ErrorsCollector.addError$default(errors, targetFormat, "no version was specified", null, 4, null);
            } else if (versionChecker3 != null) {
                VersionChecker versionChecker4;
                VersionChecker $this$validatePackageVersions_u24lambda_u240 = versionChecker4;
                boolean bl = false;
                if (!$this$validatePackageVersions_u24lambda_u240.isValid(packageVersion)) {
                    errors.addError(targetFormat, '\'' + packageVersion + "' is not a valid version", $this$validatePackageVersions_u24lambda_u240.getCorrectFormat());
                }
            }
            if (targetFormat.getTargetOS$compose() != OS.MacOS) continue;
            String packageBuildVersion = (String)PackageVersionsKt.packageBuildVersionFor($this$validatePackageVersions, targetFormat).getOrNull();
            if (packageBuildVersion == null) {
                ErrorsCollector.addError$default(errors, targetFormat, "no build version was specified", null, 4, null);
                continue;
            }
            if (versionChecker3 == null) continue;
            VersionChecker $this$validatePackageVersions_u24lambda_u241 = versionChecker;
            boolean bl = false;
            if ($this$validatePackageVersions_u24lambda_u241.isValid(packageBuildVersion)) continue;
            errors.addError(targetFormat, '\'' + packageBuildVersion + "' is not a valid build version", $this$validatePackageVersions_u24lambda_u241.getCorrectFormat());
        }
        if (!((Collection)errors.getErrors()).isEmpty()) {
            throw new GradleException(CollectionsKt.joinToString$default((Iterable)errors.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
    }

    private static final List<String> dslPropertiesFor(TargetFormat targetFormat) {
        String string;
        String string2;
        String nativeDistributions = "nativeDistributions";
        String linux = nativeDistributions + ".linux";
        String macOS = nativeDistributions + ".macOS";
        String windows = nativeDistributions + ".windows";
        String packageVersion = "packageVersion";
        switch (WhenMappings.$EnumSwitchMapping$0[targetFormat.ordinal()]) {
            case 1: {
                string2 = null;
                break;
            }
            case 2: {
                string2 = linux + ".debPackageVersion";
                break;
            }
            case 3: {
                string2 = linux + ".rpmPackageVersion";
                break;
            }
            case 6: {
                string2 = macOS + ".dmgPackageVersion";
                break;
            }
            case 7: {
                string2 = macOS + ".pkgPackageVersion";
                break;
            }
            case 5: {
                string2 = windows + ".exePackageVersion";
                break;
            }
            case 4: {
                string2 = windows + ".msiPackageVersion";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String formatSpecificProperty = string2;
        switch (WhenMappings.$EnumSwitchMapping$1[targetFormat.getTargetOS$compose().ordinal()]) {
            case 1: {
                string = linux + '.' + packageVersion;
                break;
            }
            case 2: {
                string = macOS + '.' + packageVersion;
                break;
            }
            case 3: {
                string = windows + '.' + packageVersion;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String osSettingsProperty = string;
        String appSpecificProperty = nativeDistributions + '.' + packageVersion;
        Object[] objectArray = new String[]{formatSpecificProperty, osSettingsProperty, appSpecificProperty};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    public static final /* synthetic */ List access$dslPropertiesFor(TargetFormat targetFormat) {
        return ValidatePackageVersionsKt.dslPropertiesFor(targetFormat);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TargetFormat.values().length];
            try {
                nArray[TargetFormat.AppImage.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetFormat.Deb.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetFormat.Rpm.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetFormat.Msi.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetFormat.Exe.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetFormat.Dmg.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetFormat.Pkg.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OS.values().length];
            try {
                nArray[OS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MacOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

