/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.dsl.TargetFormat;
import org.jetbrains.compose.desktop.application.internal.OS;
import org.jetbrains.compose.desktop.application.internal.OsUtilsKt;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u001ai\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022K\u0010\u0013\u001aG\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00050\u0014H\u0080\b\u00f8\u0001\u0000\u001a\f\u0010\u001a\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0002H\u0000\u001a\u0014\u0010\u001d\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u001f\u001a\u00020\u0005*\u00020 2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002\u001a\f\u0010!\u001a\u00020\u001c*\u00020\u0002H\u0000\u001a\u0014\u0010\"\u001a\n #*\u0004\u0018\u00010\u001c0\u001c*\u00020\u0002H\u0000\u001a&\u0010$\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010%\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050&H\u0080\b\u00f8\u0001\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"isJarFile", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "copyZipEntry", "", "entry", "Ljava/util/zip/ZipEntry;", "from", "Ljava/io/InputStream;", "to", "Ljava/util/zip/ZipOutputStream;", "findOutputFileOrDir", "dir", "targetFormat", "Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;", "transformJar", "sourceJar", "targetJar", "fn", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Ljava/util/zip/ZipInputStream;", "zin", "zout", "checkExistingFile", "contentHash", "", "copyTo", "file", "digestContent", "Ljava/security/MessageDigest;", "mangledName", "normalizedPath", "kotlin.jvm.PlatformType", "withNewEntry", "zipEntry", "Lkotlin/Function0;", "compose"})
public final class FileUtilsKt {
    @NotNull
    public static final String mangledName(@NotNull File $this$mangledName) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$mangledName, (String)"<this>");
        StringBuilder $this$mangledName_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$mangledName_u24lambda_u240.append(FilesKt.getNameWithoutExtension((File)$this$mangledName));
        $this$mangledName_u24lambda_u240.append("-");
        $this$mangledName_u24lambda_u240.append(FileUtilsKt.contentHash($this$mangledName));
        String ext = FilesKt.getExtension((File)$this$mangledName);
        if (!StringsKt.isBlank((CharSequence)ext)) {
            $this$mangledName_u24lambda_u240.append('.' + ext);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String contentHash(@NotNull File $this$contentHash) {
        Intrinsics.checkNotNullParameter((Object)$this$contentHash, (String)"<this>");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        if ($this$contentHash.isDirectory()) {
            Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)$this$contentHash, null, (int)1, null)), (Function1)contentHash.1.INSTANCE);
            boolean $i$f$sortedBy = false;
            Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator($this$contentHash){
                final /* synthetic */ File $this_contentHash$inlined;
                {
                    this.$this_contentHash$inlined = file2;
                }

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)FilesKt.relativeTo((File)it, (File)this.$this_contentHash$inlined).getPath());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)FilesKt.relativeTo((File)it, (File)this.$this_contentHash$inlined).getPath())));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)md5, (String)"md5");
                FileUtilsKt.digestContent(md5, it);
            }
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)md5, (String)"md5");
            FileUtilsKt.digestContent(md5, $this$contentHash);
        }
        byte[] digest = md5.digest();
        int n = digest.length * 2;
        StringBuilder stringBuilder = new StringBuilder(n);
        StringBuilder $this$contentHash_u24lambda_u243 = stringBuilder;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
        for (byte by : digest) {
            $this$contentHash_u24lambda_u243.append(Integer.toHexString(0xFF & by));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void digestContent(MessageDigest $this$digestContent, File file2) {
        Closeable closeable = new FileInputStream(file2);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream fis = (BufferedInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DigestInputStream(fis, $this$digestContent);
            Throwable throwable2 = null;
            try {
                DigestInputStream ds = (DigestInputStream)closeable2;
                boolean bl2 = false;
                while (ds.read() != -1) {
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transformJar(@NotNull File sourceJar, @NotNull File targetJar, @NotNull Function3<? super ZipEntry, ? super ZipInputStream, ? super ZipOutputStream, Unit> fn) {
        Intrinsics.checkNotNullParameter((Object)sourceJar, (String)"sourceJar");
        Intrinsics.checkNotNullParameter((Object)targetJar, (String)"targetJar");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        boolean $i$f$transformJar = false;
        Closeable closeable = new FileInputStream(sourceJar);
        int n = 8192;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ZipInputStream zin = (ZipInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(targetJar);
            int n2 = 8192;
            closeable2 = new ZipOutputStream(closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2));
            Throwable throwable2 = null;
            try {
                ZipOutputStream zout = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                for (ZipEntry sourceEntry : SequencesKt.generateSequence((Function0)((Function0)new Function0<ZipEntry>(zin){
                    final /* synthetic */ ZipInputStream $zin;
                    {
                        this.$zin = $zin;
                        super(0);
                    }

                    @Nullable
                    public final ZipEntry invoke() {
                        return this.$zin.getNextEntry();
                    }
                }))) {
                    fn.invoke((Object)sourceEntry, (Object)zin, (Object)zout);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                InlineMarker.finallyEnd((int)1);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
    }

    public static final void copyZipEntry(@NotNull ZipEntry entry, @NotNull InputStream from, @NotNull ZipOutputStream to) {
        ZipEntry zipEntry;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        ZipEntry $this$copyZipEntry_u24lambda_u248 = zipEntry = new ZipEntry(entry.getName());
        boolean bl = false;
        $this$copyZipEntry_u24lambda_u248.setComment(entry.getComment());
        $this$copyZipEntry_u24lambda_u248.setExtra(entry.getExtra());
        ZipEntry newEntry = zipEntry;
        ZipOutputStream $this$withNewEntry$iv = to;
        boolean $i$f$withNewEntry = false;
        $this$withNewEntry$iv.putNextEntry(newEntry);
        boolean bl2 = false;
        ByteStreamsKt.copyTo$default((InputStream)from, (OutputStream)to, (int)0, (int)2, null);
        $this$withNewEntry$iv.closeEntry();
    }

    public static final void withNewEntry(@NotNull ZipOutputStream $this$withNewEntry, @NotNull ZipEntry zipEntry, @NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter((Object)$this$withNewEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zipEntry, (String)"zipEntry");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        boolean $i$f$withNewEntry = false;
        $this$withNewEntry.putNextEntry(zipEntry);
        fn.invoke();
        $this$withNewEntry.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyTo(@NotNull InputStream $this$copyTo, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Closeable closeable = new FileOutputStream(file2);
        int n = 8192;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream os = (BufferedOutputStream)closeable;
            boolean bl = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)$this$copyTo, (OutputStream)os, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Internal
    @NotNull
    public static final File findOutputFileOrDir(@NotNull File dir2, @NotNull TargetFormat targetFormat) {
        Object element$iv;
        boolean bl;
        File file2;
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)targetFormat), (String)"targetFormat");
        if (WhenMappings.$EnumSwitchMapping$0[targetFormat.ordinal()] == 1) {
            file2 = dir2;
            return file2;
        }
        Sequence $this$first$iv = (Sequence)FilesKt.walk$default((File)dir2, null, (int)1, null);
        boolean $i$f$first = false;
        Iterator iterator2 = $this$first$iv.iterator();
        do {
            if (!iterator2.hasNext()) throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            element$iv = iterator2.next();
            File it = (File)element$iv;
            boolean bl2 = false;
            if (it.isFile()) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (StringsKt.endsWith$default((String)string, (String)targetFormat.getFileExt(), (boolean)false, (int)2, null)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        file2 = (File)element$iv;
        return file2;
    }

    @NotNull
    public static final File checkExistingFile(@NotNull File $this$checkExistingFile) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$checkExistingFile, (String)"<this>");
        File $this$checkExistingFile_u24lambda_u2413 = file2 = $this$checkExistingFile;
        boolean bl = false;
        if (!$this$checkExistingFile_u24lambda_u2413.isFile()) {
            boolean bl2 = false;
            String string = '\'' + $this$checkExistingFile_u24lambda_u2413.getAbsolutePath() + "' does not exist";
            throw new IllegalStateException(string.toString());
        }
        return file2;
    }

    public static final boolean isJarFile(@NotNull File $this$isJarFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJarFile, (String)"<this>");
        String string = $this$isJarFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return StringsKt.endsWith((String)string, (String)".jar", (boolean)true) && $this$isJarFile.isFile();
    }

    public static final String normalizedPath(@NotNull File $this$normalizedPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$normalizedPath, (String)"<this>");
        if (OsUtilsKt.getCurrentOS() == OS.Windows) {
            String string2 = $this$normalizedPath.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"absolutePath");
            string = StringsKt.replace$default((String)string2, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
        } else {
            string = $this$normalizedPath.getAbsolutePath();
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetFormat.values().length];
            try {
                nArray[TargetFormat.AppImage.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

