/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.internal.DefaultHttpClientFactory;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpHost;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.impl.client.CloseableHttpClient;

public class CachingHttpClientFactory
extends DefaultHttpClientFactory {
    private Map<CacheKey, CloseableHttpClient> cachedClients = new HashMap<CacheKey, CloseableHttpClient>();

    @Override
    public CloseableHttpClient createHttpClient(HttpHost httpHost, boolean acceptAnyCertificate, int retries) {
        CacheKey key = new CacheKey(httpHost, acceptAnyCertificate, retries);
        CloseableHttpClient c = this.cachedClients.get(key);
        if (c == null) {
            c = super.createHttpClient(httpHost, acceptAnyCertificate, retries);
            this.cachedClients.put(key, c);
        }
        return c;
    }

    public void close() throws IOException {
        for (CloseableHttpClient c : this.cachedClients.values()) {
            c.close();
        }
        this.cachedClients.clear();
    }

    private static class CacheKey {
        private final HttpHost httpHost;
        private final boolean acceptAnyCertificate;
        private final int retries;

        CacheKey(HttpHost httpHost, boolean acceptAnyCertificate, int retries) {
            this.httpHost = httpHost;
            this.acceptAnyCertificate = acceptAnyCertificate;
            this.retries = retries;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.acceptAnyCertificate == cacheKey.acceptAnyCertificate && this.retries == cacheKey.retries && this.httpHost.equals(cacheKey.httpHost);
        }

        public int hashCode() {
            return Objects.hash(this.httpHost, this.acceptAnyCertificate, this.retries);
        }
    }
}

