/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.DownloadAction;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.DownloadSpec;

public class Download
extends DefaultTask
implements DownloadSpec {
    private final DownloadAction action;

    public Download() {
        final boolean isOffline = this.getProject().getGradle().getStartParameter().isOffline();
        this.action = new DownloadAction(this.getProject(), (Task)this);
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return !Download.this.isOnlyIfModified() && !Download.this.isOverwrite();
            }
        });
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                if (isOffline) {
                    for (File f : Download.this.getOutputFiles()) {
                        if (f.exists()) {
                            if (Download.this.isQuiet()) continue;
                            Download.this.getProject().getLogger().info("Skipping existing file '" + f.getName() + "' in offline mode.");
                            continue;
                        }
                        throw new IllegalStateException("Unable to download file '" + f.getName() + "' in offline mode.");
                    }
                    return false;
                }
                return true;
            }
        });
    }

    @TaskAction
    public void download() throws IOException {
        this.action.execute();
        try {
            if (this.action.isUpToDate()) {
                Method getState = this.getClass().getMethod("getState", new Class[0]);
                Object state = getState.invoke((Object)this, new Object[0]);
                try {
                    Method upToDate = state.getClass().getMethod("upToDate", new Class[0]);
                    upToDate.invoke(state, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    Method setDidWork = state.getClass().getMethod("setDidWork", Boolean.TYPE);
                    setDidWork.invoke(state, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OutputFiles
    public List<File> getOutputFiles() {
        return this.action.getOutputFiles();
    }

    @Override
    public void src(Object src) {
        this.action.src(src);
    }

    @Override
    public void dest(Object dest) {
        this.action.dest(dest);
    }

    @Override
    public void quiet(boolean quiet) {
        this.action.quiet(quiet);
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.action.overwrite(overwrite);
    }

    @Override
    public void onlyIfModified(boolean onlyIfModified) {
        this.action.onlyIfModified(onlyIfModified);
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.action.onlyIfNewer(onlyIfNewer);
    }

    @Override
    public void compress(boolean compress) {
        this.action.compress(compress);
    }

    @Override
    public void username(String username) {
        this.action.username(username);
    }

    @Override
    public void password(String password) {
        this.action.password(password);
    }

    @Override
    public void authScheme(String authScheme) {
        this.action.authScheme(authScheme);
    }

    @Override
    public void headers(Map<String, String> headers) {
        this.action.headers(headers);
    }

    @Override
    public void header(String name, String value) {
        this.action.header(name, value);
    }

    @Override
    public void acceptAnyCertificate(boolean accept) {
        this.action.acceptAnyCertificate(accept);
    }

    @Override
    public void connectTimeout(int milliseconds) {
        this.action.connectTimeout(milliseconds);
    }

    @Override
    public void readTimeout(int milliseconds) {
        this.action.readTimeout(milliseconds);
    }

    @Override
    public void retries(int retries) {
        this.action.retries(retries);
    }

    @Override
    public void downloadTaskDir(Object dir2) {
        this.action.downloadTaskDir(dir2);
    }

    @Override
    public void tempAndMove(boolean tempAndMove) {
        this.action.tempAndMove(tempAndMove);
    }

    @Override
    public void useETag(Object useETag) {
        this.action.useETag(useETag);
    }

    @Override
    public void cachedETagsFile(Object location) {
        this.action.cachedETagsFile(location);
    }

    @Override
    @Input
    public Object getSrc() {
        return this.action.getSrc();
    }

    @Override
    @Internal
    public File getDest() {
        return this.action.getDest();
    }

    @Override
    @Console
    public boolean isQuiet() {
        return this.action.isQuiet();
    }

    @Override
    @Input
    public boolean isOverwrite() {
        return this.action.isOverwrite();
    }

    @Override
    @Input
    public boolean isOnlyIfModified() {
        return this.action.isOnlyIfModified();
    }

    @Override
    @Input
    public boolean isOnlyIfNewer() {
        return this.action.isOnlyIfNewer();
    }

    @Override
    @Input
    public boolean isCompress() {
        return this.action.isCompress();
    }

    @Override
    @Input
    @Optional
    public String getUsername() {
        return this.action.getUsername();
    }

    @Override
    @Input
    @Optional
    public String getPassword() {
        return this.action.getPassword();
    }

    @Override
    @Input
    @Optional
    public String getAuthScheme() {
        return this.action.getAuthScheme();
    }

    @Override
    @Input
    @Optional
    public Map<String, String> getHeaders() {
        return this.action.getHeaders();
    }

    @Override
    public String getHeader(String name) {
        return this.action.getHeader(name);
    }

    @Override
    @Input
    public boolean isAcceptAnyCertificate() {
        return this.action.isAcceptAnyCertificate();
    }

    @Override
    @Input
    public int getConnectTimeout() {
        return this.action.getConnectTimeout();
    }

    @Override
    @Input
    public int getReadTimeout() {
        return this.action.getReadTimeout();
    }

    @Override
    @Input
    public int getRetries() {
        return this.action.getRetries();
    }

    @Override
    @Internal
    public File getDownloadTaskDir() {
        return this.action.getDownloadTaskDir();
    }

    @Override
    @Input
    public boolean isTempAndMove() {
        return this.action.isTempAndMove();
    }

    @Override
    @Input
    @Optional
    public Object getUseETag() {
        return this.action.getUseETag();
    }

    @Override
    @Internal
    public File getCachedETagsFile() {
        return this.action.getCachedETagsFile();
    }
}

