/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.ComposeCompilerCompatability;
import org.jetbrains.compose.ComposeCompilerVersion;
import org.jetbrains.compose.internal.ComposeCompilerArtifactProviderKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.SubpluginArtifact;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/compose/internal/ComposeCompilerArtifactProvider;", "", "kotlinVersion", "", "customPluginString", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "compilerArtifact", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginArtifact;", "getCompilerArtifact", "()Lorg/jetbrains/kotlin/gradle/plugin/SubpluginArtifact;", "compilerHostedArtifact", "getCompilerHostedArtifact", "unsupportedPlatforms", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPlatformType;", "checkTargetSupported", "", "target", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "DefaultCompiler", "compose"})
public final class ComposeCompilerArtifactProvider {
    @NotNull
    private final String kotlinVersion;
    @NotNull
    private Set<? extends KotlinPlatformType> unsupportedPlatforms;
    @NotNull
    private final SubpluginArtifact compilerArtifact;

    public ComposeCompilerArtifactProvider(@NotNull String kotlinVersion, @NotNull Function0<String> customPluginString) {
        String[] customCoordinates;
        String[] stringArray;
        Object object;
        String customPlugin;
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        Intrinsics.checkNotNullParameter(customPluginString, (String)"customPluginString");
        this.kotlinVersion = kotlinVersion;
        this.unsupportedPlatforms = SetsKt.emptySet();
        String string = customPlugin = (String)customPluginString.invoke();
        if (string == null) {
            object = null;
        } else {
            stringArray = new String[]{":"};
            object = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        stringArray = customCoordinates = object;
        String string2 = string = stringArray == null ? null : Integer.valueOf(stringArray.size());
        if (string == null) {
            ComposeCompilerVersion composeCompilerVersion = ComposeCompilerCompatability.INSTANCE.compilerVersionFor(this.kotlinVersion);
            boolean bl = false;
            boolean bl2 = false;
            if (composeCompilerVersion == null) {
                boolean bl3 = false;
                String string3 = "This version of Compose Multiplatform doesn't support Kotlin " + this.kotlinVersion + ". Please see https://github.com/JetBrains/compose-jb/blob/master/VERSIONING.md#kotlin-compatibility to know the latest supported version of Kotlin.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            ComposeCompilerVersion version = composeCompilerVersion;
            this.compilerArtifact = DefaultCompiler.pluginArtifact$default(DefaultCompiler.INSTANCE, version.getVersion(), null, null, 6, null);
            this.unsupportedPlatforms = version.getUnsupportedPlatforms();
        } else {
            int version = 1;
            if ((Integer)((Object)string) == version) {
                String customVersion = (String)customCoordinates.get(0);
                CharSequence charSequence = customVersion;
                boolean bl = false;
                boolean bl4 = !StringsKt.isBlank((CharSequence)charSequence);
                bl = false;
                boolean bl5 = false;
                if (!bl4) {
                    boolean bl6 = false;
                    String string4 = "'compose.kotlinCompilerPlugin' cannot be blank!";
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
                this.compilerArtifact = DefaultCompiler.pluginArtifact$default(DefaultCompiler.INSTANCE, customVersion, null, null, 6, null);
            } else {
                int n = 3;
                if ((Integer)((Object)string) == n) {
                    this.compilerArtifact = DefaultCompiler.INSTANCE.pluginArtifact((String)customCoordinates.get(2), (String)customCoordinates.get(0), (String)customCoordinates.get(1));
                } else {
                    String string5 = StringsKt.trimIndent((String)("\n                        Illegal format of 'compose.kotlinCompilerPlugin' property.\n                        Expected format: either '<VERSION>' or '<GROUP_ID>:<ARTIFACT_ID>:<VERSION>'\n                        Actual value: '" + customPlugin + "'\n                "));
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string5.toString());
                }
            }
        }
    }

    public final void checkTargetSupported(@NotNull KotlinTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean bl = !this.unsupportedPlatforms.contains(target.getPlatformType());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "This version of Compose Multiplatform doesn't support Kotlin " + this.kotlinVersion + " for " + target.getPlatformType() + " target. Please see https://github.com/JetBrains/compose-jb/blob/master/VERSIONING.md#kotlin-compatibility to know the latest supported version of Kotlin.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final SubpluginArtifact getCompilerArtifact() {
        return this.compilerArtifact;
    }

    @NotNull
    public final SubpluginArtifact getCompilerHostedArtifact() {
        SubpluginArtifact subpluginArtifact = this.compilerArtifact;
        boolean bl = false;
        boolean bl2 = false;
        SubpluginArtifact $this$_get_compilerHostedArtifact__u24lambda_u2d3 = subpluginArtifact;
        boolean bl3 = false;
        String newArtifactId = Intrinsics.areEqual((Object)$this$_get_compilerHostedArtifact__u24lambda_u2d3.getGroupId(), (Object)"org.jetbrains.compose.compiler") && Intrinsics.areEqual((Object)$this$_get_compilerHostedArtifact__u24lambda_u2d3.getArtifactId(), (Object)"compiler") ? "compiler-hosted" : $this$_get_compilerHostedArtifact__u24lambda_u2d3.getArtifactId();
        return ComposeCompilerArtifactProviderKt.copy$default($this$_get_compilerHostedArtifact__u24lambda_u2d3, null, newArtifactId, null, 5, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/compose/internal/ComposeCompilerArtifactProvider$DefaultCompiler;", "", "()V", "ARTIFACT_ID", "", "GROUP_ID", "HOSTED_ARTIFACT_ID", "pluginArtifact", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginArtifact;", "version", "groupId", "artifactId", "compose"})
    public static final class DefaultCompiler {
        @NotNull
        public static final DefaultCompiler INSTANCE = new DefaultCompiler();
        @NotNull
        public static final String GROUP_ID = "org.jetbrains.compose.compiler";
        @NotNull
        public static final String ARTIFACT_ID = "compiler";
        @NotNull
        public static final String HOSTED_ARTIFACT_ID = "compiler-hosted";

        private DefaultCompiler() {
        }

        @NotNull
        public final SubpluginArtifact pluginArtifact(@NotNull String version, @NotNull String groupId, @NotNull String artifactId) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            return new SubpluginArtifact(groupId, artifactId, version);
        }

        public static /* synthetic */ SubpluginArtifact pluginArtifact$default(DefaultCompiler defaultCompiler, String string, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = GROUP_ID;
            }
            if ((n & 4) != 0) {
                string3 = ARTIFACT_ID;
            }
            return defaultCompiler.pluginArtifact(string, string2, string3);
        }
    }
}

