/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.experimental.web.tasks;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u00020\b8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/compose/experimental/web/tasks/ExperimentalUnpackSkikoWasmRuntimeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "runtimeClasspath", "Lorg/gradle/api/artifacts/Configuration;", "getRuntimeClasspath", "()Lorg/gradle/api/artifacts/Configuration;", "setRuntimeClasspath", "(Lorg/gradle/api/artifacts/Configuration;)V", "run", "", "unpackSkikoRuntime", "skikoVersion", "", "compose"})
public abstract class ExperimentalUnpackSkikoWasmRuntimeTask
extends DefaultTask {
    public Configuration runtimeClasspath;

    @InputFiles
    @NotNull
    public final Configuration getRuntimeClasspath() {
        Configuration configuration = this.runtimeClasspath;
        if (configuration != null) {
            return configuration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeClasspath");
        return null;
    }

    public final void setRuntimeClasspath(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"<set-?>");
        this.runtimeClasspath = configuration;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public final void run() {
        Object[] objectArray = new Object[]{this.getOutputDir()};
        this.getProject().delete(objectArray);
        this.getProject().mkdir((Object)this.getOutputDir());
        Set runtimeArtifacts = this.getRuntimeClasspath().getResolvedConfiguration().getResolvedArtifacts();
        for (ResolvedArtifact artifact : runtimeArtifacts) {
            ComponentIdentifier id;
            String string;
            Logger logger;
            Logger logger2 = this.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
            Logger $this$debug$iv = logger2;
            boolean $i$f$debug22 = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                boolean bl = false;
                string = "Checking artifact: id=" + artifact.getId() + ", file=" + artifact.getFile();
                logger.debug(string);
            }
            if (!((id = artifact.getId().getComponentIdentifier()) instanceof ModuleComponentIdentifier) || !Intrinsics.areEqual((Object)((ModuleComponentIdentifier)id).getGroup(), (Object)"org.jetbrains.skiko")) continue;
            Logger $i$f$debug22 = this.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$debug22, (String)"logger");
            Logger $this$debug$iv2 = $i$f$debug22;
            boolean $i$f$debug = false;
            if ($this$debug$iv2.isDebugEnabled()) {
                logger = $this$debug$iv2;
                boolean bl = false;
                string = Intrinsics.stringPlus((String)"Found skiko artifact: ", (Object)artifact);
                logger.debug(string);
            }
            String string2 = ((ModuleComponentIdentifier)id).getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id.version");
            this.unpackSkikoRuntime(string2);
        }
    }

    private final void unpackSkikoRuntime(String skikoVersion) {
        Dependency[] dependencyArray = new Dependency[]{this.getProject().getDependencies().create((Object)Intrinsics.stringPlus((String)"org.jetbrains.skiko:skiko-js-wasm-runtime:", (Object)skikoVersion))};
        Configuration skikoRuntimeConfig = this.getProject().getConfigurations().detachedConfiguration(dependencyArray);
        for (File file : skikoRuntimeConfig.resolve()) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!StringsKt.endsWith((String)string, (String)".jar", (boolean)true)) continue;
            this.getProject().copy(arg_0 -> ExperimentalUnpackSkikoWasmRuntimeTask.unpackSkikoRuntime$lambda-2(this, file, arg_0));
        }
    }

    private static final void unpackSkikoRuntime$lambda-2(ExperimentalUnpackSkikoWasmRuntimeTask this$0, File $file, CopySpec copySpec) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object[] objectArray = new Object[]{this$0.getProject().zipTree((Object)$file)};
        copySpec.from(objectArray);
        copySpec.into((Object)this$0.getOutputDir());
    }
}

