/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.experimental.uikit.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.experimental.uikit.tasks.ExperimentalPackComposeApplicationForXCodeTask;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00108aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/compose/experimental/uikit/tasks/ExperimentalPackComposeApplicationForXCodeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "buildType", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "getBuildType$compose", "()Lorg/gradle/api/provider/Property;", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir$compose", "()Lorg/gradle/api/file/DirectoryProperty;", "executablePath", "", "getExecutablePath$compose", "kotlinBinary", "Lorg/gradle/api/file/RegularFileProperty;", "getKotlinBinary$compose", "()Lorg/gradle/api/file/RegularFileProperty;", "targetType", "Lorg/jetbrains/compose/experimental/uikit/tasks/ExperimentalPackComposeApplicationForXCodeTask$UikitTarget;", "getTargetType$compose", "run", "", "UikitTarget", "compose"})
public abstract class ExperimentalPackComposeApplicationForXCodeTask
extends DefaultTask {
    @Input
    @NotNull
    public abstract Property<UikitTarget> getTargetType$compose();

    @Input
    @NotNull
    public abstract Property<NativeBuildType> getBuildType$compose();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getKotlinBinary$compose();

    @Input
    @NotNull
    public abstract Property<String> getExecutablePath$compose();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getDestinationDir$compose();

    @TaskAction
    public final void run() {
        File destinationDir = ((Directory)this.getDestinationDir$compose().get()).getAsFile();
        Object[] objectArray = new Object[]{destinationDir};
        this.getProject().delete(objectArray);
        this.getProject().mkdir((Object)destinationDir);
        File executableSource = ((RegularFile)this.getKotlinBinary$compose().get()).getAsFile();
        File dsymSource = new File(Intrinsics.stringPlus((String)executableSource.getAbsolutePath(), (Object)".dSYM"));
        Intrinsics.checkNotNullExpressionValue((Object)destinationDir, (String)"destinationDir");
        Object object = this.getExecutablePath$compose().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executablePath.get()");
        File executableDestination = FilesKt.resolve((File)destinationDir, (String)((String)object));
        File dsymDestination = new File(Intrinsics.stringPlus((String)executableDestination.getParentFile().getAbsolutePath(), (Object)".dSYM"));
        for (File sourceFile : SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)dsymSource, null, (int)1, null)), (Function1)run.1.INSTANCE)) {
            File relativePath = FilesKt.relativeTo((File)sourceFile, (File)dsymSource);
            File destFile = FilesKt.resolve((File)dsymDestination, (File)relativePath);
            destFile.getParentFile().mkdirs();
            if (Intrinsics.areEqual((Object)sourceFile.getName(), (Object)executableSource.getName())) {
                String string = executableDestination.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executableDestination.name");
                FilesKt.copyTo$default((File)sourceFile, (File)FilesKt.resolveSibling((File)destFile, (String)string), (boolean)false, (int)0, (int)6, null);
                continue;
            }
            FilesKt.copyTo$default((File)sourceFile, (File)destFile, (boolean)false, (int)0, (int)6, null);
        }
        executableDestination.getParentFile().mkdirs();
        Intrinsics.checkNotNullExpressionValue((Object)executableSource, (String)"executableSource");
        FilesKt.copyTo$default((File)executableSource, (File)executableDestination, (boolean)false, (int)0, (int)6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/compose/experimental/uikit/tasks/ExperimentalPackComposeApplicationForXCodeTask$UikitTarget;", "", "simulator", "", "targetName", "", "(Ljava/lang/String;IZLjava/lang/String;)V", "getSimulator", "()Z", "getTargetName", "()Ljava/lang/String;", "X64", "Arm64", "compose"})
    public static final class UikitTarget
    extends Enum<UikitTarget> {
        private final boolean simulator;
        @NotNull
        private final String targetName;
        public static final /* enum */ UikitTarget X64 = new UikitTarget(true, "uikitX64");
        public static final /* enum */ UikitTarget Arm64 = new UikitTarget(false, "uikitArm64");
        private static final /* synthetic */ UikitTarget[] $VALUES;

        private UikitTarget(boolean simulator, String targetName) {
            this.simulator = simulator;
            this.targetName = targetName;
        }

        public final boolean getSimulator() {
            return this.simulator;
        }

        @NotNull
        public final String getTargetName() {
            return this.targetName;
        }

        public static UikitTarget[] values() {
            return (UikitTarget[])$VALUES.clone();
        }

        public static UikitTarget valueOf(String value) {
            return Enum.valueOf(UikitTarget.class, value);
        }

        static {
            $VALUES = uikitTargetArray = new UikitTarget[]{UikitTarget.X64, UikitTarget.Arm64};
        }
    }
}

