/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.tasks;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.GradleUtilsKt;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\r2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0004H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "destinationDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getDestinationDir", "()Lorg/gradle/api/provider/Provider;", "resources", "Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask$DefaultResourcesProvider;", "getResources$compose", "()Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask$DefaultResourcesProvider;", "iconSourcePath", "", "platformName", "iconExt", "run", "", "unpack", "from", "to", "Lorg/gradle/api/file/FileSystemLocation;", "DefaultResourcesProvider", "compose"})
public abstract class AbstractUnpackDefaultComposeApplicationResourcesTask
extends AbstractComposeDesktopTask {
    @OutputDirectory
    @NotNull
    private final Provider<Directory> destinationDir;
    @NotNull
    private final DefaultResourcesProvider resources;

    public AbstractUnpackDefaultComposeApplicationResourcesTask() {
        Provider provider = this.getProject().getLayout().getBuildDirectory().dir("compose/default-resources/1.2.0");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026adlePluginVersion}\"\n    )");
        this.destinationDir = provider;
        this.resources = new DefaultResourcesProvider(this.destinationDir);
    }

    @NotNull
    public final Provider<Directory> getDestinationDir() {
        return this.destinationDir;
    }

    @Internal
    @NotNull
    public final DefaultResourcesProvider getResources$compose() {
        return this.resources;
    }

    @TaskAction
    public final void run() {
        Provider[] providerArray = new Provider[]{this.destinationDir};
        this.cleanDirs(providerArray);
        this.unpack(this.iconSourcePath("mac", "icns"), this.resources.getMacIcon());
        this.unpack(this.iconSourcePath("windows", "ico"), this.resources.getWindowsIcon());
        this.unpack(this.iconSourcePath("linux", "png"), this.resources.getLinuxIcon());
        this.unpack("default-compose-desktop-rules.pro", this.resources.getDefaultComposeProguardRules());
    }

    private final String iconSourcePath(String platformName, String iconExt) {
        return "default-compose-desktop-icon-" + platformName + '.' + iconExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unpack(String from, Provider<? extends FileSystemLocation> to) {
        File file = GradleUtilsKt.getIoFile(to);
        boolean bl = false;
        boolean bl2 = false;
        File $this$unpack_u24lambda_u2d0 = file;
        boolean bl3 = false;
        if ($this$unpack_u24lambda_u2d0.exists()) {
            $this$unpack_u24lambda_u2d0.delete();
        } else {
            $this$unpack_u24lambda_u2d0.getParentFile().mkdirs();
        }
        $this$unpack_u24lambda_u2d0.createNewFile();
        File targetIoFile = file;
        Closeable closeable = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(from);
        if (closeable == null) {
            String string = Intrinsics.stringPlus((String)"Could not find default resource: ", (Object)from);
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        InputStream iconResourceStream = closeable;
        closeable = iconResourceStream;
        bl2 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            long l;
            Closeable input = closeable;
            boolean bl6 = false;
            Object object = targetIoFile;
            int n = 0;
            object = new FileOutputStream((File)object);
            n = 8192;
            boolean bl7 = false;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            n = 0;
            bl7 = false;
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output = (BufferedOutputStream)object;
                boolean bl8 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask$DefaultResourcesProvider;", "", "resourcesRootDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "(Lorg/gradle/api/provider/Provider;)V", "defaultComposeProguardRules", "Lorg/gradle/api/file/RegularFile;", "getDefaultComposeProguardRules", "()Lorg/gradle/api/provider/Provider;", "linuxIcon", "getLinuxIcon", "macIcon", "getMacIcon", "windowsIcon", "getWindowsIcon", "compose"})
    public static final class DefaultResourcesProvider {
        @NotNull
        private final Provider<RegularFile> macIcon;
        @NotNull
        private final Provider<RegularFile> windowsIcon;
        @NotNull
        private final Provider<RegularFile> linuxIcon;
        @NotNull
        private final Provider<RegularFile> defaultComposeProguardRules;

        public DefaultResourcesProvider(@NotNull Provider<Directory> resourcesRootDir) {
            Intrinsics.checkNotNullParameter(resourcesRootDir, (String)"resourcesRootDir");
            Provider provider = resourcesRootDir.map(DefaultResourcesProvider::macIcon$lambda-0);
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"resourcesRootDir.map { i\u2026default-icon-mac.icns\") }");
            this.macIcon = provider;
            provider = resourcesRootDir.map(DefaultResourcesProvider::windowsIcon$lambda-1);
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"resourcesRootDir.map { i\u2026ault-icon-windows.ico\") }");
            this.windowsIcon = provider;
            provider = resourcesRootDir.map(DefaultResourcesProvider::linuxIcon$lambda-2);
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"resourcesRootDir.map { i\u2026efault-icon-linux.png\") }");
            this.linuxIcon = provider;
            provider = resourcesRootDir.map(DefaultResourcesProvider::defaultComposeProguardRules$lambda-3);
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"resourcesRootDir.map { i\u2026OGUARD_RULES_FILE_NAME) }");
            this.defaultComposeProguardRules = provider;
        }

        @NotNull
        public final Provider<RegularFile> getMacIcon() {
            return this.macIcon;
        }

        @NotNull
        public final Provider<RegularFile> getWindowsIcon() {
            return this.windowsIcon;
        }

        @NotNull
        public final Provider<RegularFile> getLinuxIcon() {
            return this.linuxIcon;
        }

        @NotNull
        public final Provider<RegularFile> getDefaultComposeProguardRules() {
            return this.defaultComposeProguardRules;
        }

        private static final RegularFile macIcon$lambda-0(Directory it) {
            return it.file("default-icon-mac.icns");
        }

        private static final RegularFile windowsIcon$lambda-1(Directory it) {
            return it.file("default-icon-windows.ico");
        }

        private static final RegularFile linuxIcon$lambda-2(Directory it) {
            return it.file("default-icon-linux.png");
        }

        private static final RegularFile defaultComposeProguardRules$lambda-3(Directory it) {
            return it.file("default-compose-desktop-rules.pro");
        }
    }
}

