/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.MacSigner;
import org.jetbrains.compose.desktop.application.internal.files.FileCopyingProcessor;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;
import org.jetbrains.compose.desktop.application.internal.files.MacJarSignFileCopyingProcessorKt;
import org.jetbrains.compose.desktop.application.internal.files.SimpleFileCopyingProcessor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/files/MacJarSignFileCopyingProcessor;", "Lorg/jetbrains/compose/desktop/application/internal/files/FileCopyingProcessor;", "signer", "Lorg/jetbrains/compose/desktop/application/internal/MacSigner;", "tempDir", "Ljava/io/File;", "jvmRuntimeVersion", "", "(Lorg/jetbrains/compose/desktop/application/internal/MacSigner;Ljava/io/File;I)V", "copy", "", "source", "target", "signDylibEntry", "sourceEntry", "Ljava/util/zip/ZipEntry;", "zin", "Ljava/util/zip/ZipInputStream;", "zout", "Ljava/util/zip/ZipOutputStream;", "signNativeLibsInJar", "compose"})
public final class MacJarSignFileCopyingProcessor
implements FileCopyingProcessor {
    @NotNull
    private final MacSigner signer;
    @NotNull
    private final File tempDir;
    private final int jvmRuntimeVersion;

    public MacJarSignFileCopyingProcessor(@NotNull MacSigner signer, @NotNull File tempDir, int jvmRuntimeVersion) {
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        this.signer = signer;
        this.tempDir = tempDir;
        this.jvmRuntimeVersion = jvmRuntimeVersion;
    }

    @Override
    public void copy(@NotNull File source, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (FileUtilsKt.isJarFile(source)) {
            this.signNativeLibsInJar(source, target);
        } else {
            SimpleFileCopyingProcessor.INSTANCE.copy(source, target);
            String string = source.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.name");
            if (MacJarSignFileCopyingProcessorKt.isDylibPath(string)) {
                if (this.jvmRuntimeVersion < 17) {
                    MacSigner.sign$default(this.signer, target, null, false, 6, null);
                } else if (this.jvmRuntimeVersion == 17) {
                    string = source.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.name");
                    if (StringsKt.endsWith$default((String)string, (String)".jnilib", (boolean)false, (int)2, null)) {
                        MacSigner.sign$default(this.signer, target, null, false, 6, null);
                    } else {
                        this.signer.unsign(target);
                    }
                } else {
                    string = source.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.name");
                    if (StringsKt.endsWith$default((String)string, (String)".jnilib", (boolean)false, (int)2, null)) {
                        MacSigner.sign$default(this.signer, target, null, false, 6, null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void signNativeLibsInJar(File source, File target) {
        if (target.exists()) {
            target.delete();
        }
        boolean $i$f$transformJar = false;
        Closeable closeable = new FileInputStream(source);
        int n = 8192;
        boolean bl = false;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            ZipInputStream zin$iv = (ZipInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new FileOutputStream(target);
            int n2 = 8192;
            boolean bl3 = false;
            closeable2 = new ZipOutputStream(closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2));
            n2 = 0;
            bl3 = false;
            Throwable throwable2 = null;
            try {
                ZipOutputStream zout$iv = (ZipOutputStream)closeable2;
                boolean bl4 = false;
                for (ZipEntry sourceEntry$iv : SequencesKt.generateSequence((Function0)((Function0)new Function0<ZipEntry>(zin$iv){
                    final /* synthetic */ ZipInputStream $zin;
                    {
                        this.$zin = $zin;
                        super(0);
                    }

                    @Nullable
                    public final ZipEntry invoke() {
                        return this.$zin.getNextEntry();
                    }
                }))) {
                    void zout;
                    void zin;
                    ZipOutputStream zipOutputStream = zout$iv;
                    ZipInputStream zipInputStream = zin$iv;
                    ZipEntry entry = sourceEntry$iv;
                    boolean bl5 = false;
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                    if (MacJarSignFileCopyingProcessorKt.isDylibPath(string)) {
                        this.signDylibEntry(entry, (ZipInputStream)zin, (ZipOutputStream)zout);
                        continue;
                    }
                    FileUtilsKt.copyZipEntry(entry, (InputStream)zin, (ZipOutputStream)zout);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void signDylibEntry(ZipEntry sourceEntry, ZipInputStream zin, ZipOutputStream zout) {
        Object object = sourceEntry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceEntry.name");
        File unpackedDylibFile = FilesKt.resolve((File)this.tempDir, (String)StringsKt.substringAfterLast$default((String)object, (String)"/", null, (int)2, null));
        try {
            FileUtilsKt.copyTo(zin, unpackedDylibFile);
            MacSigner.sign$default(this.signer, unpackedDylibFile, null, false, 6, null);
            object = unpackedDylibFile;
            int n = 0;
            object = new FileInputStream((File)object);
            n = 8192;
            boolean bl = false;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                BufferedInputStream it = (BufferedInputStream)object;
                boolean bl2 = false;
                FileUtilsKt.copyZipEntry(sourceEntry, it, zout);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        finally {
            unpackedDylibFile.delete();
        }
    }
}

