/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.resources.AndroidContextProviderKt;
import org.jetbrains.compose.resources.ExperimentalResourceApi;
import org.jetbrains.compose.resources.MissingResourceException;
import org.jetbrains.compose.resources.ResourceReader;

@ExperimentalResourceApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0019\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020!*\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\"\u001a\u00020\u0018*\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/jetbrains/compose/resources/DefaultAndroidResourceReader;", "Lorg/jetbrains/compose/resources/ResourceReader;", "<init>", "()V", "assets", "Landroid/content/res/AssetManager;", "getAssets", "()Landroid/content/res/AssetManager;", "assets$delegate", "Lkotlin/Lazy;", "instrumentedAssets", "getInstrumentedAssets", "read", "", "path", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readPart", "offset", "", "size", "(Ljava/lang/String;JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "skipBytes", "", "Ljava/io/InputStream;", "readBytes", "byteArray", "", "getUri", "getResourceAsStream", "getClassLoader", "Ljava/lang/ClassLoader;", "hasFile", "", "open", "library_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nResourceReader.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceReader.android.kt\norg/jetbrains/compose/resources/DefaultAndroidResourceReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class DefaultAndroidResourceReader
implements ResourceReader {
    @NotNull
    public static final DefaultAndroidResourceReader INSTANCE = new DefaultAndroidResourceReader();
    @NotNull
    private static final Lazy assets$delegate = LazyKt.lazy(DefaultAndroidResourceReader::assets_delegate$lambda$0);
    public static final int $stable = 8;

    private DefaultAndroidResourceReader() {
    }

    private final AssetManager getAssets() {
        Lazy lazy = assets$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (AssetManager)object;
    }

    private final AssetManager getInstrumentedAssets() {
        AssetManager assetManager;
        try {
            assetManager = AndroidContextProviderKt.getAndroidInstrumentedContext().getAssets();
        }
        catch (NoClassDefFoundError e) {
            Log.d((String)"ResourceReader", (String)"Android Instrumentation context is not available.");
            assetManager = null;
        }
        return assetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object read(@NotNull String path, @NotNull Continuation<? super byte[]> $completion) {
        byte[] byArray;
        InputStream resource = this.getResourceAsStream(path);
        Closeable closeable = resource;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            byArray = ByteStreamsKt.readBytes((InputStream)input);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object readPart(@NotNull String path, long offset, long size, @NotNull Continuation<? super byte[]> $completion) {
        InputStream resource = this.getResourceAsStream(path);
        byte[] result = new byte[(int)size];
        Closeable closeable = resource;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            INSTANCE.skipBytes(input, offset);
            INSTANCE.readBytes(input, result, 0, (int)size);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return result;
    }

    private final void skipBytes(InputStream $this$skipBytes, long offset) {
        long count;
        for (long skippedBytes = 0L; skippedBytes < offset && (count = $this$skipBytes.skip(offset - skippedBytes)) != 0L; skippedBytes += count) {
        }
    }

    private final void readBytes(InputStream $this$readBytes, byte[] byteArray, int offset, int size) {
        int count;
        for (int readBytes = 0; readBytes < size && (count = $this$readBytes.read(byteArray, offset + readBytes, size - readBytes)) > 0; readBytes += count) {
        }
    }

    @Override
    @NotNull
    public String getUri(@NotNull String path) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.hasFile(this.getAssets(), path) || this.hasFile(this.getInstrumentedAssets(), path)) {
            comparable = (Comparable)Uri.parse((String)("file:///android_asset/" + path));
        } else {
            ClassLoader classLoader = this.getClassLoader();
            URL uRL = classLoader.getResource(path);
            if (uRL == null) {
                throw new MissingResourceException(path);
            }
            URL resource = uRL;
            comparable = resource.toURI();
        }
        Comparable uri = comparable;
        return uri.toString();
    }

    private final InputStream getResourceAsStream(String path) {
        InputStream inputStream;
        try {
            inputStream = this.getAssets().open(path);
            Intrinsics.checkNotNull((Object)inputStream);
        }
        catch (FileNotFoundException e) {
            InputStream inputStream2;
            try {
                inputStream2 = this.open(this.getInstrumentedAssets(), path);
            }
            catch (FileNotFoundException e2) {
                ClassLoader classLoader = this.getClassLoader();
                InputStream inputStream3 = classLoader.getResourceAsStream(path);
                if (inputStream3 == null) {
                    throw new MissingResourceException(path);
                }
                inputStream2 = inputStream3;
            }
            inputStream = inputStream2;
        }
        return inputStream;
    }

    private final ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Cannot find class loader".toString());
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasFile(AssetManager $this$hasFile, String path) {
        boolean bl;
        InputStream inputStream = null;
        try {
            inputStream = this.open($this$hasFile, path);
            bl = true;
        }
        catch (FileNotFoundException e) {
            bl = false;
        }
        finally {
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        boolean result = bl;
        return result;
    }

    private final InputStream open(AssetManager $this$open, String path) {
        Object object = $this$open;
        if (object == null || (object = object.open(path)) == null) {
            throw new FileNotFoundException("Current AssetManager is null.");
        }
        return object;
    }

    private static final AssetManager assets_delegate$lambda$0() {
        Context context = AndroidContextProviderKt.getAndroidContext();
        if (context == null) {
            throw new IllegalStateException("Android context is not initialized. If it happens in the Preview mode then call PreviewContextConfigurationEffect() function.".toString());
        }
        Context context2 = context;
        return context2.getAssets();
    }
}

