/*
 * Decompiled with CFR 0.152.
 */
package org.jellyfin.sdk.api.sockets;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jellyfin.sdk.api.client.ApiClient;
import org.jellyfin.sdk.api.client.util.ApiSerializer;
import org.jellyfin.sdk.api.client.util.AuthorizationHeaderBuilder;
import org.jellyfin.sdk.api.client.util.UrlBuilder;
import org.jellyfin.sdk.api.sockets.SocketConnectionFactory;
import org.jellyfin.sdk.api.sockets.SocketInstance;
import org.jellyfin.sdk.api.sockets.SocketInstanceConnection;
import org.jellyfin.sdk.api.sockets.SocketInstanceKt;
import org.jellyfin.sdk.api.sockets.SocketInstanceState;
import org.jellyfin.sdk.api.sockets.data.SubscriptionType;
import org.jellyfin.sdk.api.sockets.exception.SocketStoppedException;
import org.jellyfin.sdk.api.sockets.helper.KeepAliveHelper;
import org.jellyfin.sdk.api.sockets.helper.ListenerHelper;
import org.jellyfin.sdk.api.sockets.helper.ReconnectHelper;
import org.jellyfin.sdk.api.sockets.listener.SocketListener;
import org.jellyfin.sdk.api.sockets.listener.SocketListenerDefinition;
import org.jellyfin.sdk.model.ClientInfo;
import org.jellyfin.sdk.model.DeviceInfo;
import org.jellyfin.sdk.model.socket.ForceKeepAliveMessage;
import org.jellyfin.sdk.model.socket.IncomingSocketMessage;
import org.jellyfin.sdk.model.socket.OutgoingSocketMessage;
import org.jellyfin.sdk.model.socket.PeriodicListenerPeriod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 @2\u00020\u0001:\u0001@B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\rH\u0002J\u0019\u00101\u001a\u00020/2\u0006\u00102\u001a\u000203H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u00105\u001a\u00020/H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u00020/2\u0006\u00108\u001a\u00020+J\u0011\u00109\u001a\u00020/H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0011\u0010:\u001a\u00020\u0018H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0011\u0010;\u001a\u00020\u0018H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0011\u0010<\u001a\u00020/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u001f\u0010=\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010>\u001a\u00020\u0014H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Lorg/jellyfin/sdk/api/sockets/SocketInstance;", "", "api", "Lorg/jellyfin/sdk/api/client/ApiClient;", "socketConnectionFactory", "Lorg/jellyfin/sdk/api/sockets/SocketConnectionFactory;", "context", "Lkotlin/coroutines/CoroutineContext;", "(Lorg/jellyfin/sdk/api/client/ApiClient;Lorg/jellyfin/sdk/api/sockets/SocketConnectionFactory;Lkotlin/coroutines/CoroutineContext;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jellyfin/sdk/api/sockets/SocketInstanceState;", "accessToken", "", "baseUrl", "clientInfo", "Lorg/jellyfin/sdk/model/ClientInfo;", "connection", "Lorg/jellyfin/sdk/api/sockets/SocketInstanceConnection;", "connectionScope", "Lkotlinx/coroutines/CoroutineScope;", "coroutineContext", "coroutineScope", "credentialsChanged", "", "deviceInfo", "Lorg/jellyfin/sdk/model/DeviceInfo;", "incomingMessages", "Lkotlinx/coroutines/channels/Channel;", "keepAliveHelper", "Lorg/jellyfin/sdk/api/sockets/helper/KeepAliveHelper;", "listenerHelper", "Lorg/jellyfin/sdk/api/sockets/helper/ListenerHelper;", "outgoingMessages", "reconnectHelper", "Lorg/jellyfin/sdk/api/sockets/helper/ReconnectHelper;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "updateConnectionStateMutex", "Lkotlinx/coroutines/sync/Mutex;", "addListenerDefinition", "Lorg/jellyfin/sdk/api/sockets/listener/SocketListener;", "definition", "Lorg/jellyfin/sdk/api/sockets/listener/SocketListenerDefinition;", "forwardMessage", "", "rawMessage", "publish", "message", "Lorg/jellyfin/sdk/model/socket/OutgoingSocketMessage;", "(Lorg/jellyfin/sdk/model/socket/OutgoingSocketMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reconnect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeListener", "listener", "stop", "updateConnectionState", "updateCredentials", "updateSubscriptions", "connectAndBind", "scope", "(Lorg/jellyfin/sdk/api/sockets/SocketInstanceConnection;Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "jellyfin-api"})
public final class SocketInstance {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApiClient api;
    @NotNull
    private final SocketConnectionFactory socketConnectionFactory;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final CoroutineScope coroutineScope;
    private boolean credentialsChanged;
    @Nullable
    private String baseUrl;
    @Nullable
    private String accessToken;
    @NotNull
    private ClientInfo clientInfo;
    @NotNull
    private DeviceInfo deviceInfo;
    @NotNull
    private final MutableStateFlow<SocketInstanceState> _state;
    @NotNull
    private final StateFlow<SocketInstanceState> state;
    @Nullable
    private SocketInstanceConnection connection;
    @Nullable
    private CoroutineScope connectionScope;
    @NotNull
    private final ReconnectHelper reconnectHelper;
    @NotNull
    private final Channel<String> incomingMessages;
    @NotNull
    private final Channel<String> outgoingMessages;
    @NotNull
    private final ListenerHelper listenerHelper;
    @NotNull
    private final KeepAliveHelper keepAliveHelper;
    @NotNull
    private final Mutex updateConnectionStateMutex;
    @Deprecated
    @NotNull
    private static final String SOCKET_URL = "/socket";
    @Deprecated
    private static final long MESSAGE_INTERVAL = 1000L;

    public SocketInstance(@NotNull ApiClient api, @NotNull SocketConnectionFactory socketConnectionFactory, @NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)socketConnectionFactory, (String)"socketConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.api = api;
        this.socketConnectionFactory = socketConnectionFactory;
        this.coroutineContext = context.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null));
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.coroutineContext);
        this.baseUrl = this.api.getBaseUrl();
        this.accessToken = this.api.getAccessToken();
        this.clientInfo = this.api.getClientInfo();
        this.deviceInfo = this.api.getDeviceInfo();
        this._state = StateFlowKt.MutableStateFlow((Object)((Object)SocketInstanceState.DISCONNECTED));
        this.state = (StateFlow)this._state;
        this.reconnectHelper = new ReconnectHelper(this.coroutineScope, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>((Object)this){

            @Nullable
            public final Object invoke(@NotNull Continuation<? super Unit> $completion) {
                return ((SocketInstance)this.receiver).reconnect($completion);
            }
        }));
        this.incomingMessages = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        this.outgoingMessages = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        this.listenerHelper = new ListenerHelper();
        this.keepAliveHelper = new KeepAliveHelper(this.coroutineScope);
        this.updateConnectionStateMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    public /* synthetic */ SocketInstance(ApiClient apiClient, SocketConnectionFactory socketConnectionFactory, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(apiClient, socketConnectionFactory, coroutineContext);
    }

    @NotNull
    public final StateFlow<SocketInstanceState> getState() {
        return this.state;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateCredentials(@NotNull Continuation<? super Boolean> var1_1) {
        block13: {
            if (!(var1_1 instanceof updateCredentials.1)) ** GOTO lbl-1000
            var7_2 = var1_1;
            if ((var7_2.label & -2147483648) != 0) {
                var7_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ SocketInstance this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.updateCredentials((Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    SocketInstanceKt.access$getLogger$p().debug((Function0)updateCredentials.2.INSTANCE);
                    if (this.state.getValue() == SocketInstanceState.ERROR) {
                        SocketInstanceKt.access$getLogger$p().info((Function0)updateCredentials.3.INSTANCE);
                        return Boxing.boxBoolean((boolean)false);
                    }
                    if (this.api.getBaseUrl() == null) {
                        SocketInstanceKt.access$getLogger$p().info((Function0)updateCredentials.4.INSTANCE);
                        v0 = this.connection;
                        if (v0 == null) break;
                        $continuation.L$0 = this;
                        $continuation.label = 1;
                        v1 = v0.disconnect((Continuation<? super Unit>)$continuation);
                        if (v1 == var8_4) {
                            return var8_4;
                        }
                        break;
                    }
                    break block13;
                }
                case 1: {
                    this = (SocketInstance)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    break;
                }
            }
            this._state.setValue((Object)SocketInstanceState.ERROR);
            return Boxing.boxBoolean((boolean)false);
        }
        v2 = this.api.getBaseUrl();
        if (v2 == null) {
            var4_5 = "Required value was null.";
            throw new IllegalArgumentException(var4_5.toString());
        }
        newBaseUrl = v2;
        newAccessToken = this.api.getAccessToken();
        newClientInfo = this.api.getClientInfo();
        newDeviceInfo = this.api.getDeviceInfo();
        if (Intrinsics.areEqual((Object)this.baseUrl, (Object)newBaseUrl) && Intrinsics.areEqual((Object)this.accessToken, (Object)newAccessToken) && Intrinsics.areEqual((Object)this.clientInfo, (Object)newClientInfo) && Intrinsics.areEqual((Object)this.deviceInfo, (Object)newDeviceInfo)) {
            SocketInstanceKt.access$getLogger$p().debug((Function0)updateCredentials.5.INSTANCE);
            return Boxing.boxBoolean((boolean)false);
        }
        SocketInstanceKt.access$getLogger$p().info((Function0)new Function0<Object>(this){
            final /* synthetic */ SocketInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Updating credentials for " + SocketInstance.access$getBaseUrl$p(this.this$0);
            }
        });
        this.baseUrl = newBaseUrl;
        this.accessToken = newAccessToken;
        this.clientInfo = newClientInfo;
        this.deviceInfo = newDeviceInfo;
        this.credentialsChanged = true;
        $continuation.label = 2;
        v3 = this.updateConnectionState((Continuation<? super Boolean>)$continuation);
        if (v3 == var8_4) {
            return var8_4;
        }
        ** GOTO lbl60
        {
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl60:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object updateConnectionState(Continuation<? super Boolean> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[SWITCH], 8[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateSubscriptions(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof updateSubscriptions.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ SocketInstance this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SocketInstance.access$updateSubscriptions(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                subscriptions = this.listenerHelper.getSubscriptions();
                var3_6 = CollectionsKt.reversed((Iterable)this.listenerHelper.getActiveSubscriptions()).iterator();
lbl14:
                // 3 sources

                while (var3_6.hasNext()) {
                    subscription = (SubscriptionType)var3_6.next();
                    if (subscriptions.contains(subscription)) continue;
                    SocketInstanceKt.access$getLogger$p().info((Function0)new Function0<Object>(subscription){
                        final /* synthetic */ SubscriptionType<?> $subscription;
                        {
                            this.$subscription = $subscription;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Removing subscription for " + this.$subscription.getMessageType().getSimpleName();
                        }
                    });
                    $continuation.L$0 = this;
                    $continuation.L$1 = subscriptions;
                    $continuation.L$2 = var3_6;
                    $continuation.L$3 = subscription;
                    $continuation.label = 1;
                    v0 = this.publish((OutgoingSocketMessage)subscription.getCreateStopMessage().invoke(), (Continuation<? super Unit>)$continuation);
                    if (v0 == var8_4) {
                        return var8_4;
                    }
                    ** GOTO lbl35
                }
                break;
            }
            case 1: {
                subscription = (SubscriptionType)$continuation.L$3;
                var3_6 = (Iterator<E>)$continuation.L$2;
                subscriptions = (List)$continuation.L$1;
                this = (SocketInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                this.listenerHelper.getActiveSubscriptions().remove(subscription);
                ** GOTO lbl14
            }
        }
        period = new PeriodicListenerPeriod(0L, 1000L);
        var4_7 = subscriptions.iterator();
lbl40:
        // 3 sources

        while (var4_7.hasNext()) {
            subscription = (SubscriptionType)var4_7.next();
            if (this.listenerHelper.getActiveSubscriptions().contains(subscription)) continue;
            SocketInstanceKt.access$getLogger$p().info((Function0)new Function0<Object>(subscription){
                final /* synthetic */ SubscriptionType<?> $subscription;
                {
                    this.$subscription = $subscription;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Adding subscription for " + this.$subscription.getMessageType().getSimpleName();
                }
            });
            $continuation.L$0 = this;
            $continuation.L$1 = period;
            $continuation.L$2 = var4_7;
            $continuation.L$3 = subscription;
            $continuation.label = 2;
            v1 = this.publish((OutgoingSocketMessage)subscription.getCreateStartMessage().invoke((Object)period), (Continuation<? super Unit>)$continuation);
            if (v1 == var8_4) {
                return var8_4;
            }
            ** GOTO lbl61
        }
        {
            break;
            case 2: {
                subscription = (SubscriptionType)$continuation.L$3;
                var4_7 = (Iterator<E>)$continuation.L$2;
                period = (PeriodicListenerPeriod)$continuation.L$1;
                this = (SocketInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl61:
                // 2 sources

                this.listenerHelper.getActiveSubscriptions().add(subscription);
                ** GOTO lbl40
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object reconnect(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof reconnect.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SocketInstance this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.reconnect((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                SocketInstanceKt.access$getLogger$p().debug((Function0)reconnect.2.INSTANCE);
                if (this.state.getValue() == SocketInstanceState.CONNECTING) {
                    return Unit.INSTANCE;
                }
                if (this.state.getValue() == SocketInstanceState.STOPPED) {
                    throw new SocketStoppedException();
                }
                SocketInstanceKt.access$getLogger$p().info((Function0)reconnect.3.INSTANCE);
                this._state.setValue((Object)SocketInstanceState.CONNECTING);
                v0 = this.connection;
                if (v0 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = v0.disconnect((Continuation<? super Unit>)$continuation);
                if (v1 == var5_4) {
                    return var5_4;
                }
                break;
            }
            case 1: {
                this = (SocketInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        v2 = this.connectionScope;
        if (v2 != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)v2, null, (int)1, null);
        }
        this.reconnectHelper.notifyReconnect();
        if (this.baseUrl == null) {
            SocketInstanceKt.access$getLogger$p().info((Function0)reconnect.4.INSTANCE);
            this._state.setValue((Object)SocketInstanceState.DISCONNECTED);
            return Unit.INSTANCE;
        }
        this.connectionScope = scope = CoroutineScopeKt.plus((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SocketInstance this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        var3_4 = this.this$0;
                        var4_5 = this.this$0;
                        this.L$0 = $this$launch;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.label = 1;
                        v0 = SocketInstance.access$getSocketConnectionFactory$p(this.this$0).create(SocketInstance.access$getApi$p(this.this$0).getHttpClientOptions(), (Channel<String>)SocketInstance.access$getIncomingMessages$p(this.this$0), $this$launch.getCoroutineContext(), (Continuation<? super SocketInstanceConnection>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        var4_5 = (SocketInstance)this.L$2;
                        var3_4 = (SocketInstance)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        this.L$0 = var3_4;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 2;
                        v1 = SocketInstance.access$connectAndBind(var4_5, (SocketInstanceConnection)v0, $this$launch, (Continuation)this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl34
                    }
                    case 2: {
                        var3_4 = (SocketInstance)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl34:
                        // 2 sources

                        SocketInstance.access$setConnection$p(var3_4, (SocketInstanceConnection)v1);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object connectAndBind(SocketInstanceConnection var1_1, CoroutineScope var2_2, Continuation<? super SocketInstanceConnection> var3_3) {
        if (!(var3_3 instanceof connectAndBind.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ SocketInstance this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SocketInstance.access$connectAndBind(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.baseUrl;
                if (v0 == null) {
                    var6_7 = "Required value was null.";
                    throw new IllegalArgumentException(var6_7.toString());
                }
                var5_10 = UrlBuilder.buildUrl$default(UrlBuilder.INSTANCE, v0, "/socket", null, null, false, 28, null);
                var6_8 = new Regex("^http");
                var7_11 = "ws";
                url = var6_8.replace(var5_10, var7_11);
                authorizationHeader = AuthorizationHeaderBuilder.INSTANCE.buildHeader(this.clientInfo.getName(), this.clientInfo.getVersion(), this.deviceInfo.getId(), this.deviceInfo.getName(), this.accessToken);
                $continuation.L$0 = this;
                $continuation.L$1 = $this$connectAndBind;
                $continuation.L$2 = scope;
                $continuation.label = 1;
                v1 = $this$connectAndBind.connect(url, authorizationHeader, (Continuation<? super Boolean>)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl35
            }
            case 1: {
                scope = (CoroutineScope)$continuation.L$2;
                $this$connectAndBind = (SocketInstanceConnection)$continuation.L$1;
                this = (SocketInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                if (!(connected = ((Boolean)v1).booleanValue())) {
                    this._state.setValue((Object)SocketInstanceState.ERROR);
                    this.reconnectHelper.scheduleReconnect(true);
                    return null;
                }
                BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ SocketInstance this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = SocketInstance.access$getIncomingMessages$p(this.this$0).iterator();
lbl6:
                                // 2 sources

                                while (true) {
                                    this.L$0 = var2_3;
                                    this.label = 1;
                                    v0 = var2_3.hasNext((Continuation)this);
                                    if (v0 == var4_2) {
                                        return var4_2;
                                    }
                                    ** GOTO lbl17
                                    break;
                                }
                            }
                            case 1: {
                                var2_3 = (ChannelIterator)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                if (((Boolean)v0).booleanValue()) {
                                    message = (String)var2_3.next();
                                    SocketInstance.access$forwardMessage(this.this$0, message);
                                    ** continue;
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, $this$connectAndBind, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ SocketInstance this$0;
                    final /* synthetic */ SocketInstanceConnection $this_connectAndBind;
                    {
                        this.this$0 = $receiver;
                        this.$this_connectAndBind = $receiver2;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = SocketInstance.access$getOutgoingMessages$p(this.this$0).iterator();
lbl6:
                                // 2 sources

                                while (true) {
                                    this.L$0 = var2_3;
                                    this.label = 1;
                                    v0 = var2_3.hasNext((Continuation)this);
                                    if (v0 == var4_2) {
                                        return var4_2;
                                    }
                                    ** GOTO lbl17
                                    break;
                                }
                            }
                            case 1: {
                                var2_3 = (ChannelIterator)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                if (!((Boolean)v0).booleanValue()) break;
                                message = (String)var2_3.next();
                                this.L$0 = var2_3;
                                this.label = 2;
                                v1 = this.$this_connectAndBind.send(message, (Continuation<? super Boolean>)((Continuation)this));
                                if (v1 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl29
                            }
                            case 2: {
                                var2_3 = (ChannelIterator)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl29:
                                // 2 sources

                                ** continue;
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$connectAndBind, this, null){
                    int label;
                    final /* synthetic */ SocketInstanceConnection $this_connectAndBind;
                    final /* synthetic */ SocketInstance this$0;
                    {
                        this.$this_connectAndBind = $receiver;
                        this.this$0 = $receiver2;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = FlowKt.first((Flow)((Flow)this.$this_connectAndBind.getState()), (Function2)((Function2)new Function2<SocketInstanceState, Continuation<? super Boolean>, Object>(null){
                                    int label;
                                    /* synthetic */ Object L$0;

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                SocketInstanceState it = (SocketInstanceState)((Object)this.L$0);
                                                return Boxing.boxBoolean((it != SocketInstanceState.CONNECTED ? 1 : 0) != 0);
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        Function2<SocketInstanceState, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        function2.L$0 = value;
                                        return (Continuation)function2;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull SocketInstanceState p1, @Nullable Continuation<? super Boolean> p2) {
                                        return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                disconnectState = (SocketInstanceState)v0;
                                if (SocketInstance.access$get_state$p(this.this$0).getValue() == SocketInstanceState.CONNECTED) {
                                    scheduled = SocketInstance.access$getReconnectHelper$p(this.this$0).scheduleReconnect(disconnectState == SocketInstanceState.ERROR);
                                    SocketInstance.access$get_state$p(this.this$0).setValue((Object)(scheduled == false ? SocketInstanceState.ERROR : SocketInstanceState.DISCONNECTED));
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                this.listenerHelper.getActiveSubscriptions().clear();
                $continuation.L$0 = this;
                $continuation.L$1 = $this$connectAndBind;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v2 = this.updateSubscriptions((Continuation<? super Unit>)$continuation);
                if (v2 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl60
            }
            case 2: {
                $this$connectAndBind = (SocketInstanceConnection)$continuation.L$1;
                this = (SocketInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl60:
                // 2 sources

                this._state.setValue((Object)SocketInstanceState.CONNECTED);
                this.reconnectHelper.notifyConnected();
                return $this$connectAndBind;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof stop.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SocketInstance this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                SocketInstanceKt.access$getLogger$p().info((Function0)stop.2.INSTANCE);
                v0 = this.connection;
                if (v0 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = v0.disconnect((Continuation<? super Unit>)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                break;
            }
            case 1: {
                this = (SocketInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        v2 = this.connectionScope;
        if (v2 != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)v2, null, (int)1, null);
        }
        this.listenerHelper.reset();
        this.reconnectHelper.reset();
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.incomingMessages), null, (int)1, null);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.outgoingMessages), null, (int)1, null);
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this._state.setValue((Object)SocketInstanceState.STOPPED);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final SocketListener addListenerDefinition(@NotNull SocketListenerDefinition definition2) {
        Intrinsics.checkNotNullParameter((Object)definition2, (String)"definition");
        SocketListener listener2 = this.listenerHelper.addListenerDefinition(this, definition2);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SocketInstance this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SocketInstance.access$updateConnectionState(this.this$0, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return listener2;
    }

    public final void removeListener(@NotNull SocketListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listenerHelper.removeListener(listener2);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SocketInstance this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SocketInstance.access$updateConnectionState(this.this$0, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void forwardMessage(String rawMessage) {
        IncomingSocketMessage incomingSocketMessage = ApiSerializer.INSTANCE.decodeSocketMessage(rawMessage);
        if (incomingSocketMessage == null) {
            return;
        }
        IncomingSocketMessage message = incomingSocketMessage;
        if (message instanceof ForceKeepAliveMessage) {
            this.keepAliveHelper.reset-HG0u8IE(this, DurationKt.toDuration((int)((ForceKeepAliveMessage)message).getValue(), (DurationUnit)DurationUnit.SECONDS));
        } else {
            this.listenerHelper.forwardMessage(message);
        }
    }

    @Nullable
    public final Object publish(@NotNull OutgoingSocketMessage message, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.outgoingMessages.send((Object)ApiSerializer.INSTANCE.encodeSocketMessage(message), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getBaseUrl$p(SocketInstance $this) {
        return $this.baseUrl;
    }

    public static final /* synthetic */ Object access$updateConnectionState(SocketInstance $this, Continuation $completion) {
        return $this.updateConnectionState((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$updateSubscriptions(SocketInstance $this, Continuation $completion) {
        return $this.updateSubscriptions((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$setConnection$p(SocketInstance $this, SocketInstanceConnection socketInstanceConnection) {
        $this.connection = socketInstanceConnection;
    }

    public static final /* synthetic */ Object access$connectAndBind(SocketInstance $this, SocketInstanceConnection $receiver, CoroutineScope scope, Continuation $completion) {
        return $this.connectAndBind($receiver, scope, (Continuation<? super SocketInstanceConnection>)$completion);
    }

    public static final /* synthetic */ SocketConnectionFactory access$getSocketConnectionFactory$p(SocketInstance $this) {
        return $this.socketConnectionFactory;
    }

    public static final /* synthetic */ ApiClient access$getApi$p(SocketInstance $this) {
        return $this.api;
    }

    public static final /* synthetic */ Channel access$getIncomingMessages$p(SocketInstance $this) {
        return $this.incomingMessages;
    }

    public static final /* synthetic */ void access$forwardMessage(SocketInstance $this, String rawMessage) {
        $this.forwardMessage(rawMessage);
    }

    public static final /* synthetic */ Channel access$getOutgoingMessages$p(SocketInstance $this) {
        return $this.outgoingMessages;
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(SocketInstance $this) {
        return $this._state;
    }

    public static final /* synthetic */ ReconnectHelper access$getReconnectHelper$p(SocketInstance $this) {
        return $this.reconnectHelper;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jellyfin/sdk/api/sockets/SocketInstance$Companion;", "", "()V", "MESSAGE_INTERVAL", "", "SOCKET_URL", "", "jellyfin-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

