/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.client.constant.Constants;
import com.alibaba.nacos.client.naming.core.ServerListManager;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientManager;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.alibaba.nacos.client.naming.utils.InitUtils;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ValidatorUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class NacosNamingMaintainService
implements NamingMaintainService {
    private String namespace;
    private NamingHttpClientProxy serverProxy;
    private ServerListManager serverListManager;
    private SecurityProxy securityProxy;
    private ScheduledExecutorService executorService;

    public NacosNamingMaintainService(String serverList) throws NacosException {
        Properties properties = new Properties();
        properties.setProperty("serverAddr", serverList);
        this.init(properties);
    }

    public NacosNamingMaintainService(Properties properties) throws NacosException {
        this.init(properties);
    }

    private void init(Properties properties) throws NacosException {
        ValidatorUtils.checkInitParam(properties);
        this.namespace = InitUtils.initNamespaceForNaming(properties);
        InitUtils.initSerialization();
        InitUtils.initWebRootContext(properties);
        this.serverListManager = new ServerListManager(properties, this.namespace);
        this.securityProxy = new SecurityProxy(properties, NamingHttpClientManager.getInstance().getNacosRestTemplate());
        this.initSecurityProxy();
        this.serverProxy = new NamingHttpClientProxy(this.namespace, this.securityProxy, this.serverListManager, properties, null);
    }

    private void initSecurityProxy() {
        this.executorService = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName("com.alibaba.nacos.client.naming.maintainService.security");
            t.setDaemon(true);
            return t;
        });
        this.securityProxy.login(this.serverListManager.getServerList());
        this.executorService.scheduleWithFixedDelay(() -> this.securityProxy.login(this.serverListManager.getServerList()), 0L, Constants.Security.SECURITY_INFO_REFRESH_INTERVAL_MILLS, TimeUnit.MILLISECONDS);
    }

    public void updateInstance(String serviceName, Instance instance) throws NacosException {
        this.updateInstance(serviceName, "DEFAULT_GROUP", instance);
    }

    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        this.serverProxy.updateInstance(serviceName, groupName, instance);
    }

    public Service queryService(String serviceName) throws NacosException {
        return this.queryService(serviceName, "DEFAULT_GROUP");
    }

    public Service queryService(String serviceName, String groupName) throws NacosException {
        return this.serverProxy.queryService(serviceName, groupName);
    }

    public void createService(String serviceName) throws NacosException {
        this.createService(serviceName, "DEFAULT_GROUP");
    }

    public void createService(String serviceName, String groupName) throws NacosException {
        this.createService(serviceName, groupName, 0.0f);
    }

    public void createService(String serviceName, String groupName, float protectThreshold) throws NacosException {
        Service service = new Service();
        service.setName(serviceName);
        service.setGroupName(groupName);
        service.setProtectThreshold(protectThreshold);
        this.createService(service, (AbstractSelector)new NoneSelector());
    }

    public void createService(String serviceName, String groupName, float protectThreshold, String expression) throws NacosException {
        Service service = new Service();
        service.setName(serviceName);
        service.setGroupName(groupName);
        service.setProtectThreshold(protectThreshold);
        ExpressionSelector selector = new ExpressionSelector();
        selector.setExpression(expression);
        this.createService(service, (AbstractSelector)selector);
    }

    public void createService(Service service, AbstractSelector selector) throws NacosException {
        this.serverProxy.createService(service, selector);
    }

    public boolean deleteService(String serviceName) throws NacosException {
        return this.deleteService(serviceName, "DEFAULT_GROUP");
    }

    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        return this.serverProxy.deleteService(serviceName, groupName);
    }

    public void updateService(String serviceName, String groupName, float protectThreshold) throws NacosException {
        Service service = new Service();
        service.setName(serviceName);
        service.setGroupName(groupName);
        service.setProtectThreshold(protectThreshold);
        this.updateService(service, (AbstractSelector)new NoneSelector());
    }

    public void updateService(String serviceName, String groupName, float protectThreshold, Map<String, String> metadata) throws NacosException {
        Service service = new Service();
        service.setName(serviceName);
        service.setGroupName(groupName);
        service.setProtectThreshold(protectThreshold);
        service.setMetadata(metadata);
        this.updateService(service, (AbstractSelector)new NoneSelector());
    }

    public void updateService(Service service, AbstractSelector selector) throws NacosException {
        this.serverProxy.updateService(service, selector);
    }

    public void shutDown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        this.serverListManager.shutdown();
        this.serverProxy.shutdown();
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executorService, (Logger)LogUtils.NAMING_LOGGER);
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

