/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.identify;

import com.alibaba.nacos.common.utils.StringUtils;

public class StsConfig {
    private static final String RAM_SECURITY_CREDENTIALS_URL = "http://100.100.100.200/latest/meta-data/ram/security-credentials/";
    private String ramRoleName;
    private int timeToRefreshInMillisecond = 180000;
    private String securityCredentialsUrl;
    private String securityCredentials;
    private boolean cacheSecurityCredentials = true;

    private StsConfig() {
        String cacheSecurityCredentials;
        String securityCredentialsUrl;
        String securityCredentials;
        String timeToRefreshInMillisecond;
        String ramRoleName = System.getProperty("ram.role.name");
        if (!StringUtils.isBlank((CharSequence)ramRoleName)) {
            this.setRamRoleName(ramRoleName);
        }
        if (!StringUtils.isBlank((CharSequence)(timeToRefreshInMillisecond = System.getProperty("time.to.refresh.in.millisecond")))) {
            this.setTimeToRefreshInMillisecond(Integer.parseInt(timeToRefreshInMillisecond));
        }
        if (!StringUtils.isBlank((CharSequence)(securityCredentials = System.getProperty("security.credentials")))) {
            this.setSecurityCredentials(securityCredentials);
        }
        if (!StringUtils.isBlank((CharSequence)(securityCredentialsUrl = System.getProperty("security.credentials.url")))) {
            this.setSecurityCredentialsUrl(securityCredentialsUrl);
        }
        if (!StringUtils.isBlank((CharSequence)(cacheSecurityCredentials = System.getProperty("cache.security.credentials")))) {
            this.setCacheSecurityCredentials(Boolean.parseBoolean(cacheSecurityCredentials));
        }
    }

    public static StsConfig getInstance() {
        return Singleton.INSTANCE;
    }

    public String getRamRoleName() {
        return this.ramRoleName;
    }

    public void setRamRoleName(String ramRoleName) {
        this.ramRoleName = ramRoleName;
    }

    public int getTimeToRefreshInMillisecond() {
        return this.timeToRefreshInMillisecond;
    }

    public void setTimeToRefreshInMillisecond(int timeToRefreshInMillisecond) {
        this.timeToRefreshInMillisecond = timeToRefreshInMillisecond;
    }

    public String getSecurityCredentialsUrl() {
        if (this.securityCredentialsUrl == null && this.ramRoleName != null) {
            return RAM_SECURITY_CREDENTIALS_URL + this.ramRoleName;
        }
        return this.securityCredentialsUrl;
    }

    public void setSecurityCredentialsUrl(String securityCredentialsUrl) {
        this.securityCredentialsUrl = securityCredentialsUrl;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public boolean isStsOn() {
        return StringUtils.isNotEmpty((String)this.getSecurityCredentials()) || StringUtils.isNotEmpty((String)this.getSecurityCredentialsUrl());
    }

    public boolean isCacheSecurityCredentials() {
        return this.cacheSecurityCredentials;
    }

    public void setCacheSecurityCredentials(boolean cacheSecurityCredentials) {
        this.cacheSecurityCredentials = cacheSecurityCredentials;
    }

    private static class Singleton {
        private static final StsConfig INSTANCE = new StsConfig();

        private Singleton() {
        }
    }
}

