/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class MiniDaoUtil {
    public static final String DATABSE_TYPE_MYSQL = "mysql";
    public static final String DATABSE_TYPE_POSTGRE = "postgresql";
    public static final String DATABSE_TYPE_ORACLE = "oracle";
    public static final String DATABSE_TYPE_SQLSERVER = "sqlserver";
    public static final String MYSQL_SQL = "select * from ( {0}) sel_tab00 limit {1},{2}";
    public static final String POSTGRE_SQL = "select * from ( {0}) sel_tab00 limit {2} offset {1}";
    public static final String ORACLE_SQL = "select * from (select row_.*,rownum rownum_ from ({0}) row_ where rownum <= {1}) where rownum_>{2}";
    public static final String SQLSERVER_SQL = "select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}";
    private static final Logger logger = Logger.getLogger(MiniDaoUtil.class);

    public static String createPageSql(String dbType, String sql, int page, int rows) {
        int beginNum = (page - 1) * rows;
        Object[] sqlParam = new String[]{sql, beginNum + "", rows + ""};
        String jdbcType = dbType;
        if (jdbcType == null || "".equals(jdbcType)) {
            throw new RuntimeException("org.jeecgframework.minidao.aop.MiniDaoHandler:(\u6570\u636e\u5e93\u7c7b\u578b:dbType)\u6ca1\u6709\u8bbe\u7f6e,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        if (jdbcType.indexOf(DATABSE_TYPE_MYSQL) != -1) {
            sql = MessageFormat.format(MYSQL_SQL, sqlParam);
        } else if (jdbcType.indexOf(DATABSE_TYPE_POSTGRE) != -1) {
            sql = MessageFormat.format(POSTGRE_SQL, sqlParam);
        } else {
            int beginIndex = (page - 1) * rows;
            int endIndex = beginIndex + rows;
            sqlParam[2] = Integer.toString(beginIndex);
            sqlParam[1] = Integer.toString(endIndex);
            if (jdbcType.indexOf(DATABSE_TYPE_ORACLE) != -1) {
                sql = MessageFormat.format(ORACLE_SQL, sqlParam);
            } else if (jdbcType.indexOf(DATABSE_TYPE_SQLSERVER) != -1) {
                sqlParam[0] = sql.substring(MiniDaoUtil.getAfterSelectInsertPoint(sql));
                sql = MessageFormat.format(SQLSERVER_SQL, sqlParam);
            }
        }
        return sql;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    public static String getFirstSmall(String name) {
        if ((name = name.trim()).length() >= 2) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name.toLowerCase();
    }

    public static String getMethodSqlLogicJar(String sqlurl) {
        StringBuffer sb = new StringBuffer();
        InputStream is = MiniDaoUtil.class.getResourceAsStream(sqlurl);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = "";
        try {
            while ((s = br.readLine()) != null) {
                sb.append(s + " ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static boolean isAbstract(Method method) {
        int mod = method.getModifiers();
        return Modifier.isAbstract(mod);
    }

    public static boolean isWrapClass(Class<?> clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        logger.debug((Object)MiniDaoUtil.isWrapClass(Long.class));
        logger.debug((Object)MiniDaoUtil.isWrapClass(Integer.class));
        logger.debug((Object)MiniDaoUtil.isWrapClass(String.class));
    }
}

