/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.factory;

import java.lang.annotation.Annotation;
import org.jeecgframework.minidao.annotation.MiniDao;
import org.jeecgframework.minidao.aop.MiniDaoHandler;
import org.jeecgframework.minidao.aspect.EmptyInterceptor;
import org.jeecgframework.minidao.factory.MiniDaoClassPathMapperScanner;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.util.StringUtils;

public class MiniDaoBeanScannerConfigurer
implements BeanDefinitionRegistryPostProcessor {
    private String basePackage;
    private Class<? extends Annotation> annotation = MiniDao.class;
    private String keyType = "origin";
    private boolean formatSql = false;
    private boolean showSql = false;
    private String dbType;
    private EmptyInterceptor emptyInterceptor;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registerRequestProxyHandler(registry);
        MiniDaoClassPathMapperScanner scanner = new MiniDaoClassPathMapperScanner(registry, this.annotation);
        scanner.scan(StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n"));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void registerRequestProxyHandler(BeanDefinitionRegistry registry) {
        GenericBeanDefinition jdbcDaoProxyDefinition = new GenericBeanDefinition();
        jdbcDaoProxyDefinition.setBeanClass(MiniDaoHandler.class);
        jdbcDaoProxyDefinition.getPropertyValues().add("formatSql", (Object)this.formatSql);
        jdbcDaoProxyDefinition.getPropertyValues().add("keyType", (Object)this.keyType);
        jdbcDaoProxyDefinition.getPropertyValues().add("showSql", (Object)this.showSql);
        jdbcDaoProxyDefinition.getPropertyValues().add("dbType", (Object)this.dbType);
        jdbcDaoProxyDefinition.getPropertyValues().add("emptyInterceptor", (Object)this.emptyInterceptor);
        registry.registerBeanDefinition("miniDaoHandler", (BeanDefinition)jdbcDaoProxyDefinition);
    }

    public void setAnnotation(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public EmptyInterceptor getEmptyInterceptor() {
        return this.emptyInterceptor;
    }

    public void setEmptyInterceptor(EmptyInterceptor emptyInterceptor) {
        this.emptyInterceptor = emptyInterceptor;
    }
}

