/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.sqlparser.impl.util.JSqlSubSelectBody;

public class JSqlRemoveSqlOrderBy {
    private static final Log logger = LogFactory.getLog(JSqlRemoveSqlOrderBy.class);
    public static Pattern dynamic = Pattern.compile(":[ tnx0Bfr]*[0-9a-z.A-Z_]+");
    public static String DIAN = ".";
    public static String DIAN_TMP = "@@@";

    public String removeOrderBy(String sql) throws JSQLParserException {
        Statement stmt = null;
        List<String> sqList = null;
        try {
            stmt = CCJSqlParserUtil.parse((String)sql, parser -> {
                CCJSqlParser cfr_ignored_0 = (CCJSqlParser)parser.withSquareBracketQuotation(true);
            });
        }
        catch (JSQLParserException e) {
            if (e.toString().indexOf(DIAN) != -1) {
                sqList = JSqlRemoveSqlOrderBy.getKeyListByContent(sql);
                for (String s : sqList) {
                    sql = sql.replace(s, s.replace(DIAN, DIAN_TMP));
                }
                stmt = CCJSqlParserUtil.parse((String)sql, parser -> {
                    CCJSqlParser cfr_ignored_0 = (CCJSqlParser)parser.withSquareBracketQuotation(true);
                });
            } else {
                e.printStackTrace();
            }
            logger.debug((Object)(" --- JSQLParser with DIAN --- convert begin sql=" + sql));
        }
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        this.processSelectBody(selectBody);
        String returnSql = select.toString();
        if (sqList != null) {
            for (String s : sqList) {
                returnSql = returnSql.replace(s.replace(DIAN, DIAN_TMP), s.replace(DIAN_TMP, DIAN));
            }
            logger.debug((Object)(" --- JSQLParser with DIAN --- convert end sql=" + sql));
        }
        return returnSql;
    }

    public static List<String> getKeyListByContent(String content) {
        LinkedHashSet<String> paramSet = new LinkedHashSet<String>();
        Matcher m = dynamic.matcher(content);
        while (m.find()) {
            if (m.group() == null || m.group().indexOf(DIAN) == -1) continue;
            paramSet.add(m.group());
        }
        return new ArrayList<String>(paramSet);
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (JSqlSubSelectBody.getItemSelectBody(withItem) != null) {
                this.processSelectBody(JSqlSubSelectBody.getItemSelectBody(withItem));
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List optSelects = operationList.getSelects();
                for (SelectBody optSelect : optSelects) {
                    if (optSelect instanceof PlainSelect) {
                        this.processPlainSelect((PlainSelect)optSelect);
                        continue;
                    }
                    if (!(optSelect instanceof WithItem)) continue;
                    WithItem withItem = (WithItem)optSelect;
                    this.processSelectBody(withItem.getSubSelect().getSelectBody());
                }
            }
            if (!this.orderByHashParameters(operationList.getOrderByElements())) {
                operationList.setOrderByElements(null);
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null) {
                for (Join j : subJoin.getJoinList()) {
                    if (j.getRightItem() == null) continue;
                    this.processFromItem(j.getRightItem());
                }
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().toUpperCase().contains("?")) continue;
            return true;
        }
        return false;
    }
}

