/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.pagehelper.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CountSqlParser {
    private static final Log logger = LogFactory.getLog(CountSqlParser.class);
    public static final String KEEP_ORDERBY = "/*keep orderby*/";
    private static final Alias TABLE_ALIAS;
    public static Pattern dynamic;
    public static String DIAN;
    public static String DIAN_TMP;
    private final Set<String> skipFunctions = Collections.synchronizedSet(new HashSet());
    private final Set<String> falseFunctions = Collections.synchronizedSet(new HashSet());
    private static final Set<String> AGGREGATE_FUNCTIONS;

    public static void addAggregateFunctions(String functions) {
        if (StringUtils.isNotEmpty((CharSequence)functions)) {
            String[] funs = functions.split(",");
            for (int i = 0; i < funs.length; ++i) {
                AGGREGATE_FUNCTIONS.add(funs[i].toUpperCase());
            }
        }
    }

    public String getSmartCountSql(String sql) {
        return this.getSmartCountSql(sql, "0");
    }

    public String getSmartCountSql(String sql, String countColumn) {
        Statement stmt = null;
        List<String> sqList = null;
        String sqlOriginal = sql;
        if (sql.indexOf(KEEP_ORDERBY) >= 0) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Throwable e) {
            try {
                if (e.toString().indexOf(DIAN) != -1) {
                    sqList = CountSqlParser.getKeyListByContent(sql);
                    for (String s : sqList) {
                        sql = sql.replace(s, s.replace(DIAN, DIAN_TMP));
                    }
                } else {
                    return this.getSimpleCountSql(sqlOriginal, countColumn);
                }
                logger.debug((Object)(" --- JSQLParser with DIAN --- convert begin sql = " + sql));
                stmt = CCJSqlParserUtil.parse((String)sql);
            }
            catch (JSQLParserException e1) {
                logger.warn((Object)("\u65e0\u6cd5\u89e3\u6790\u7528\u666e\u901a\u65b9\u5f0f\u8fd4\u56decount\u8bed\u53e5: " + (e1.getMessage() != null ? e1.getMessage() : e1.getCause().getMessage())));
                return this.getSimpleCountSql(sqlOriginal, countColumn);
            }
        }
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        try {
            this.processSelectBody(selectBody);
        }
        catch (Exception e) {
            return this.getSimpleCountSql(sqlOriginal, countColumn);
        }
        this.processWithItemsList(select.getWithItemsList());
        this.sqlToCount(select, countColumn);
        String result = select.toString();
        if (sqList != null) {
            for (String s : sqList) {
                result = result.replace(s.replace(DIAN, DIAN_TMP), s.replace(DIAN_TMP, DIAN));
            }
            logger.debug((Object)(" --- JSQLParser with DIAN --- convert end sql = " + result));
        }
        return result;
    }

    public static List<String> getKeyListByContent(String content) {
        LinkedHashSet<String> paramSet = new LinkedHashSet<String>();
        Matcher m = dynamic.matcher(content);
        while (m.find()) {
            if (m.group() == null || m.group().indexOf(DIAN) == -1) continue;
            paramSet.add(m.group());
        }
        return new ArrayList<String>(paramSet);
    }

    public String getSimpleCountSql(String sql) {
        return this.getSimpleCountSql(sql, "0");
    }

    public String getSimpleCountSql(String sql, String name) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(");
        stringBuilder.append(name);
        stringBuilder.append(") from ( \n");
        stringBuilder.append(sql);
        stringBuilder.append("\n ) tmp_count");
        return stringBuilder.toString();
    }

    public void sqlToCount(Select select, String name) {
        SelectBody selectBody = select.getSelectBody();
        ArrayList<SelectExpressionItem> COUNT_ITEM = new ArrayList<SelectExpressionItem>();
        COUNT_ITEM.add(new SelectExpressionItem((Expression)new Column("count(" + name + ")")));
        if (selectBody instanceof PlainSelect && this.isSimpleCount((PlainSelect)selectBody)) {
            ((PlainSelect)selectBody).setSelectItems(COUNT_ITEM);
        } else {
            PlainSelect plainSelect = new PlainSelect();
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody(selectBody);
            subSelect.setAlias(TABLE_ALIAS);
            plainSelect.setFromItem((FromItem)subSelect);
            plainSelect.setSelectItems(COUNT_ITEM);
            select.setSelectBody((SelectBody)plainSelect);
        }
    }

    public boolean isSimpleCount(PlainSelect select) {
        if (select.getGroupBy() != null) {
            return false;
        }
        if (select.getDistinct() != null) {
            return false;
        }
        for (SelectItem item : select.getSelectItems()) {
            String NAME;
            String name;
            Expression expression;
            if (item.toString().contains("?")) {
                return false;
            }
            if (!(item instanceof SelectExpressionItem) || !((expression = ((SelectExpressionItem)item).getExpression()) instanceof Function) || (name = ((Function)expression).getName()) == null || this.skipFunctions.contains(NAME = name.toUpperCase())) continue;
            if (this.falseFunctions.contains(NAME)) {
                return false;
            }
            for (String aggregateFunction : AGGREGATE_FUNCTIONS) {
                if (!NAME.startsWith(aggregateFunction)) continue;
                this.falseFunctions.add(NAME);
                return false;
            }
            this.skipFunctions.add(NAME);
        }
        return true;
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSubSelect().getSelectBody() != null) {
                this.processSelectBody(withItem.getSubSelect().getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    this.processSelectBody(plainSelect);
                }
            }
            if (!this.orderByHashParameters(operationList.getOrderByElements())) {
                operationList.setOrderByElements(null);
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processWithItemsList(List<WithItem> withItemsList) {
        if (withItemsList != null && withItemsList.size() > 0) {
            for (WithItem item : withItemsList) {
                this.processSelectBody(item.getSubSelect().getSelectBody());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null && subJoin.getJoinList().size() > 0) {
                for (Join join : subJoin.getJoinList()) {
                    if (join.getRightItem() == null) continue;
                    this.processFromItem(join.getRightItem());
                }
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    static {
        dynamic = Pattern.compile(":[ tnx0Bfr]*[0-9a-z.A-Z_]+");
        DIAN = ".";
        DIAN_TMP = "@@@";
        AGGREGATE_FUNCTIONS = new HashSet<String>(Arrays.asList("APPROX_COUNT_DISTINCT,ARRAY_AGG,AVG,BIT_,BOOL_,CHECKSUM_AGG,COLLECT,CORR,COUNT,COVAR,CUME_DIST,DENSE_RANK,EVERY,FIRST,GROUP,JSON_,LAST,LISTAGG,MAX,MEDIAN,MIN,PERCENT_,RANK,REGR_,SELECTIVITY,STATS_,STD,STRING_AGG,SUM,SYS_OP_ZONE_ID,SYS_XMLAGG,VAR,XMLAGG".split(",")));
        TABLE_ALIAS = new Alias("table_count");
        TABLE_ALIAS.setUseAs(false);
    }
}

